/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.AbstractInputRecipeCache;
import mekanism.common.recipe.lookup.cache.type.ChemicalInputCache;
import mekanism.common.recipe.lookup.cache.type.FluidInputCache;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class RotaryInputRecipeCache
extends AbstractInputRecipeCache<RotaryRecipe> {
    private final ChemicalInputCache<Gas, GasStack, RotaryRecipe> gasInputCache = new ChemicalInputCache();
    private final FluidInputCache<RotaryRecipe> fluidInputCache = new FluidInputCache();
    private final Set<RotaryRecipe> complexGasInputRecipes = new HashSet<RotaryRecipe>();
    private final Set<RotaryRecipe> complexFluidInputRecipes = new HashSet<RotaryRecipe>();

    public RotaryInputRecipeCache(MekanismRecipeType<?, RotaryRecipe, ?> recipeType) {
        super(recipeType);
    }

    @Override
    public void clear() {
        super.clear();
        this.gasInputCache.clear();
        this.fluidInputCache.clear();
        this.complexGasInputRecipes.clear();
        this.complexFluidInputRecipes.clear();
    }

    public boolean containsInput(@Nullable Level world, FluidStack input) {
        return this.containsInput(world, input, RotaryRecipe::getFluidInput, this.fluidInputCache, this.complexFluidInputRecipes);
    }

    public boolean containsInput(@Nullable Level world, GasStack input) {
        return this.containsInput(world, input, RotaryRecipe::getGasInput, this.gasInputCache, this.complexGasInputRecipes);
    }

    @Nullable
    public RotaryRecipe findFirstRecipe(@Nullable Level world, FluidStack input) {
        if (this.fluidInputCache.isEmpty(input)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        RotaryRecipe recipe = this.findFirstRecipe(input, this.fluidInputCache.getRecipes(input));
        return recipe == null ? this.findFirstRecipe(input, this.complexFluidInputRecipes) : recipe;
    }

    @Nullable
    private RotaryRecipe findFirstRecipe(FluidStack input, Iterable<RotaryRecipe> recipes) {
        for (RotaryRecipe recipe : recipes) {
            if (!recipe.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public RotaryRecipe findFirstRecipe(@Nullable Level world, GasStack input) {
        if (this.gasInputCache.isEmpty(input)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        RotaryRecipe recipe = this.findFirstRecipe(input, this.gasInputCache.getRecipes(input));
        return recipe == null ? this.findFirstRecipe(input, this.complexGasInputRecipes) : recipe;
    }

    @Nullable
    private RotaryRecipe findFirstRecipe(GasStack input, Iterable<RotaryRecipe> recipes) {
        for (RotaryRecipe recipe : recipes) {
            if (!recipe.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    protected void initCache(List<RecipeHolder<RotaryRecipe>> recipes) {
        for (RecipeHolder<RotaryRecipe> recipeHolder : recipes) {
            RotaryRecipe recipe = (RotaryRecipe)recipeHolder.value();
            if (recipe.hasFluidToGas() && this.fluidInputCache.mapInputs(recipe, recipe.getFluidInput())) {
                this.complexFluidInputRecipes.add(recipe);
            }
            if (!recipe.hasGasToFluid() || !this.gasInputCache.mapInputs(recipe, recipe.getGasInput())) continue;
            this.complexGasInputRecipes.add(recipe);
        }
    }
}

