/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.common.lib.collection.FluidHashStrategy;
import mekanism.common.recipe.lookup.cache.type.ComponentSensitiveInputCache;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.CompoundFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.DataComponentFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public class FluidInputCache<RECIPE extends MekanismRecipe<?>>
extends ComponentSensitiveInputCache<Fluid, FluidStack, FluidStackIngredient, RECIPE> {
    public FluidInputCache() {
        super(FluidHashStrategy.INSTANCE);
    }

    @Override
    public boolean mapInputs(RECIPE recipe, FluidStackIngredient inputIngredient) {
        return this.mapIngredient(recipe, inputIngredient.ingredient().ingredient());
    }

    private boolean mapIngredient(RECIPE recipe, FluidIngredient input) {
        if (input.isSimple()) {
            for (FluidStack fluid : input.getStacks()) {
                if (fluid.isEmpty()) continue;
                this.addInputCache(fluid.getFluid(), recipe);
            }
        } else {
            DataComponentFluidIngredient componentIngredient;
            if (input instanceof CompoundFluidIngredient) {
                CompoundFluidIngredient compoundIngredient = (CompoundFluidIngredient)input;
                boolean result = false;
                for (FluidIngredient child : compoundIngredient.children()) {
                    result |= this.mapIngredient(recipe, child);
                }
                return result;
            }
            if (input instanceof DataComponentFluidIngredient && (componentIngredient = (DataComponentFluidIngredient)input).isStrict()) {
                for (FluidStack fluid : input.getStacks()) {
                    this.addNbtInputCache(fluid.copyWithAmount(1), recipe);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Fluid createKey(FluidStack stack) {
        return stack.getFluid();
    }

    @Override
    public boolean isEmpty(FluidStack input) {
        return input.isEmpty();
    }
}

