/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.codec.DependentMapCodec;
import mekanism.api.recipes.basic.BasicChemicalCrystallizerRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ChemicalCrystallizerRecipeSerializer
implements RecipeSerializer<BasicChemicalCrystallizerRecipe> {
    private static final MapCodec<ChemicalType> chemicalTypeMapCodec = ChemicalType.CODEC.fieldOf("chemical_type");
    private static final MapCodec<ChemicalStackIngredient<?, ?, ?>> chemicalStackIngredientMapEncoder = new DependentMapCodec<ChemicalStackIngredient, ChemicalType>("input", type -> IngredientCreatorAccess.getCreatorForType(type).codec(), chemicalTypeMapCodec, ChemicalType::getTypeFor);
    private final StreamCodec<RegistryFriendlyByteBuf, BasicChemicalCrystallizerRecipe> streamCodec;
    private final MapCodec<BasicChemicalCrystallizerRecipe> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)chemicalStackIngredientMapEncoder.forGetter(BasicChemicalCrystallizerRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(BasicChemicalCrystallizerRecipe::getOutputRaw)).apply((Applicative)instance, factory));

    public ChemicalCrystallizerRecipeSerializer(BiFunction<ChemicalStackIngredient<?, ?, ?>, ItemStack, BasicChemicalCrystallizerRecipe> factory) {
        this.streamCodec = StreamCodec.composite((StreamCodec)ChemicalType.STREAM_CODEC.cast().dispatch(ChemicalType::getTypeFor, chemicalType -> IngredientCreatorAccess.getCreatorForType(chemicalType).streamCodec()), BasicChemicalCrystallizerRecipe::getInput, (StreamCodec)ItemStack.STREAM_CODEC, BasicChemicalCrystallizerRecipe::getOutputRaw, factory);
    }

    @NotNull
    public MapCodec<BasicChemicalCrystallizerRecipe> codec() {
        return this.codec;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, BasicChemicalCrystallizerRecipe> streamCodec() {
        return this.streamCodec;
    }
}

