/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function7;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.basic.BasicChemicalDissolutionRecipe;
import mekanism.api.recipes.basic.BasicCombinerRecipe;
import mekanism.api.recipes.basic.BasicElectrolysisRecipe;
import mekanism.api.recipes.basic.BasicFluidSlurryToSlurryRecipe;
import mekanism.api.recipes.basic.BasicFluidToFluidRecipe;
import mekanism.api.recipes.basic.BasicGasToGasRecipe;
import mekanism.api.recipes.basic.BasicItemStackToEnergyRecipe;
import mekanism.api.recipes.basic.BasicItemStackToItemStackRecipe;
import mekanism.api.recipes.basic.BasicNucleosynthesizingRecipe;
import mekanism.api.recipes.basic.BasicPressurizedReactionRecipe;
import mekanism.api.recipes.basic.IBasicChemicalOutput;
import mekanism.api.recipes.basic.IBasicItemStackOutput;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.recipe.WrappedShapedRecipe;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record MekanismRecipeSerializer<RECIPE extends Recipe<?>>(MapCodec<RECIPE> codec, StreamCodec<RegistryFriendlyByteBuf, RECIPE> streamCodec) implements RecipeSerializer<RECIPE>
{
    public static <RECIPE extends WrappedShapedRecipe> MekanismRecipeSerializer<RECIPE> wrapped(Function<ShapedRecipe, RECIPE> wrapper) {
        return new MekanismRecipeSerializer<RECIPE>(RecipeSerializer.SHAPED_RECIPE.codec().xmap(wrapper, WrappedShapedRecipe::getInternal), RecipeSerializer.SHAPED_RECIPE.streamCodec().map(wrapper, WrappedShapedRecipe::getInternal));
    }

    public static <RECIPE extends BasicItemStackToItemStackRecipe> MekanismRecipeSerializer<RECIPE> itemToItem(BiFunction<ItemStackIngredient, ItemStack, RECIPE> factory) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("input").forGetter(BasicItemStackToItemStackRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(BasicItemStackToItemStackRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, BasicItemStackToItemStackRecipe::getInput, (StreamCodec)ItemStack.STREAM_CODEC, BasicItemStackToItemStackRecipe::getOutputRaw, factory));
    }

    public static MekanismRecipeSerializer<BasicCombinerRecipe> combining(Function3<ItemStackIngredient, ItemStackIngredient, ItemStack, BasicCombinerRecipe> factory) {
        return new MekanismRecipeSerializer<BasicCombinerRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("main_input").forGetter(CombinerRecipe::getMainInput), (App)ItemStackIngredient.CODEC.fieldOf("extra_input").forGetter(CombinerRecipe::getExtraInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(BasicCombinerRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, BasicCombinerRecipe::getMainInput, ItemStackIngredient.STREAM_CODEC, BasicCombinerRecipe::getExtraInput, (StreamCodec)ItemStack.STREAM_CODEC, BasicCombinerRecipe::getOutputRaw, factory));
    }

    public static <RECIPE extends BasicItemStackToEnergyRecipe> MekanismRecipeSerializer<RECIPE> itemToEnergy(BiFunction<ItemStackIngredient, Long, RECIPE> factory) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("input").forGetter(ItemStackToEnergyRecipe::getInput), (App)SerializerHelper.POSITIVE_NONZERO_LONG_CODEC_LEGACY.fieldOf("output").forGetter(BasicItemStackToEnergyRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, ItemStackToEnergyRecipe::getInput, (StreamCodec)ByteBufCodecs.VAR_LONG, BasicItemStackToEnergyRecipe::getOutputRaw, factory));
    }

    public static <RECIPE extends BasicFluidToFluidRecipe> MekanismRecipeSerializer<RECIPE> fluidToFluid(BiFunction<FluidStackIngredient, FluidStack, RECIPE> factory) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStackIngredient.CODEC.fieldOf("input").forGetter(FluidToFluidRecipe::getInput), (App)FluidStack.CODEC.fieldOf("output").forGetter(BasicFluidToFluidRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(FluidStackIngredient.STREAM_CODEC, FluidToFluidRecipe::getInput, (StreamCodec)FluidStack.STREAM_CODEC, BasicFluidToFluidRecipe::getOutputRaw, factory));
    }

    public static <RECIPE extends BasicGasToGasRecipe> MekanismRecipeSerializer<RECIPE> gasToGas(BiFunction<GasStackIngredient, GasStack, RECIPE> factory) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)IngredientCreatorAccess.gasStack().codec().fieldOf("input").forGetter(GasToGasRecipe::getInput), (App)GasStack.MAP_CODEC.fieldOf("output").forGetter(BasicGasToGasRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(IngredientCreatorAccess.gasStack().streamCodec(), GasToGasRecipe::getInput, GasStack.STREAM_CODEC, BasicGasToGasRecipe::getOutputRaw, factory));
    }

    public static MekanismRecipeSerializer<BasicFluidSlurryToSlurryRecipe> fluidSlurryToSlurry(Function3<FluidStackIngredient, SlurryStackIngredient, SlurryStack, BasicFluidSlurryToSlurryRecipe> factory) {
        return new MekanismRecipeSerializer<BasicFluidSlurryToSlurryRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStackIngredient.CODEC.fieldOf("fluid_input").forGetter(FluidSlurryToSlurryRecipe::getFluidInput), (App)IngredientCreatorAccess.slurryStack().codec().fieldOf("slurry_input").forGetter(FluidSlurryToSlurryRecipe::getChemicalInput), (App)SlurryStack.CODEC.fieldOf("output").forGetter(BasicFluidSlurryToSlurryRecipe::getOutputRaw)).apply((Applicative)instance, factory)), StreamCodec.composite(FluidStackIngredient.STREAM_CODEC, FluidSlurryToSlurryRecipe::getFluidInput, IngredientCreatorAccess.slurryStack().streamCodec(), FluidSlurryToSlurryRecipe::getChemicalInput, SlurryStack.STREAM_CODEC, BasicFluidSlurryToSlurryRecipe::getOutputRaw, factory));
    }

    public static MekanismRecipeSerializer<BasicNucleosynthesizingRecipe> nucleosynthesizing(Function4<ItemStackIngredient, GasStackIngredient, ItemStack, Integer, BasicNucleosynthesizingRecipe> factory) {
        return new MekanismRecipeSerializer<BasicNucleosynthesizingRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("item_input").forGetter(NucleosynthesizingRecipe::getItemInput), (App)IngredientCreatorAccess.gasStack().codec().fieldOf("gas_input").forGetter(NucleosynthesizingRecipe::getChemicalInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(BasicNucleosynthesizingRecipe::getOutputRaw), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(NucleosynthesizingRecipe::getDuration)).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, NucleosynthesizingRecipe::getItemInput, IngredientCreatorAccess.gasStack().streamCodec(), NucleosynthesizingRecipe::getChemicalInput, (StreamCodec)ItemStack.STREAM_CODEC, BasicNucleosynthesizingRecipe::getOutputRaw, (StreamCodec)ByteBufCodecs.VAR_INT, NucleosynthesizingRecipe::getDuration, factory));
    }

    public static MekanismRecipeSerializer<BasicElectrolysisRecipe> separating(Function4<FluidStackIngredient, Long, GasStack, GasStack, BasicElectrolysisRecipe> factory) {
        return new MekanismRecipeSerializer<BasicElectrolysisRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStackIngredient.CODEC.fieldOf("input").forGetter(ElectrolysisRecipe::getInput), (App)SerializerHelper.POSITIVE_NONZERO_LONG_CODEC_LEGACY.optionalFieldOf("energy_multiplier", (Object)1L).forGetter(ElectrolysisRecipe::getEnergyMultiplier), (App)GasStack.MAP_CODEC.fieldOf("left_gas_output").forGetter(BasicElectrolysisRecipe::getLeftGasOutput), (App)GasStack.MAP_CODEC.fieldOf("right_gas_output").forGetter(BasicElectrolysisRecipe::getRightGasOutput)).apply((Applicative)instance, factory)), StreamCodec.composite(FluidStackIngredient.STREAM_CODEC, ElectrolysisRecipe::getInput, (StreamCodec)ByteBufCodecs.VAR_LONG, ElectrolysisRecipe::getEnergyMultiplier, GasStack.STREAM_CODEC, BasicElectrolysisRecipe::getLeftGasOutput, GasStack.STREAM_CODEC, BasicElectrolysisRecipe::getRightGasOutput, factory));
    }

    public static MekanismRecipeSerializer<BasicChemicalDissolutionRecipe> dissolution(Function3<ItemStackIngredient, GasStackIngredient, ChemicalStack<?>, BasicChemicalDissolutionRecipe> factory) {
        return new MekanismRecipeSerializer<BasicChemicalDissolutionRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("item_input").forGetter(ChemicalDissolutionRecipe::getItemInput), (App)IngredientCreatorAccess.gasStack().codec().fieldOf("gas_input").forGetter(ChemicalDissolutionRecipe::getGasInput), (App)ChemicalStack.BOXED_CODEC.fieldOf("output").forGetter(r -> r.getOutputRaw().getChemicalStack())).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, BasicChemicalDissolutionRecipe::getItemInput, IngredientCreatorAccess.gasStack().streamCodec(), BasicChemicalDissolutionRecipe::getGasInput, BoxedChemicalStack.STREAM_CODEC, BasicChemicalDissolutionRecipe::getOutputRaw, (item, gas, output) -> (BasicChemicalDissolutionRecipe)factory.apply(item, gas, output.getChemicalStack())));
    }

    public static MekanismRecipeSerializer<BasicPressurizedReactionRecipe> reaction(Function7<ItemStackIngredient, FluidStackIngredient, GasStackIngredient, Long, Integer, ItemStack, GasStack, BasicPressurizedReactionRecipe> factory) {
        return new MekanismRecipeSerializer<BasicPressurizedReactionRecipe>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("item_input").forGetter(PressurizedReactionRecipe::getInputSolid), (App)FluidStackIngredient.CODEC.fieldOf("fluid_input").forGetter(PressurizedReactionRecipe::getInputFluid), (App)IngredientCreatorAccess.gasStack().codec().fieldOf("gas_input").forGetter(PressurizedReactionRecipe::getInputGas), (App)SerializerHelper.POSITIVE_LONG_CODEC_LEGACY.optionalFieldOf("energy_required", (Object)0L).forGetter(PressurizedReactionRecipe::getEnergyRequired), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(PressurizedReactionRecipe::getDuration), (App)ItemStack.CODEC.optionalFieldOf("item_output", (Object)ItemStack.EMPTY).forGetter(BasicPressurizedReactionRecipe::getOutputItem), (App)GasStack.CODEC.optionalFieldOf("gas_output", (Object)GasStack.EMPTY).forGetter(BasicPressurizedReactionRecipe::getOutputGas)).apply((Applicative)instance, factory)).validate(result -> {
            if (result.getOutputItem().isEmpty() && result.getOutputGas().isEmpty()) {
                return DataResult.error(() -> "No output specified, must have at least an Item or Gas output");
            }
            return DataResult.success((Object)result);
        }), NeoForgeStreamCodecs.composite(ItemStackIngredient.STREAM_CODEC, PressurizedReactionRecipe::getInputSolid, FluidStackIngredient.STREAM_CODEC, PressurizedReactionRecipe::getInputFluid, IngredientCreatorAccess.gasStack().streamCodec(), PressurizedReactionRecipe::getInputGas, (StreamCodec)ByteBufCodecs.VAR_LONG, PressurizedReactionRecipe::getEnergyRequired, (StreamCodec)ByteBufCodecs.VAR_INT, PressurizedReactionRecipe::getDuration, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, BasicPressurizedReactionRecipe::getOutputItem, GasStack.OPTIONAL_STREAM_CODEC, BasicPressurizedReactionRecipe::getOutputGas, factory));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>> MekanismRecipeSerializer<RECIPE> itemToChemical(BiFunction<ItemStackIngredient, STACK, RECIPE> factory, MapCodec<STACK> stackCodec, StreamCodec<? super RegistryFriendlyByteBuf, STACK> stackStreamCodec) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("input").forGetter(rec$ -> ((ItemStackToChemicalRecipe)rec$).getInput()), (App)stackCodec.fieldOf("output").forGetter(rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw())).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, rec$ -> ((ItemStackToChemicalRecipe)rec$).getInput(), stackStreamCodec, rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw(), factory));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK, ?>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>> MekanismRecipeSerializer<RECIPE> itemChemicalToItem(Function3<ItemStackIngredient, INGREDIENT, ItemStack, RECIPE> factory, IIngredientCreator<CHEMICAL, STACK, INGREDIENT> ingredientCreator) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("item_input").forGetter(rec$ -> ((ItemStackChemicalToItemStackRecipe)rec$).getItemInput()), (App)ingredientCreator.codec().fieldOf("chemical_input").forGetter(rec$ -> ((ItemStackChemicalToItemStackRecipe)rec$).getChemicalInput()), (App)ItemStack.CODEC.fieldOf("output").forGetter(rec$ -> ((IBasicItemStackOutput)rec$).getOutputRaw())).apply((Applicative)instance, factory)), StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, rec$ -> ((ItemStackChemicalToItemStackRecipe)rec$).getItemInput(), ingredientCreator.streamCodec(), rec$ -> ((ItemStackChemicalToItemStackRecipe)rec$).getChemicalInput(), (StreamCodec)ItemStack.STREAM_CODEC, rec$ -> ((IBasicItemStackOutput)rec$).getOutputRaw(), factory));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK, ?>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>> MekanismRecipeSerializer<RECIPE> chemicalChemicalToChemical(Function3<INGREDIENT, INGREDIENT, STACK, RECIPE> factory, IIngredientCreator<CHEMICAL, STACK, INGREDIENT> ingredientCreator, MapCodec<STACK> stackCodec, StreamCodec<? super RegistryFriendlyByteBuf, STACK> stackStreamCodec) {
        return new MekanismRecipeSerializer<RECIPE>(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ingredientCreator.codec().fieldOf("left_input").forGetter(rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getLeftInput()), (App)ingredientCreator.codec().fieldOf("right_input").forGetter(rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getRightInput()), (App)stackCodec.fieldOf("output").forGetter(rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw())).apply((Applicative)instance, factory)), StreamCodec.composite(ingredientCreator.streamCodec(), rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getLeftInput(), ingredientCreator.streamCodec(), rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getRightInput(), stackStreamCodec, rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw(), factory));
    }
}

