/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import java.util.Optional;
import java.util.function.BiFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.basic.BasicRotaryRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.recipe.ingredients.creator.GasStackIngredientCreator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public class RotaryRecipeSerializer
implements RecipeSerializer<BasicRotaryRecipe> {
    private final RecordCodecBuilder<BasicRotaryRecipe, FluidStackIngredient> FLUID_INPUT_FIELD = FluidStackIngredient.CODEC.validate(ingredient -> ingredient == null ? DataResult.error(() -> "Fluid input may not be empty") : DataResult.success((Object)ingredient)).fieldOf("fluid_input").forGetter(BasicRotaryRecipe::getFluidInputRaw);
    private final RecordCodecBuilder<BasicRotaryRecipe, FluidStack> FLUID_OUTPUT_FIELD = FluidStack.CODEC.fieldOf("fluid_output").forGetter(BasicRotaryRecipe::getFluidOutputRaw);
    private final RecordCodecBuilder<BasicRotaryRecipe, GasStackIngredient> GAS_INPUT_FIELD = GasStackIngredientCreator.INSTANCE.codec().validate(ingredient -> ingredient == null ? DataResult.error(() -> "Gas input may not be empty") : DataResult.success((Object)ingredient)).fieldOf("gas_input").forGetter(BasicRotaryRecipe::getGasInputRaw);
    private final RecordCodecBuilder<BasicRotaryRecipe, GasStack> GAS_OUTPUT_FIELD = GasStack.CODEC.fieldOf("gas_output").forGetter(BasicRotaryRecipe::getGasOutputRaw);
    private final StreamCodec<RegistryFriendlyByteBuf, BasicRotaryRecipe> streamCodec;
    private final MapCodec<BasicRotaryRecipe> codec = NeoForgeExtraCodecs.withAlternative((MapCodec)RecordCodecBuilder.mapCodec(i -> i.group(this.FLUID_INPUT_FIELD, this.GAS_INPUT_FIELD, this.GAS_OUTPUT_FIELD, this.FLUID_OUTPUT_FIELD).apply((Applicative)i, bothWaysFactory)), (MapCodec)NeoForgeExtraCodecs.withAlternative((MapCodec)RecordCodecBuilder.mapCodec(i -> i.group(this.FLUID_INPUT_FIELD, this.GAS_OUTPUT_FIELD).apply((Applicative)i, toGasFactory)), (MapCodec)RecordCodecBuilder.mapCodec(i -> i.group(this.GAS_INPUT_FIELD, this.FLUID_OUTPUT_FIELD).apply((Applicative)i, toFluidFactory))));

    public RotaryRecipeSerializer(Function4<FluidStackIngredient, GasStackIngredient, GasStack, FluidStack, BasicRotaryRecipe> bothWaysFactory, BiFunction<FluidStackIngredient, GasStack, BasicRotaryRecipe> toGasFactory, BiFunction<GasStackIngredient, FluidStack, BasicRotaryRecipe> toFluidFactory) {
        this.streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional(FluidToGas.STREAM_CODEC), recipe -> recipe.hasFluidToGas() ? Optional.of(new FluidToGas((BasicRotaryRecipe)recipe)) : Optional.empty(), (StreamCodec)ByteBufCodecs.optional(GasToFluid.STREAM_CODEC), recipe -> recipe.hasGasToFluid() ? Optional.of(new GasToFluid((BasicRotaryRecipe)recipe)) : Optional.empty(), (toGas, toFluid) -> {
            if (toGas.isPresent()) {
                FluidToGas fluidToGas = (FluidToGas)toGas.get();
                if (toFluid.isPresent()) {
                    GasToFluid gasToFluid = (GasToFluid)toFluid.get();
                    return (BasicRotaryRecipe)bothWaysFactory.apply((Object)fluidToGas.input(), (Object)gasToFluid.input(), (Object)fluidToGas.output(), (Object)gasToFluid.output());
                }
                return (BasicRotaryRecipe)toGasFactory.apply(fluidToGas.input(), fluidToGas.output());
            }
            if (toFluid.isPresent()) {
                GasToFluid gasToFluid = (GasToFluid)toFluid.get();
                return (BasicRotaryRecipe)toFluidFactory.apply(gasToFluid.input(), gasToFluid.output());
            }
            throw new DecoderException("A recipe got sent with no conversion in either direction.");
        });
    }

    public MapCodec<BasicRotaryRecipe> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BasicRotaryRecipe> streamCodec() {
        return this.streamCodec;
    }

    private record FluidToGas(FluidStackIngredient input, GasStack output) {
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidToGas> STREAM_CODEC = StreamCodec.composite(FluidStackIngredient.STREAM_CODEC, FluidToGas::input, GasStack.STREAM_CODEC, FluidToGas::output, FluidToGas::new);

        private FluidToGas(BasicRotaryRecipe recipe) {
            this(recipe.getFluidInput(), recipe.getGasOutputRaw());
        }
    }

    private record GasToFluid(GasStackIngredient input, FluidStack output) {
        public static final StreamCodec<RegistryFriendlyByteBuf, GasToFluid> STREAM_CODEC = StreamCodec.composite(IngredientCreatorAccess.gasStack().streamCodec(), GasToFluid::input, (StreamCodec)FluidStack.STREAM_CODEC, GasToFluid::output, GasToFluid::new);

        private GasToFluid(BasicRotaryRecipe recipe) {
            this(recipe.getGasInput(), recipe.getFluidOutputRaw());
        }
    }
}

