/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.item.interfaces.IUpgradeItem;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class UpgradesRecipeData
implements RecipeUpgradeData<UpgradesRecipeData> {
    private final Map<Upgrade, Integer> upgrades;
    private final List<IInventorySlot> slots;

    UpgradesRecipeData(Map<Upgrade, Integer> upgrades, List<IInventorySlot> slots) {
        this.upgrades = upgrades;
        this.slots = slots;
    }

    @Override
    @Nullable
    public UpgradesRecipeData merge(UpgradesRecipeData other) {
        Map<Upgrade, Integer> smallerUpgrades = other.upgrades;
        Map<Upgrade, Integer> largerUpgrades = this.upgrades;
        if (largerUpgrades.size() < smallerUpgrades.size()) {
            smallerUpgrades = this.upgrades;
            largerUpgrades = other.upgrades;
        }
        EnumMap<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(largerUpgrades);
        if (!smallerUpgrades.isEmpty()) {
            for (Map.Entry<Upgrade, Integer> entry : smallerUpgrades.entrySet()) {
                Upgrade upgrade = entry.getKey();
                int total = upgrades.merge(upgrade, entry.getValue(), Integer::sum);
                if (total <= upgrade.getMax()) continue;
                return null;
            }
        }
        ArrayList<IInventorySlot> allSlots = new ArrayList<IInventorySlot>(this.slots);
        allSlots.addAll(other.slots);
        return new UpgradesRecipeData(upgrades, allSlots);
    }

    @Override
    public boolean applyToStack(HolderLookup.Provider provider, ItemStack stack) {
        BlockItem blockItem;
        AttributeUpgradeSupport upgradeSupport;
        if (this.upgrades.isEmpty() && this.slots.stream().allMatch(IInventorySlot::isEmpty)) {
            return true;
        }
        Set<Object> supportedUpgrades = Collections.emptySet();
        Item item = stack.getItem();
        if (item instanceof BlockItem && (upgradeSupport = Attribute.get((blockItem = (BlockItem)item).getBlock(), AttributeUpgradeSupport.class)) != null) {
            supportedUpgrades = upgradeSupport.supportedUpgrades();
        }
        if (supportedUpgrades.containsAll(this.upgrades.keySet())) {
            return false;
        }
        ItemStack inputStack = ItemStack.EMPTY;
        ItemStack outputStack = ItemStack.EMPTY;
        for (IInventorySlot slot : this.slots) {
            Upgrade upgrade;
            if (slot.isEmpty()) continue;
            ItemStack slotInStack = slot.getStack().copy();
            Item item2 = slotInStack.getItem();
            if (item2 instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)item2;
                v0 = upgradeItem.getUpgradeType(slotInStack);
            } else {
                v0 = upgrade = null;
            }
            if (upgrade == null) {
                return false;
            }
            if (supportedUpgrades.contains(upgrade)) {
                if (inputStack.isEmpty()) {
                    inputStack = slotInStack;
                    continue;
                }
                if (inputStack.getCount() < inputStack.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)inputStack, (ItemStack)slotInStack)) {
                    int needed = inputStack.getMaxStackSize() - inputStack.getCount();
                    if (slotInStack.getCount() <= needed) {
                        inputStack.grow(slotInStack.getCount());
                        continue;
                    }
                    inputStack.grow(needed);
                    slotInStack.shrink(needed);
                }
            }
            if (outputStack.isEmpty()) {
                outputStack = slotInStack;
                continue;
            }
            if (outputStack.getCount() < outputStack.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)slotInStack)) {
                int needed = outputStack.getMaxStackSize() - outputStack.getCount();
                if (slotInStack.getCount() > needed) {
                    return false;
                }
                outputStack.grow(outputStack.getCount());
                continue;
            }
            return false;
        }
        stack.set(MekanismDataComponents.UPGRADES, (Object)new UpgradeAware(this.upgrades, inputStack, outputStack));
        return true;
    }
}

