/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade.chemical;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class ChemicalRecipeData<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>>
implements RecipeUpgradeData<ChemicalRecipeData<CHEMICAL, STACK, TANK>> {
    protected final List<TANK> tanks;

    protected ChemicalRecipeData(List<TANK> tanks) {
        this.tanks = tanks;
    }

    @Override
    @Nullable
    public ChemicalRecipeData<CHEMICAL, STACK, TANK> merge(ChemicalRecipeData<CHEMICAL, STACK, TANK> other) {
        ArrayList<TANK> allTanks = new ArrayList<TANK>(this.tanks);
        allTanks.addAll(other.tanks);
        return this.create(allTanks);
    }

    protected abstract ChemicalRecipeData<CHEMICAL, STACK, TANK> create(List<TANK> var1);

    protected abstract ContainerType<TANK, ?, ? extends IMekanismChemicalHandler<CHEMICAL, STACK, TANK>> getContainerType();

    @Override
    public boolean applyToStack(HolderLookup.Provider provider, ItemStack stack) {
        if (this.tanks.isEmpty()) {
            return true;
        }
        IMekanismChemicalHandler<CHEMICAL, STACK, TANK> outputHandler = this.getContainerType().createHandler(stack);
        if (outputHandler == null) {
            return false;
        }
        for (IChemicalTank tank : this.tanks) {
            if (tank.isEmpty() || ((ChemicalStack)this.insertManualIntoOutputContainer(outputHandler, tank.getStack())).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private STACK insertManualIntoOutputContainer(IMekanismChemicalHandler<CHEMICAL, STACK, TANK> outputHandler, STACK chemical) {
        return ChemicalUtils.insert(chemical, null, outputHandler::getChemicalTanks, Action.EXECUTE, AutomationType.MANUAL, outputHandler.getEmptyStack());
    }
}

