/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.math.MathUtils;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.network.to_client.PacketSetDeltaMovement;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityTeleporter
extends TileEntityMekanism
implements IChunkLoader {
    private static final TeleportInfo NO_FRAME = new TeleportInfo(2, null, Collections.emptyList());
    private static final TeleportInfo NO_LINK = new TeleportInfo(3, null, Collections.emptyList());
    private static final TeleportInfo NOT_ENOUGH_ENERGY = new TeleportInfo(4, null, Collections.emptyList());
    private static final DimensionTransition.PostDimensionTransition AWARD_ADVANCEMENT = entity -> {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ((PlayerTrigger)MekanismCriteriaTriggers.TELEPORT.value()).trigger(player);
        }
    };
    public final Set<UUID> didTeleport = new ObjectOpenHashSet();
    private final Predicate<Entity> SAME_DIMENSION_TARGET = entity -> this.canTeleportEntity((Entity)entity, null);
    private AABB teleportBounds;
    public int teleDelay = 0;
    public boolean shouldRender;
    @Nullable
    private Direction frameDirection;
    private boolean frameRotated;
    private EnumColor color;
    public byte status = 0;
    private final TileComponentChunkLoader<TileEntityTeleporter> chunkLoaderComponent = new TileComponentChunkLoader<TileEntityTeleporter>(this);
    private MachineEnergyContainer<TileEntityTeleporter> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityTeleporter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.TELEPORTER, pos, state);
        this.frequencyComponent.track(FrequencyType.TELEPORTER, true, true, false);
        this.cacheCoord();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityTeleporter)this).getLevel(), listener, 153, 7);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    private boolean canTeleportEntity(Entity entity, @Nullable Level destinationLevel) {
        if (entity.isSpectator() || !entity.canUsePortal(false) || entity instanceof PartEntity || entity.getType().is(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED)) {
            return false;
        }
        if (destinationLevel != null && !entity.canChangeDimensions(entity.level(), destinationLevel)) {
            return false;
        }
        return !this.didTeleport.contains(entity.getUUID());
    }

    private static float alignPlayer(ServerPlayer player, BlockPos target, TileEntityTeleporter teleporter) {
        Direction side = null;
        if (teleporter.frameDirection != null && teleporter.frameDirection.getAxis().isHorizontal()) {
            side = teleporter.frameDirection;
        } else {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            Level level = teleporter.getWorldNN();
            for (Direction iterSide : EnumUtils.HORIZONTAL_DIRECTIONS) {
                mutable.setWithOffset((Vec3i)target, iterSide);
                if (!level.isEmptyBlock((BlockPos)mutable)) continue;
                side = iterSide;
                break;
            }
        }
        Direction direction = side;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORTH", "SOUTH", "WEST", "EAST"}, (Direction)direction, n)) {
            case 0 -> 180.0f;
            case 1 -> 0.0f;
            case 2 -> 90.0f;
            case 3 -> 270.0f;
            default -> player.getYRot();
        };
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.teleportBounds == null && this.frameDirection != null) {
            this.resetBounds();
        }
        TeleporterFrequency freq = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        TeleportInfo teleportInfo = this.canTeleport(freq);
        this.status = teleportInfo.status();
        if (this.status == 1 && this.teleDelay == 0 && this.canFunction()) {
            this.teleport(freq, teleportInfo);
        }
        if (this.teleDelay == 0 && this.teleportBounds != null && !this.didTeleport.isEmpty()) {
            this.cleanTeleportCache();
        }
        boolean prevShouldRender = this.shouldRender;
        this.shouldRender = this.status == 1 || this.status > 4;
        EnumColor prevColor = this.color;
        EnumColor enumColor = this.color = freq == null ? null : freq.getColor();
        if (this.shouldRender != prevShouldRender) {
            WorldUtils.notifyLoadedNeighborsOfTileChange(this.level, this.getBlockPos());
            sendUpdatePacket = true;
        } else if (this.color != prevColor) {
            sendUpdatePacket = true;
        }
        this.teleDelay = Math.max(0, this.teleDelay - 1);
        this.energySlot.fillContainerOrConvert();
        return sendUpdatePacket;
    }

    @Nullable
    private GlobalPos getClosest(@Nullable TeleporterFrequency frequency) {
        return frequency == null ? null : frequency.getClosestCoords(this.getTileGlobalPos());
    }

    private void cleanTeleportCache() {
        List<UUID> inTeleporter = this.level.getEntitiesOfClass(Entity.class, this.teleportBounds).stream().map(Entity::getUUID).toList();
        if (inTeleporter.isEmpty()) {
            this.didTeleport.clear();
        } else {
            Iterator<UUID> iterator = this.didTeleport.iterator();
            while (iterator.hasNext()) {
                UUID id = iterator.next();
                if (inTeleporter.contains(id)) continue;
                iterator.remove();
            }
        }
    }

    private void resetBounds() {
        this.teleportBounds = this.frameDirection == null ? null : this.getTeleporterBoundingBox(this.frameDirection);
    }

    private TeleportInfo canTeleport(@Nullable TeleporterFrequency frequency) {
        Level targetWorld;
        boolean sameDimension;
        GlobalPos closestCoords;
        Direction direction = this.getFrameDirection();
        if (direction == null) {
            this.frameDirection = null;
            return NO_FRAME;
        }
        if (this.frameDirection != direction) {
            this.frameDirection = direction;
            this.resetBounds();
        }
        if ((closestCoords = this.getClosest(frequency)) == null || this.level == null) {
            return NO_LINK;
        }
        boolean bl = sameDimension = this.level.dimension() == closestCoords.dimension();
        if (sameDimension) {
            targetWorld = this.level;
        } else {
            MinecraftServer server = this.level.getServer();
            if (server == null) {
                return NO_LINK;
            }
            targetWorld = server.getLevel(closestCoords.dimension());
            if (targetWorld == null || !server.isLevelEnabled(targetWorld)) {
                return NO_LINK;
            }
        }
        List<Entity> toTeleport = this.getToTeleport(sameDimension, targetWorld);
        long sum = 0L;
        for (Entity entity : toTeleport) {
            long cost = TileEntityTeleporter.calculateEnergyCost(entity, targetWorld, closestCoords);
            long r = sum + cost;
            if (((sum ^ r) & (cost ^ r)) < 0L) {
                return NOT_ENOUGH_ENERGY;
            }
            sum = r;
        }
        if (this.energyContainer.extract(sum, Action.SIMULATE, AutomationType.INTERNAL) < sum) {
            return NOT_ENOUGH_ENERGY;
        }
        return new TeleportInfo(1, closestCoords, toTeleport);
    }

    public BlockPos getTeleporterTargetPos() {
        if (this.frameDirection == null) {
            return this.worldPosition.above();
        }
        if (this.frameDirection == Direction.DOWN) {
            return this.worldPosition.below(2);
        }
        return this.worldPosition.relative(this.frameDirection);
    }

    public void sendTeleportParticles() {
        BlockPos teleporterTargetPos = this.getTeleporterTargetPos();
        Direction offsetDirection = this.frameDirection == null || this.frameDirection.getAxis().isVertical() ? Direction.UP : this.frameDirection;
        PacketUtils.sendToAllTracking(new PacketPortalFX(teleporterTargetPos, offsetDirection), this.level, teleporterTargetPos);
    }

    private void teleport(TeleporterFrequency frequency, TeleportInfo teleportInfo) {
        BlockPos closestPos;
        if (teleportInfo.closest == null || this.level == null || teleportInfo.toTeleport.isEmpty()) {
            return;
        }
        MinecraftServer currentServer = this.level.getServer();
        if (currentServer == null) {
            return;
        }
        boolean sameDimension = this.level.dimension() == teleportInfo.closest.dimension();
        Object teleWorld = sameDimension ? this.level : currentServer.getLevel(teleportInfo.closest.dimension());
        TileEntityTeleporter teleporter = WorldUtils.getTileEntity(TileEntityTeleporter.class, (BlockGetter)teleWorld, closestPos = teleportInfo.closest.pos());
        if (teleporter != null) {
            Set<GlobalPos> activeCoords = frequency.getActiveCoords();
            BlockPos teleporterTargetPos = teleporter.getTeleporterTargetPos();
            for (Entity entity : teleportInfo.toTeleport) {
                this.markTeleported(teleporter, entity, sameDimension, (Level)teleWorld);
                teleporter.teleDelay = 5;
                long energyCost = TileEntityTeleporter.calculateEnergyCost(entity, teleWorld, teleportInfo.closest);
                MekanismTeleportEvent.Teleporter event = new MekanismTeleportEvent.Teleporter(entity, teleporterTargetPos, (ResourceKey<Level>)teleWorld.dimension(), energyCost);
                if (((MekanismTeleportEvent.Teleporter)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) continue;
                double oldX = entity.getX();
                double oldY = entity.getY();
                double oldZ = entity.getZ();
                Entity teleportedEntity = TileEntityTeleporter.teleportEntityTo(entity, teleWorld, teleporter, event, true, AWARD_ADVANCEMENT);
                for (GlobalPos coords : activeCoords) {
                    Object world = this.level.dimension() == coords.dimension() ? this.level : currentServer.getLevel(coords.dimension());
                    TileEntityTeleporter tile = WorldUtils.getTileEntity(TileEntityTeleporter.class, (BlockGetter)world, coords.pos());
                    if (tile == null) continue;
                    tile.sendTeleportParticles();
                }
                this.energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.INTERNAL);
                if (teleportedEntity == null) continue;
                SoundEvent sound = TileEntityTeleporter.getTeleportSound(teleportedEntity);
                if (this.level != teleportedEntity.level() || teleportedEntity.distanceToSqr(oldX, oldY, oldZ) >= 25.0) {
                    this.level.playSound(null, oldX, oldY, oldZ, sound, entity.getSoundSource());
                }
                teleportedEntity.level().playSound(null, teleportedEntity.getX(), teleportedEntity.getY(), teleportedEntity.getZ(), sound, teleportedEntity.getSoundSource());
            }
        }
    }

    private static SoundEvent getTeleportSound(Entity entity) {
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, Fox.class, Shulker.class}, (Object)entity3, n)) {
            case 0 -> {
                Player player = (Player)entity3;
                yield SoundEvents.PLAYER_TELEPORT;
            }
            case 1 -> {
                Fox fox = (Fox)entity3;
                yield SoundEvents.FOX_TELEPORT;
            }
            case 2 -> {
                Shulker shulker = (Shulker)entity3;
                yield SoundEvents.SHULKER_TELEPORT;
            }
            default -> SoundEvents.ENDERMAN_TELEPORT;
        };
    }

    private void markTeleported(TileEntityTeleporter teleporter, Entity entity, boolean sameDimension, Level destinationWorld) {
        if (sameDimension || entity.canChangeDimensions(entity.level(), destinationWorld)) {
            teleporter.didTeleport.add(entity.getUUID());
            for (Entity passenger : entity.getPassengers()) {
                this.markTeleported(teleporter, passenger, sameDimension, destinationWorld);
            }
        }
    }

    @Nullable
    public static Entity teleportEntityTo(Entity entity, Level targetWorld, TileEntityTeleporter target, MekanismTeleportEvent.Teleporter event, boolean persistMovement, DimensionTransition.PostDimensionTransition transition) {
        Vec3 destination = event.getTarget();
        float yRot = entity.getYRot();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            yRot = TileEntityTeleporter.alignPlayer(player, BlockPos.containing((Position)destination), target);
        }
        if (!event.isTransDimensional()) {
            ServerPlayer player;
            Vec3 deltaMovement = entity.getDeltaMovement();
            if (entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                player.connection.teleport(destination.x, destination.y, destination.z, yRot, entity.getXRot());
            } else {
                entity.teleportTo(destination.x, destination.y, destination.z);
            }
            if (!entity.getPassengers().isEmpty()) {
                ServerPlayer player2;
                ((ServerChunkCache)entity.level().getChunkSource()).broadcast(entity, (Packet)new ClientboundSetPassengersPacket(entity));
                LivingEntity controller = entity.getControllingPassenger();
                if (controller != entity && controller instanceof ServerPlayer && !(player2 = (ServerPlayer)controller).isFakePlayer() && player2.connection != null) {
                    player2.connection.send((Packet)new ClientboundMoveVehiclePacket(entity));
                }
            }
            if (persistMovement && entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).isFakePlayer()) {
                player.setDeltaMovement(deltaMovement);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketSetDeltaMovement(deltaMovement), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (transition != DimensionTransition.DO_NOTHING) {
                for (Entity passenger : entity.getIndirectPassengers()) {
                    transition.onTransition(passenger);
                }
                transition.onTransition(entity);
            }
            return entity;
        }
        return entity.changeDimension(new DimensionTransition((ServerLevel)targetWorld, destination, entity.getDeltaMovement(), yRot, entity.getXRot(), transition));
    }

    private List<Entity> getToTeleport(boolean sameDimension, Level destinationLevel) {
        if (this.level == null || this.teleportBounds == null) {
            return Collections.emptyList();
        }
        return this.level.getEntitiesOfClass(Entity.class, this.teleportBounds, sameDimension ? this.SAME_DIMENSION_TARGET : entity -> this.canTeleportEntity((Entity)entity, destinationLevel));
    }

    public static long calculateEnergyCost(Entity entity, GlobalPos pos) {
        ServerLevel targetWorld;
        MinecraftServer currentServer = entity.getServer();
        if (currentServer != null && (targetWorld = currentServer.getLevel(pos.dimension())) != null) {
            return TileEntityTeleporter.calculateEnergyCost(entity, (Level)targetWorld, pos);
        }
        return -1L;
    }

    public static long calculateEnergyCost(Entity entity, Level targetWorld, GlobalPos coords) {
        long energyCost = MekanismConfig.usage.teleporterBase.get();
        boolean sameDimension = entity.level().dimension() == coords.dimension();
        BlockPos pos = coords.pos();
        if (sameDimension) {
            energyCost += Math.round((double)MekanismConfig.usage.teleporterDistance.get() * Math.sqrt(entity.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())));
        } else {
            double zDifference;
            double xDifference;
            double currentScale = entity.level().dimensionType().coordinateScale();
            double targetScale = targetWorld.dimensionType().coordinateScale();
            double yDifference = entity.getY() - (double)pos.getY();
            if (currentScale <= targetScale) {
                double scale = currentScale / targetScale;
                xDifference = entity.getX() * scale - (double)pos.getX();
                zDifference = entity.getZ() * scale - (double)pos.getZ();
            } else {
                double inverseScale = targetScale / currentScale;
                xDifference = entity.getX() - (double)pos.getX() * inverseScale;
                zDifference = entity.getZ() - (double)pos.getZ() * inverseScale;
            }
            double distance = Mth.length((double)xDifference, (double)yDifference, (double)zDifference);
            energyCost += MekanismConfig.usage.teleporterDimensionPenalty.get() + Math.round((double)MekanismConfig.usage.teleporterDistance.get() * distance);
        }
        HashSet<Entity> passengers = new HashSet<Entity>();
        TileEntityTeleporter.fillIndirectPassengers(entity, sameDimension, targetWorld, passengers);
        int passengerCount = passengers.size();
        return passengerCount > 0 ? MathUtils.multiplyClamped(energyCost, 1 + passengerCount) : energyCost;
    }

    private static void fillIndirectPassengers(Entity base, boolean sameDimension, Level targetDimension, Set<Entity> passengers) {
        for (Entity entity : base.getPassengers()) {
            if (!sameDimension && !entity.canChangeDimensions(entity.level(), targetDimension)) continue;
            passengers.add(entity);
            TileEntityTeleporter.fillIndirectPassengers(entity, sameDimension, targetDimension, passengers);
        }
    }

    @Nullable
    public Direction getFrameDirection() {
        Long2ObjectArrayMap chunkMap = new Long2ObjectArrayMap(3);
        Object2BooleanOpenHashMap cachedIsFrame = new Object2BooleanOpenHashMap();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (Direction direction : EnumUtils.DIRECTIONS) {
            if (this.hasFrame((Long2ObjectMap<ChunkAccess>)chunkMap, pos, (Object2BooleanMap<BlockPos>)cachedIsFrame, direction, false)) {
                this.frameRotated = false;
                return direction;
            }
            if (!this.hasFrame((Long2ObjectMap<ChunkAccess>)chunkMap, pos, (Object2BooleanMap<BlockPos>)cachedIsFrame, direction, true)) continue;
            this.frameRotated = true;
            return direction;
        }
        return null;
    }

    private boolean hasFrame(Long2ObjectMap<ChunkAccess> chunkMap, BlockPos.MutableBlockPos pos, Object2BooleanMap<BlockPos> cachedIsFrame, Direction direction, boolean rotated) {
        int alternatingX = 0;
        int alternatingY = 0;
        int alternatingZ = 0;
        if (rotated) {
            if (direction.getAxis() == Direction.Axis.Z) {
                alternatingX = 1;
            } else {
                alternatingZ = 1;
            }
        } else if (direction.getAxis() == Direction.Axis.Y) {
            alternatingX = 1;
        } else {
            alternatingY = 1;
        }
        int xComponent = direction.getStepX();
        int yComponent = direction.getStepY();
        int zComponent = direction.getStepZ();
        return this.isFramePair(chunkMap, pos, cachedIsFrame, 0, alternatingX, 0, alternatingY, 0, alternatingZ) && this.isFrame(chunkMap, pos, cachedIsFrame, 3 * xComponent, 3 * yComponent, 3 * zComponent) && this.isFramePair(chunkMap, pos, cachedIsFrame, xComponent, alternatingX, yComponent, alternatingY, zComponent, alternatingZ) && this.isFramePair(chunkMap, pos, cachedIsFrame, 2 * xComponent, alternatingX, 2 * yComponent, alternatingY, 2 * zComponent, alternatingZ) && this.isFramePair(chunkMap, pos, cachedIsFrame, 3 * xComponent, alternatingX, 3 * yComponent, alternatingY, 3 * zComponent, alternatingZ);
    }

    private boolean isFramePair(Long2ObjectMap<ChunkAccess> chunkMap, BlockPos.MutableBlockPos pos, Object2BooleanMap<BlockPos> cachedIsFrame, int xOffset, int alternatingX, int yOffset, int alternatingY, int zOffset, int alternatingZ) {
        return this.isFrame(chunkMap, pos, cachedIsFrame, xOffset - alternatingX, yOffset - alternatingY, zOffset - alternatingZ) && this.isFrame(chunkMap, pos, cachedIsFrame, xOffset + alternatingX, yOffset + alternatingY, zOffset + alternatingZ);
    }

    private boolean isFrame(Long2ObjectMap<ChunkAccess> chunkMap, BlockPos.MutableBlockPos pos, Object2BooleanMap<BlockPos> cachedIsFrame, int xOffset, int yOffset, int zOffset) {
        pos.setWithOffset((Vec3i)this.worldPosition, xOffset, yOffset, zOffset);
        if (cachedIsFrame.containsKey((Object)pos)) {
            return cachedIsFrame.getBoolean((Object)pos);
        }
        boolean isFrame = WorldUtils.getBlockState((LevelAccessor)this.level, chunkMap, (BlockPos)pos).filter(blockState -> blockState.is(MekanismBlocks.TELEPORTER_FRAME.getBlock())).isPresent();
        cachedIsFrame.put((Object)pos.immutable(), isFrame);
        return isFrame;
    }

    @Nullable
    public Direction frameDirection() {
        if (this.frameDirection == null) {
            return this.getFrameDirection();
        }
        return this.frameDirection;
    }

    public boolean frameRotated() {
        return this.frameRotated;
    }

    public AABB getTeleporterBoundingBox(@NotNull Direction frameDirection) {
        return AABB.encapsulatingFullBlocks((BlockPos)this.worldPosition.relative(frameDirection), (BlockPos)this.worldPosition.relative(frameDirection, 2));
    }

    public TileComponentChunkLoader<TileEntityTeleporter> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        return Collections.singleton(new ChunkPos(this.getBlockPos()));
    }

    @Override
    public int getRedstoneLevel() {
        return this.shouldRender ? 15 : 0;
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return false;
    }

    @Override
    public int getCurrentRedstoneLevel() {
        return this.getRedstoneLevel();
    }

    public MachineEnergyContainer<TileEntityTeleporter> getEnergyContainer() {
        return this.energyContainer;
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableByte.create(() -> this.status, value -> {
            this.status = value;
        }));
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.putBoolean("rendering", this.shouldRender);
        if (this.color != null) {
            NBTUtils.writeEnum(updateTag, "color", this.color);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setBooleanIfPresent(tag, "rendering", value -> {
            this.shouldRender = value;
        });
        this.color = NBTUtils.getEnum(tag, "color", EnumColor.BY_ID);
    }

    @ComputerMethod(methodDescription="Lists public frequencies")
    Collection<TeleporterFrequency> getFrequencies() {
        return FrequencyType.TELEPORTER.getManagerWrapper().getPublicManager().getFrequencies();
    }

    @ComputerMethod
    boolean hasFrequency() {
        TeleporterFrequency frequency = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        return frequency != null && frequency.isValid() && !frequency.isRemoved();
    }

    @ComputerMethod(methodDescription="Requires a frequency to be selected")
    TeleporterFrequency getFrequency() throws ComputerException {
        TeleporterFrequency frequency = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        if (frequency == null || !frequency.isValid() || frequency.isRemoved()) {
            throw new ComputerException("No frequency is currently selected.");
        }
        return frequency;
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires a public frequency to exist")
    void setFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = FrequencyType.TELEPORTER.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency == null) {
            throw new ComputerException("No public teleporter frequency with name '%s' found.", name);
        }
        this.setFrequency(FrequencyType.TELEPORTER, frequency.getIdentity(), this.getOwnerUUID());
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires frequency to not already exist and for it to be public so that it can make it as the player who owns the block. Also sets the frequency after creation")
    void createFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = FrequencyType.TELEPORTER.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency != null) {
            throw new ComputerException("Unable to create public teleporter frequency with name '%s' as one already exists.", name);
        }
        this.setFrequency(FrequencyType.TELEPORTER, new Frequency.FrequencyIdentity(name, SecurityMode.PUBLIC, this.getOwnerUUID()), this.getOwnerUUID());
    }

    @ComputerMethod(methodDescription="Requires a frequency to be selected")
    EnumColor getFrequencyColor() throws ComputerException {
        return this.getFrequency().getColor();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires a frequency to be selected")
    void setFrequencyColor(EnumColor color) throws ComputerException {
        this.validateSecurityIsPublic();
        this.getFrequency().setColor(color);
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires a frequency to be selected")
    void incrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = this.getFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getNext());
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires a frequency to be selected")
    void decrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = this.getFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getPrevious());
    }

    @ComputerMethod(methodDescription="Requires a frequency to be selected")
    Set<GlobalPos> getActiveTeleporters() throws ComputerException {
        return this.getFrequency().getActiveCoords();
    }

    @ComputerMethod
    String getStatus() {
        if (this.hasFrequency()) {
            return switch (this.status) {
                case 1 -> "ready";
                case 2 -> "no frame";
                case 4 -> "needs energy";
                default -> "no link";
            };
        }
        return "no frequency";
    }

    private record TeleportInfo(byte status, @Nullable GlobalPos closest, List<Entity> toTeleport) {
    }
}

