/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.tile.interfaces.IHasMode;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public interface IFluidContainerManager
extends IHasMode {
    public ContainerEditMode getContainerEditMode();

    @NothingNullByDefault
    public static enum ContainerEditMode implements IIncrementalEnum<ContainerEditMode>,
    IHasTextComponent,
    StringRepresentable
    {
        BOTH(MekanismLang.FLUID_CONTAINER_BOTH),
        FILL(MekanismLang.FLUID_CONTAINER_FILL),
        EMPTY(MekanismLang.FLUID_CONTAINER_EMPTY);

        public static final Codec<ContainerEditMode> CODEC;
        public static final IntFunction<ContainerEditMode> BY_ID;
        public static final StreamCodec<ByteBuf, ContainerEditMode> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ILangEntry langEntry;

        private ContainerEditMode(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate();
        }

        @Override
        public ContainerEditMode byIndex(int index) {
            return BY_ID.apply(index);
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ContainerEditMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ContainerEditMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

