/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces.chemical;

import java.util.Collections;
import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.SimpleDynamicChemicalHandler;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.resolver.manager.ChemicalHandlerManager;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public interface IGasTile
extends IGasTracker {
    @Nullable
    public ChemicalHandlerManager.GasHandlerManager getGasManager();

    @Nullable
    default public ChemicalHandlerManager.GasHandlerManager getInitialGasManager(IContentsListener listener) {
        IChemicalTankHolder<Gas, GasStack, IGasTank> initialGasTanks = this.getInitialGasTanks(listener);
        if (initialGasTanks == null) {
            return null;
        }
        return new ChemicalHandlerManager.GasHandlerManager(initialGasTanks, new SimpleDynamicChemicalHandler.SimpleDynamicGasHandler(this::getGasTanks, listener));
    }

    @Nullable
    default public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        return null;
    }

    default public boolean canHandleGas() {
        ChemicalHandlerManager.GasHandlerManager gasManager = this.getGasManager();
        return gasManager != null && gasManager.canHandle();
    }

    @Override
    default public List<IGasTank> getGasTanks(@Nullable Direction side) {
        ChemicalHandlerManager.GasHandlerManager gasManager = this.getGasManager();
        return gasManager != null ? gasManager.getContainers(side) : Collections.emptyList();
    }
}

