/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityDynamicTank
extends TileEntityMultiblock<TankMultiblockData>
implements IFluidContainerManager {
    public TileEntityDynamicTank(BlockPos pos, BlockState state) {
        this(MekanismBlocks.DYNAMIC_TANK, pos, state);
    }

    public TileEntityDynamicTank(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Override
    public ItemInteractionResult onActivate(Player player, InteractionHand hand, ItemStack stack) {
        TankMultiblockData multiblock;
        if (!player.isShiftKeyDown() && (multiblock = (TankMultiblockData)this.getMultiblock()).isFormed()) {
            if (this.manageInventory(multiblock, player, hand, stack)) {
                player.getInventory().setChanged();
                return ItemInteractionResult.SUCCESS;
            }
            InteractionResult result = this.openGui(player);
            return switch (result) {
                default -> throw new MatchException(null, null);
                case InteractionResult.SUCCESS, InteractionResult.SUCCESS_NO_ITEM_USED -> ItemInteractionResult.SUCCESS;
                case InteractionResult.CONSUME -> ItemInteractionResult.CONSUME;
                case InteractionResult.CONSUME_PARTIAL -> ItemInteractionResult.CONSUME_PARTIAL;
                case InteractionResult.PASS -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                case InteractionResult.FAIL -> ItemInteractionResult.FAIL;
            };
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    @NotNull
    public TankMultiblockData createMultiblock() {
        return new TankMultiblockData(this);
    }

    @Override
    public MultiblockManager<TankMultiblockData> getManager() {
        return Mekanism.tankManager;
    }

    @Override
    public IFluidContainerManager.ContainerEditMode getContainerEditMode() {
        return ((TankMultiblockData)this.getMultiblock()).editMode;
    }

    @Override
    public void nextMode() {
        TankMultiblockData multiblock = (TankMultiblockData)this.getMultiblock();
        multiblock.setContainerEditMode((IFluidContainerManager.ContainerEditMode)multiblock.editMode.getNext());
    }

    @Override
    public void previousMode() {
        TankMultiblockData multiblock = (TankMultiblockData)this.getMultiblock();
        multiblock.setContainerEditMode((IFluidContainerManager.ContainerEditMode)multiblock.editMode.getPrevious());
    }

    private boolean manageInventory(TankMultiblockData multiblock, Player player, InteractionHand hand, ItemStack itemStack) {
        if (multiblock.isFormed()) {
            return FluidUtils.handleTankInteraction(player, hand, itemStack, multiblock.getFluidTank());
        }
        return false;
    }
}

