/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Map;
import mekanism.api.IConfigurable;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityStructuralMultiblock
extends TileEntityMekanism
implements IStructuralMultiblock,
IConfigurable {
    private final Map<MultiblockManager<?>, Structure> structures = new Reference2ObjectArrayMap(2);
    private final Structure invalidStructure = Structure.INVALID;
    private final MultiblockData defaultMultiblock = new MultiblockData(this);
    private boolean removing;
    private boolean hasFormedMultiblock = false;
    private boolean canAccessGui = false;

    public TileEntityStructuralMultiblock(IBlockProvider provider, BlockPos pos, BlockState state) {
        super(provider, pos, state);
    }

    @Override
    public MultiblockData getDefaultData() {
        return this.defaultMultiblock;
    }

    @Override
    public void setStructure(MultiblockManager<?> manager, Structure structure) {
        this.structures.put(manager, structure);
    }

    @Override
    public void multiblockUnformed(Structure structure) {
        MultiblockManager<?> manager;
        if (!this.removing && (this.hasFormedMultiblock || this.canAccessGui) && this.structures.get(manager = structure.getManager()) == structure) {
            boolean hasFormed = false;
            boolean canAccess = false;
            for (Structure struct : this.structures.values()) {
                MultiblockData multiblock;
                if (struct == structure || (multiblock = this.getMultiblockData(struct)) == null || !multiblock.isFormed()) continue;
                hasFormed = true;
                canAccess |= multiblock.allowsStructuralGuiAccess(this);
            }
            this.updateFormedMultiblock(hasFormed, canAccess);
        }
    }

    @Override
    public void multiblockFormed(MultiblockData multiblock) {
        this.updateFormedMultiblock(true, this.canAccessGui || multiblock.allowsStructuralGuiAccess(this));
    }

    private void updateFormedMultiblock(boolean hasFormed, boolean canAccess) {
        if (this.hasFormedMultiblock != hasFormed || this.canAccessGui != canAccess) {
            this.hasFormedMultiblock = hasFormed;
            this.canAccessGui = canAccess;
            this.sendUpdatePacket();
        }
    }

    @Override
    public Structure getStructure(MultiblockManager<?> manager) {
        return this.structures.getOrDefault(manager, this.invalidStructure);
    }

    @Override
    public boolean hasStructure(Structure structure) {
        return this.structures.get(structure.getManager()) == structure;
    }

    @Override
    public boolean hasFormedMultiblock() {
        return this.hasFormedMultiblock;
    }

    @Override
    public boolean structuralGuiAccessAllowed() {
        return this.hasFormedMultiblock && this.canAccessGui;
    }

    @Override
    public Map<MultiblockManager<?>, Structure> getStructureMap() {
        return this.structures;
    }

    @Nullable
    private MultiblockData getMultiblockData(Structure structure) {
        MultiblockData data = structure.getMultiblockData();
        if (data != null && data.isFormed()) {
            return data;
        }
        return null;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.invalidStructure.tick(this, true);
    }

    @Override
    public ItemInteractionResult onActivate(Player player, InteractionHand hand, ItemStack stack) {
        if (!this.structuralGuiAccessAllowed()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        for (Structure structure : this.structures.values()) {
            ItemInteractionResult result;
            MultiblockData data;
            IMultiblock<?> master = structure.getController();
            if (master == null || (data = this.getMultiblockData(structure)) == null || !data.isFormed() || !data.allowsStructuralGuiAccess(this) || !data.getBounds().getRelativeLocation(this.getBlockPos()).isWall() || (result = master.onActivate(player, hand, stack)).result() == InteractionResult.PASS) continue;
            return result;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void onNeighborChange(Block block, BlockPos neighborPos) {
        super.onNeighborChange(block, neighborPos);
        if (!this.isRemote()) {
            for (Structure s : this.structures.values()) {
                MultiblockData multiblock;
                if (s.getController() == null || (multiblock = this.getMultiblockData(s)) == null || !multiblock.isPositionInsideBounds(s, neighborPos) || !this.level.isEmptyBlock(neighborPos) && multiblock.internalLocations.contains(neighborPos)) continue;
                s.markForUpdate(this.level, true);
            }
        }
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        if (this.isRemote()) {
            return InteractionResult.PASS;
        }
        for (Structure structure : this.structures.values()) {
            FormationProtocol.FormationResult result;
            MultiblockData multiblock;
            if (structure.getController() == null || (multiblock = this.getMultiblockData(structure)) != null && multiblock.isFormed() || (result = structure.runUpdate(this)).isFormed() || result.getResultText() == null) continue;
            player.sendSystemMessage(result.getResultText());
            return InteractionResult.sidedSuccess((boolean)this.isRemote());
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.putBoolean("formed", this.hasFormedMultiblock);
        updateTag.putBoolean("gui", this.canAccessGui);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.hasFormedMultiblock = tag.getBoolean("formed");
        this.canAccessGui = tag.getBoolean("gui");
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        if (!this.isRemote()) {
            this.removing = true;
            for (Structure s : this.structures.values()) {
                s.invalidate(this.level);
            }
        }
    }

    @Override
    public boolean shouldDumpRadiation() {
        return false;
    }
}

