/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collection;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.content.network.distribution.EnergyAcceptorTarget;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.util.EmitUtils;

public final class CableUtils {
    private CableUtils() {
    }

    public static void emit(Collection<BlockEnergyCapabilityCache> targets, IEnergyContainer energyContainer) {
        CableUtils.emit(targets, energyContainer, energyContainer.getMaxEnergy());
    }

    public static void emit(Collection<BlockEnergyCapabilityCache> targets, IEnergyContainer energyContainer, long maxOutput) {
        if (!energyContainer.isEmpty() && maxOutput > 0L) {
            energyContainer.extract(CableUtils.emit(targets, energyContainer.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL)), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static long emit(Collection<BlockEnergyCapabilityCache> targets, long energyToSend) {
        if (energyToSend <= 0L || targets.isEmpty()) {
            return 0L;
        }
        EnergyAcceptorTarget target = new EnergyAcceptorTarget(targets.size());
        for (BlockEnergyCapabilityCache capability : targets) {
            IStrictEnergyHandler handler = capability.getCapability();
            if (handler == null) continue;
            target.addHandler(handler);
        }
        if (target.getHandlerCount() > 0) {
            return EmitUtils.sendToAcceptors(target, energyToSend, Long.valueOf(energyToSend));
        }
        return 0L;
    }
}

