/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.common.lib.distribution.IntegerSplitInfo;
import mekanism.common.lib.distribution.LongSplitInfo;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;

public class EmitUtils {
    private EmitUtils() {
    }

    private static <HANDLER, TYPE extends Number, EXTRA, TARGET extends Target<HANDLER, TYPE, EXTRA>> TYPE sendToAcceptors(TARGET availableTargets, SplitInfo<TYPE> splitInfo, EXTRA toSend) {
        if (availableTargets.getHandlerCount() == 0) {
            return splitInfo.getTotalSent();
        }
        availableTargets.sendPossible(toSend, splitInfo);
        while (splitInfo.amountPerChanged) {
            splitInfo.amountPerChanged = false;
            availableTargets.shiftNeeded(splitInfo);
        }
        availableTargets.sendRemainingSplit(splitInfo);
        return splitInfo.getTotalSent();
    }

    public static <HANDLER, EXTRA, TARGET extends Target<HANDLER, Integer, EXTRA>> int sendToAcceptors(TARGET availableTargets, int amountToSplit, EXTRA toSend) {
        return EmitUtils.sendToAcceptors(availableTargets, new IntegerSplitInfo(amountToSplit, availableTargets.getHandlerCount()), toSend);
    }

    public static <HANDLER, EXTRA, TARGET extends Target<HANDLER, Long, EXTRA>> long sendToAcceptors(TARGET availableTargets, long amountToSplit, EXTRA toSend) {
        return EmitUtils.sendToAcceptors(availableTargets, new LongSplitInfo(amountToSplit, availableTargets.getHandlerCount()), toSend);
    }
}

