/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.longs.Long2DoubleArrayMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.MekanismAPI;
import mekanism.api.MekanismAPITags;
import mekanism.api.Upgrade;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MekanismUtils {
    public static final float ONE_OVER_ROOT_TWO = 1.0f / Mth.SQRT_OF_TWO;
    public static final int TICKS_PER_HALF_SECOND = 10;
    private static final List<UUID> warnedFails = new ArrayList<UUID>();

    public static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            Mekanism.logger.error("Stack size changed by a different amount ({}) than requested ({}).", (Object)actual, (Object)expected);
            if (MekanismAPI.debug) {
                Mekanism.logger.error("Location ", (Throwable)new Exception());
            }
        }
    }

    public static void logExpectedZero(long actual) {
        if (actual != 0L) {
            Mekanism.logger.error("Energy value changed by a different amount ({}) than requested (zero).", (Object)actual);
            if (MekanismAPI.debug) {
                Mekanism.logger.error("Location ", (Throwable)new Exception());
            }
        }
    }

    public static Component logFormat(Object message) {
        return MekanismUtils.logFormat(EnumColor.GRAY, message);
    }

    public static Component logFormat(EnumColor messageColor, Object message) {
        return MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, messageColor, message);
    }

    public static boolean isTickingNormally(@Nullable Level level) {
        return level == null || level.tickRateManager().runsNormally();
    }

    @Nullable
    public static Player tryGetClientPlayer() {
        if (FMLEnvironment.dist.isClient()) {
            return MekanismClient.tryGetClientPlayer();
        }
        return null;
    }

    @NotNull
    public static String getModId(@NotNull ItemStack stack) {
        Item item = stack.getItem();
        String modid = item.getCreatorModId(stack);
        if (modid == null) {
            ResourceLocation registryName = RegistryUtils.getName(item);
            if (registryName == null) {
                Mekanism.logger.error("Unexpected null registry name for item of class type: {}", (Object)item.getClass().getSimpleName());
                return "";
            }
            return registryName.getNamespace();
        }
        return modid;
    }

    public static boolean isRightArm(LivingEntity entity, InteractionHand hand) {
        return entity.getMainArm() == HumanoidArm.RIGHT == (hand == InteractionHand.MAIN_HAND);
    }

    public static ItemStack getItemInHand(LivingEntity entity, HumanoidArm side) {
        if (entity.getMainArm() == side) {
            return entity.getMainHandItem();
        }
        return entity.getOffhandItem();
    }

    public static Direction getLeft(Direction orientation) {
        return orientation.getClockWise();
    }

    public static Direction getRight(Direction orientation) {
        return orientation.getCounterClockWise();
    }

    public static double fractionUpgrades(IUpgradeTile tile, Upgrade type) {
        if (tile.supportsUpgrade(type)) {
            return (double)tile.getComponent().getUpgrades(type) / (double)type.getMax();
        }
        return 0.0;
    }

    public static float getScale(float prevScale, IExtendedFluidTank tank) {
        return MekanismUtils.getScale(prevScale, tank.getFluidAmount(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(float prevScale, IChemicalTank<?, ?> tank) {
        return MekanismUtils.getScale(prevScale, tank.getStored(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(float prevScale, int stored, int capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0 ? 0.0f : (float)stored / (float)capacity, empty, stored == capacity);
    }

    public static float getScale(float prevScale, long stored, long capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0L ? 0.0f : (float)((double)stored / (double)capacity), empty, stored == capacity);
    }

    public static float getScale(float prevScale, IEnergyContainer container) {
        long stored = container.getEnergy();
        long capacity = container.getMaxEnergy();
        float targetScale = capacity == 0L ? 0.0f : (float)((double)stored / (double)capacity);
        return MekanismUtils.getScale(prevScale, targetScale, container.isEmpty(), stored == capacity);
    }

    public static float getScale(float prevScale, float targetScale, boolean empty, boolean full) {
        float difference = Math.abs(prevScale - targetScale);
        if ((double)difference > 0.01) {
            return (9.0f * prevScale + targetScale) / 10.0f;
        }
        if (!empty && full && difference > 0.0f) {
            return targetScale;
        }
        if (!empty && prevScale == 0.0f) {
            return targetScale;
        }
        if (empty && (double)prevScale < 0.01) {
            return 0.0f;
        }
        return prevScale;
    }

    public static boolean scaleChanged(float scale, float prevScale) {
        if (Mth.equal((float)scale, (float)prevScale)) {
            return scale != prevScale && scale == 0.0f || scale == 1.0f || prevScale == 1.0f || prevScale == 0.0f;
        }
        return true;
    }

    public static long getBaseUsage(IUpgradeTile tile, int def) {
        if (tile.supportsUpgrades() && tile.supportsUpgrade(Upgrade.GAS)) {
            return Math.round((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.GAS)));
        }
        return def;
    }

    public static int getTicks(IUpgradeTile tile, int def) {
        if (tile.supportsUpgrades()) {
            return MathUtils.clampToInt((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), -MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED)));
        }
        return def;
    }

    public static long getEnergyPerTick(IUpgradeTile tile, long def) {
        if (tile.supportsUpgrades()) {
            return MathUtils.ceilToLong((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0 * MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.ENERGY)));
        }
        return def;
    }

    public static double getGasPerTickMeanMultiplier(IUpgradeTile tile) {
        if (tile.supportsUpgrades()) {
            if (tile.supportsUpgrade(Upgrade.GAS)) {
                return Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0 * MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.GAS));
            }
            return Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED));
        }
        return 1.0;
    }

    public static long getMaxEnergy(IUpgradeTile tile, long def) {
        if (tile.supportsUpgrades()) {
            return MathUtils.clampToLong((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.ENERGY)));
        }
        return def;
    }

    public static long getMaxEnergy(int energyUpgrades, long def) {
        return MathUtils.clampToLong((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), (double)energyUpgrades / (double)Upgrade.ENERGY.getMax()));
    }

    public static ResourceLocation getResource(ResourceType type, String name) {
        return Mekanism.rl(type.getPrefix() + name);
    }

    public static boolean lighterThanAirGas(FluidStack stack) {
        return stack.is(Tags.Fluids.GASEOUS) && stack.getFluidType().getDensity(stack) <= 0;
    }

    public static boolean isLiquidBlock(Block block) {
        return block instanceof LiquidBlock || block instanceof BubbleColumnBlock;
    }

    public static BlockHitResult rayTrace(Player player) {
        return MekanismUtils.rayTrace(player, ClipContext.Fluid.NONE);
    }

    public static BlockHitResult rayTrace(Player player, ClipContext.Fluid fluidMode) {
        return MekanismUtils.rayTrace(player, player.blockInteractionRange(), fluidMode);
    }

    public static BlockHitResult rayTrace(Player player, double reach) {
        return MekanismUtils.rayTrace(player, reach, ClipContext.Fluid.NONE);
    }

    public static BlockHitResult rayTrace(Player player, double reach, ClipContext.Fluid fluidMode) {
        Vec3 headVec = MekanismUtils.getHeadVec(player);
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 endVec = headVec.add(lookVec.x * reach, lookVec.y * reach, lookVec.z * reach);
        return player.level().clip(new ClipContext(headVec, endVec, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    private static Vec3 getHeadVec(Player player) {
        double posY = player.getY() + (double)player.getEyeHeight();
        if (player.isCrouching()) {
            posY -= 0.08;
        }
        return new Vec3(player.getX(), posY, player.getZ());
    }

    public static void addFrequencyItemTooltip(ItemStack stack, List<Component> tooltip) {
        Frequency.FrequencyIdentity identity;
        Item item;
        if (stack.isEmpty() || !((item = stack.getItem()) instanceof IFrequencyItem)) {
            return;
        }
        IFrequencyItem frequencyItem = (IFrequencyItem)item;
        DataComponentType<FrequencyAware<?>> frequencyComponent = MekanismDataComponents.getFrequencyComponent(frequencyItem.getFrequencyType());
        if (frequencyComponent == null) {
            return;
        }
        FrequencyAware frequencyAware = (FrequencyAware)stack.get(frequencyComponent);
        if (frequencyAware != null && (identity = (Frequency.FrequencyIdentity)frequencyAware.identity().orElse(null)) != null) {
            String owner;
            tooltip.add((Component)MekanismLang.FREQUENCY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, identity.key()));
            UUID ownerUUID = frequencyAware.getOwner();
            if (ownerUUID != null && (owner = OwnerDisplay.getOwnerName(MekanismUtils.tryGetClientPlayer(), frequencyAware.getOwner(), null)) != null) {
                tooltip.add((Component)MekanismLang.OWNER.translateColored(EnumColor.INDIGO, EnumColor.GRAY, owner));
            }
            tooltip.add((Component)MekanismLang.MODE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, identity.securityMode()));
        }
    }

    public static long calculateUsage(long capacity) {
        return Math.max((long)(0.005 * (double)capacity), 1L);
    }

    public static Component getEnergyDisplayShort(long energy) {
        UnitDisplayUtils.EnergyUnit configured = UnitDisplayUtils.EnergyUnit.getConfigured();
        return UnitDisplayUtils.getDisplayShort(configured.convertToDouble(energy), configured);
    }

    public static long convertToJoules(long energy) {
        return UnitDisplayUtils.EnergyUnit.getConfigured().convertFrom(energy);
    }

    public static Component getTemperatureDisplay(double temp, UnitDisplayUtils.TemperatureUnit unit, boolean shift) {
        double tempKelvin = unit.convertToK(temp, true);
        return UnitDisplayUtils.getDisplayShort(tempKelvin, (UnitDisplayUtils.TemperatureUnit)MekanismConfig.common.tempUnit.get(), shift);
    }

    public static CraftingInput.Positioned getCraftingInput(int width, int height, List<ItemStack> slots, boolean resize) {
        if (width * height != slots.size()) {
            throw new IllegalStateException("Expected there to be a slot for every index in a " + width + " by " + height + " grid.");
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(slots.size());
        for (ItemStack slot : slots) {
            if (resize) {
                stacks.add(slot.copyWithCount(1));
                continue;
            }
            stacks.add(slot.copy());
        }
        return CraftingInput.ofPositioned((int)width, (int)height, stacks);
    }

    public static CraftingInput.Positioned getCraftingInputSlots(int width, int height, List<IInventorySlot> slots, boolean resize) {
        if (width * height != slots.size()) {
            throw new IllegalStateException("Expected there to be a slot for every index in a " + width + " by " + height + " grid.");
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(slots.size());
        for (IInventorySlot slot : slots) {
            ItemStack stack = slot.getStack();
            if (resize) {
                stacks.add(stack.copyWithCount(1));
                continue;
            }
            stacks.add(stack.copy());
        }
        return CraftingInput.ofPositioned((int)width, (int)height, stacks);
    }

    public static boolean canUseAsWrench(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof ItemConfigurator) {
            ItemConfigurator configurator = (ItemConfigurator)item;
            return configurator.getMode(stack) == ItemConfigurator.ConfiguratorMode.WRENCH;
        }
        return stack.is(MekanismTags.Items.CONFIGURATORS);
    }

    @NotNull
    public static String getLastKnownUsername(@Nullable UUID uuid) {
        Optional gp;
        if (uuid == null) {
            return "<???>";
        }
        String ret = UsernameCache.getLastKnownUsername((UUID)uuid);
        if (ret == null && !warnedFails.contains(uuid) && EffectiveSide.get().isServer() && (gp = ServerLifecycleHooks.getCurrentServer().getProfileCache().get(uuid)).isPresent()) {
            ret = ((GameProfile)gp.get()).getName();
        }
        if (ret == null && !warnedFails.contains(uuid)) {
            Mekanism.logger.warn("Failed to retrieve username for UUID {}, you might want to add it to the JSON cache", (Object)uuid);
            warnedFails.add(uuid);
        }
        return ret == null ? "<" + String.valueOf(uuid) + ">" : ret;
    }

    public static void speedUpEffectSafely(LivingEntity entity, MobEffectInstance effectInstance) {
        int remainingDuration;
        if (effectInstance.getDuration() > 0 && (remainingDuration = effectInstance.tickDownDuration()) == 0 && effectInstance.hiddenEffect != null) {
            effectInstance.setDetailsFrom(effectInstance.hiddenEffect);
            effectInstance.hiddenEffect = effectInstance.hiddenEffect.hiddenEffect;
            MekanismUtils.onChangedPotionEffect(entity, effectInstance, true);
        }
    }

    public static boolean shouldSpeedUpEffect(MobEffectInstance effectInstance) {
        return effectInstance.getCures().contains(EffectCures.MILK) && !effectInstance.getEffect().getDelegate().is(MekanismAPITags.MobEffects.SPEED_UP_BLACKLIST);
    }

    private static void onChangedPotionEffect(LivingEntity entity, MobEffectInstance effectInstance, boolean reapply) {
        entity.effectsDirty = true;
        if (reapply && !entity.level().isClientSide) {
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            effect.removeAttributeModifiers(entity.getAttributes());
            effect.addAttributeModifiers(entity.getAttributes(), effectInstance.getAmplifier());
            entity.refreshDirtyAttributes();
        }
        if (!entity.level().isClientSide) {
            entity.sendEffectToPassengers(effectInstance);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(entity.getId(), effectInstance, false));
            CriteriaTriggers.EFFECTS_CHANGED.trigger(player, null);
        }
    }

    public static boolean isSameTypeFactory(Block block, Block factoryBlockType) {
        AttributeFactoryType attribute = Attribute.get(block, AttributeFactoryType.class);
        if (attribute != null) {
            AttributeFactoryType otherType = Attribute.get(factoryBlockType, AttributeFactoryType.class);
            return otherType != null && attribute.getFactoryType() == otherType.getFactoryType();
        }
        return false;
    }

    @SafeVarargs
    public static InteractionResult performActions(InteractionResult firstAction, Supplier<InteractionResult> ... secondaryActions) {
        if (firstAction.consumesAction()) {
            return firstAction;
        }
        InteractionResult result = firstAction;
        boolean hasFailed = result == InteractionResult.FAIL;
        for (Supplier<InteractionResult> secondaryAction : secondaryActions) {
            result = secondaryAction.get();
            if (result.consumesAction()) {
                return result;
            }
            hasFailed &= result == InteractionResult.FAIL;
        }
        if (hasFailed) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static int redstoneLevelFromContents(long amount, long capacity) {
        double fractionFull = capacity == 0L ? 0.0 : (double)amount / (double)capacity;
        return Mth.floor((double)(fractionFull * 14.0)) + (fractionFull > 0.0 ? 1 : 0);
    }

    public static int redstoneLevelFromContents(List<IInventorySlot> slots) {
        long totalCount = 0L;
        long totalLimit = 0L;
        for (IInventorySlot slot : slots) {
            if (slot.isEmpty()) {
                totalLimit += (long)slot.getLimit(ItemStack.EMPTY);
                continue;
            }
            totalCount += (long)slot.getCount();
            totalLimit += (long)slot.getLimit(slot.getStack());
        }
        return MekanismUtils.redstoneLevelFromContents(totalCount, totalLimit);
    }

    public static boolean isPlayingMode(Player player) {
        return !player.isCreative() && !player.isSpectator();
    }

    public static List<String> getParameterNames(@Nullable JsonObject classMethods, String method, String signature) {
        JsonElement params;
        JsonObject signatures;
        if (classMethods != null && (signatures = classMethods.getAsJsonObject(method)) != null && (params = signatures.get(signature)) != null) {
            if (params.isJsonArray()) {
                JsonArray paramArray = params.getAsJsonArray();
                ArrayList<String> paramNames = new ArrayList<String>(paramArray.size());
                for (JsonElement param : paramArray) {
                    paramNames.add(param.getAsString());
                }
                return Collections.unmodifiableList(paramNames);
            }
            return Collections.singletonList(params.getAsString());
        }
        return Collections.emptyList();
    }

    public static Map<FluidType, FluidInDetails> getFluidsIn(Player player, double data, ModifyPlayerBounding modifyBoundingBox) {
        AABB bb = modifyBoundingBox.modify(player.getBoundingBox().deflate(0.001), data);
        int xMin = Mth.floor((double)bb.minX);
        int xMax = Mth.ceil((double)bb.maxX);
        int yMin = Mth.floor((double)bb.minY);
        int yMax = Mth.ceil((double)bb.maxY);
        int zMin = Mth.floor((double)bb.minZ);
        int zMax = Mth.ceil((double)bb.maxZ);
        if (!player.level().hasChunksAt(xMin, yMin, zMin, xMax, yMax, zMax)) {
            return Collections.emptyMap();
        }
        IdentityHashMap<FluidType, FluidInDetails> fluidsIn = new IdentityHashMap<FluidType, FluidInDetails>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    double fluidY;
                    mutablePos.set(x, y, z);
                    FluidState fluidState = player.level().getFluidState((BlockPos)mutablePos);
                    if (fluidState.isEmpty() || !(bb.minY <= (fluidY = (double)((float)y + fluidState.getHeight((BlockGetter)player.level(), (BlockPos)mutablePos))))) continue;
                    FluidInDetails details = fluidsIn.computeIfAbsent(fluidState.getFluidType(), f -> new FluidInDetails());
                    details.positions.put(mutablePos.immutable(), fluidState);
                    double actualFluidHeight = fluidY > bb.maxY ? bb.maxY - Math.max(bb.minY, (double)y) : fluidY - Math.max(bb.minY, (double)y);
                    details.heights.merge(ChunkPos.asLong((int)x, (int)z), actualFluidHeight, Double::sum);
                }
            }
        }
        return fluidsIn;
    }

    public static void veinMineArea(IEnergyContainer energyContainer, long energyRequired, long baseBlastEnergy, long baseVeinEnergy, Level world, BlockPos pos, ServerPlayer player, ItemStack stack, Item usedTool, Object2IntMap<BlockPos> found, BlastEnergyFunction blastEnergy, VeinEnergyFunction veinEnergy) {
        long energyUsed = 0L;
        long energyAvailable = energyContainer.getEnergy();
        energyAvailable -= energyRequired;
        Stat itemStat = Stats.ITEM_USED.get((Object)usedTool);
        for (Object2IntMap.Entry foundEntry : found.object2IntEntrySet()) {
            BlockEvent.BreakEvent event;
            int distance;
            long destroyEnergy;
            float hardness;
            BlockState targetState;
            BlockPos foundPos = (BlockPos)foundEntry.getKey();
            if (pos.equals((Object)foundPos) || (targetState = world.getBlockState(foundPos)).isAir() || (hardness = targetState.getDestroySpeed((BlockGetter)world, foundPos)) == -1.0f || energyUsed + (destroyEnergy = (distance = foundEntry.getIntValue()) == 0 ? blastEnergy.calc(baseBlastEnergy, hardness) : veinEnergy.calc(baseVeinEnergy, hardness, distance, targetState)) >= energyAvailable || (event = CommonHooks.fireBlockBreak((Level)world, (GameType)player.gameMode.getGameModeForPlayer(), (ServerPlayer)player, (BlockPos)foundPos, (BlockState)targetState)).isCanceled()) continue;
            FluidState fluidState = targetState.getFluidState();
            BlockEntity tileEntity = WorldUtils.getTileEntity((BlockGetter)world, foundPos);
            targetState = targetState.getBlock().playerWillDestroy(world, foundPos, targetState, (Player)player);
            Block block = targetState.getBlock();
            if (!targetState.onDestroyedByPlayer(world, foundPos, (Player)player, true, fluidState)) continue;
            block.destroy((LevelAccessor)world, foundPos, targetState);
            block.playerDestroy(world, (Player)player, foundPos, targetState, tileEntity, stack);
            player.awardStat(itemStat);
            energyUsed += destroyEnergy;
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
    }

    public static enum ResourceType {
        GUI("gui"),
        GUI_BUTTON("gui/button"),
        GUI_BAR("gui/bar"),
        GUI_GAUGE("gui/gauge"),
        GUI_HUD("gui/hud"),
        GUI_ICONS("gui/icons"),
        GUI_MODE("gui/mode"),
        GUI_PROGRESS("gui/progress"),
        GUI_RADIAL("gui/radial"),
        GUI_SLOT("gui/slot"),
        GUI_TAB("gui/tabs"),
        SOUND("sound"),
        RENDER("render"),
        TEXTURE_BLOCKS("textures/block"),
        TEXTURE_ITEMS("textures/item"),
        MODEL("models"),
        INFUSE("infuse"),
        PIGMENT("pigment"),
        SLURRY("slurry");

        private final String prefix;

        private ResourceType(String s) {
            this.prefix = s;
        }

        public String getPrefix() {
            return this.prefix + "/";
        }
    }

    @FunctionalInterface
    public static interface ModifyPlayerBounding {
        public AABB modify(AABB var1, double var2);
    }

    public static class FluidInDetails {
        private final Map<BlockPos, FluidState> positions = new HashMap<BlockPos, FluidState>();
        private final Long2DoubleMap heights = new Long2DoubleArrayMap();

        public Map<BlockPos, FluidState> getPositions() {
            return this.positions;
        }

        public double getMaxHeight() {
            return this.heights.values().doubleStream().max().orElse(0.0);
        }
    }

    @FunctionalInterface
    public static interface BlastEnergyFunction {
        public long calc(long var1, float var3);
    }

    @FunctionalInterface
    public static interface VeinEnergyFunction {
        public long calc(long var1, float var3, int var4, BlockState var5);
    }
}

