/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StackUtils {
    private StackUtils() {
    }

    public static ItemStack size(ItemStack stack, int size) {
        return size <= 0 ? ItemStack.EMPTY : stack.copyWithCount(size);
    }

    public static List<ItemStack> merge(@NotNull List<IInventorySlot> orig, @NotNull List<IInventorySlot> toAdd) {
        ArrayList<ItemStack> rejects = new ArrayList<ItemStack>();
        StackUtils.merge(orig, toAdd, rejects);
        return rejects;
    }

    public static void merge(@NotNull List<IInventorySlot> orig, @NotNull List<IInventorySlot> toAdd, List<ItemStack> rejects) {
        StorageUtils.validateSizeMatches(orig, toAdd, "slot");
        for (int i = 0; i < toAdd.size(); ++i) {
            IInventorySlot toAddSlot = toAdd.get(i);
            if (toAddSlot.isEmpty()) continue;
            IInventorySlot origSlot = orig.get(i);
            ItemStack toAddStack = toAddSlot.getStack();
            if (origSlot.isEmpty()) {
                int max = origSlot.getLimit(toAddStack);
                if (toAddStack.getCount() <= max) {
                    origSlot.setStack(toAddStack);
                    continue;
                }
                origSlot.setStack(toAddStack.copyWithCount(max));
                StackUtils.addStack(rejects, toAddStack.copyWithCount(toAddStack.getCount() - max));
                continue;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)origSlot.getStack(), (ItemStack)toAddStack)) {
                int added = origSlot.growStack(toAddStack.getCount(), Action.EXECUTE);
                StackUtils.addStack(rejects, toAddStack.copyWithCount(toAddStack.getCount() - added));
                continue;
            }
            StackUtils.addStack(rejects, toAddStack.copy());
        }
    }

    private static void addStack(List<ItemStack> stacks, ItemStack stack) {
        if (!stack.isEmpty()) {
            for (ItemStack existingStack : stacks) {
                int needed = existingStack.getMaxStackSize() - existingStack.getCount();
                if (needed <= 0 || !ItemStack.isSameItemSameComponents((ItemStack)existingStack, (ItemStack)stack)) continue;
                int toAdd = Math.min(needed, stack.getCount());
                existingStack.grow(toAdd);
                stack.shrink(toAdd);
                break;
            }
            if (!stack.isEmpty()) {
                int max;
                int count = stack.getCount();
                if (count > (max = stack.getMaxStackSize())) {
                    int excess = count % max;
                    int stacksToAdd = count / max;
                    if (excess > 0) {
                        stacks.add(stack.copyWithCount(excess));
                    }
                    ItemStack maxSize = stack.copyWithCount(max);
                    stacks.add(maxSize);
                    for (int i = 1; i < stacksToAdd; ++i) {
                        stacks.add(maxSize.copy());
                    }
                } else {
                    stacks.add(stack);
                }
            }
        }
    }

    @Nullable
    public static BlockState getStateForPlacement(ItemStack stack, BlockPos pos, Player player) {
        return Block.byItem((Item)stack.getItem()).getStateForPlacement(new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.ZERO, Direction.UP, pos, false))));
    }
}

