/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.IAdvancedTransportEjector;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public final class TransporterUtils {
    private TransporterUtils() {
    }

    @Nullable
    public static EnumColor readColor(int inputColor) {
        if (inputColor < 0) {
            return null;
        }
        return EnumColor.BY_ID.apply(inputColor);
    }

    public static int getColorIndex(@Nullable EnumColor color) {
        return color == null ? -1 : color.ordinal();
    }

    public static boolean isValidAcceptorOnSide(Level level, BlockPos pos, Direction side) {
        return TransporterUtils.isValidAcceptorOnSide(level, pos, WorldUtils.getTileEntity((BlockGetter)level, pos), side);
    }

    public static boolean isValidAcceptorOnSide(Level level, BlockPos pos, @Nullable BlockEntity tile, Direction side) {
        TileEntityTransmitter transmitter;
        if (tile instanceof TileEntityTransmitter && TransmissionType.ITEM.checkTransmissionType(transmitter = (TileEntityTransmitter)tile)) {
            return false;
        }
        return Capabilities.ITEM.getCapabilityIfLoaded(level, pos, null, tile, side) != null;
    }

    public static EnumColor increment(@Nullable EnumColor color) {
        if (color == null) {
            return EnumUtils.COLORS[0];
        }
        if (color.ordinal() == EnumUtils.COLORS.length - 1) {
            return null;
        }
        return (EnumColor)color.getNext();
    }

    public static EnumColor decrement(@Nullable EnumColor color) {
        if (color == null) {
            return EnumUtils.COLORS[EnumUtils.COLORS.length - 1];
        }
        return color.ordinal() == 0 ? null : (EnumColor)color.getPrevious();
    }

    public static void drop(LogisticalTransporterBase transporter, TransporterStack stack) {
        BlockPos blockPos;
        if (stack.hasPath()) {
            float[] pos2 = TransporterUtils.getStackPosition(transporter, stack, 0.0f);
            blockPos = transporter.getBlockPos().offset(Mth.floor((float)pos2[0]), Mth.floor((float)pos2[1]), Mth.floor((float)pos2[2]));
        } else {
            blockPos = transporter.getBlockPos();
        }
        TransporterManager.remove(transporter.getLevel(), stack);
        InventoryUtils.dropStack(transporter.getLevel(), blockPos, null, stack.itemStack, (level, pos, ignored, item) -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)item));
    }

    public static float[] getStackPosition(LogisticalTransporterBase transporter, TransporterStack stack, float partial) {
        Direction side = stack.getSide(transporter);
        float progress = ((float)stack.progress + partial) / 100.0f - 0.5f;
        return new float[]{0.5f + (float)side.getStepX() * progress, 0.25f + (float)side.getStepY() * progress, 0.5f + (float)side.getStepZ() * progress};
    }

    public static boolean canInsert(Level level, BlockPos pos, EnumColor color, ItemStack itemStack, Direction side, boolean force) {
        return TransporterUtils.canInsert(level, pos, WorldUtils.getTileEntity((BlockGetter)level, pos), color, itemStack, side, force);
    }

    public static boolean canInsert(Level level, BlockPos pos, @Nullable BlockEntity tile, EnumColor color, ItemStack itemStack, Direction side, boolean force) {
        IItemHandler inventory;
        ISideConfiguration config;
        if (force && tile instanceof IAdvancedTransportEjector) {
            IAdvancedTransportEjector sorter = (IAdvancedTransportEjector)tile;
            return sorter.canSendHome(itemStack);
        }
        if (!force && tile instanceof ISideConfiguration && (config = (ISideConfiguration)tile).getEjector().hasStrictInput()) {
            Direction tileSide = config.getDirection();
            EnumColor configColor = config.getEjector().getInputColor(RelativeSide.fromDirections(tileSide, side.getOpposite()));
            if (configColor != null && configColor != color) {
                return false;
            }
        }
        if ((inventory = (IItemHandler)Capabilities.ITEM.getCapabilityIfLoaded(level, pos, null, tile, side.getOpposite())) != null) {
            int slots = inventory.getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack rejects = inventory.insertItem(i, itemStack, true);
                if (!TransporterManager.didEmit(itemStack, rejects)) continue;
                return true;
            }
        }
        return false;
    }
}

