/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world.height;

import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedEnumValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.resource.ore.BaseOreConfig;
import mekanism.common.world.height.ConfigurableVerticalAnchor;
import mekanism.common.world.height.HeightShape;
import net.neoforged.neoforge.common.ModConfigSpec;

public record ConfigurableHeightRange(Supplier<HeightShape> shape, ConfigurableVerticalAnchor minInclusive, ConfigurableVerticalAnchor maxInclusive, IntSupplier plateau) {
    public static ConfigurableHeightRange create(IMekanismConfig config, ModConfigSpec.Builder builder, String veinType, BaseOreConfig baseConfig) {
        CachedEnumValue<HeightShape> shape = CachedEnumValue.wrap(config, builder.comment("Distribution shape for placing " + veinType + "s.").defineEnum("shape", (Enum)baseConfig.shape()));
        ConfigurableVerticalAnchor minInclusive = ConfigurableVerticalAnchor.create(config, builder, "minInclusive", "Minimum (inclusive) height anchor for " + veinType + "s.", baseConfig.min(), null);
        return new ConfigurableHeightRange(shape, minInclusive, ConfigurableVerticalAnchor.create(config, builder, "maxInclusive", "Maximum (inclusive) height anchor for " + veinType + "s.", baseConfig.max(), minInclusive), CachedIntValue.wrap(config, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Half length of short side of trapezoid, only used if shape is TRAPEZOID. A value of zero means the shape is a triangle.").define("plateau", (Object)baseConfig.plateau(), o -> {
            if (o instanceof Integer) {
                Integer value = (Integer)o;
                if (value == 0) {
                    return true;
                }
                return value > 0 && shape.getOrDefault() == HeightShape.TRAPEZOID;
            }
            return false;
        })));
    }
}

