/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.info;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public interface Translatable {
    public String getTranslationKey();

    public static Component toComponent(Object value) {
        return Translatable.toComponent(value, (Component)Component.empty());
    }

    public static Component toComponent(Object value, Component defaultValue) {
        if (value instanceof Translatable) {
            Translatable translatable = (Translatable)value;
            return Component.translatable((String)translatable.getTranslationKey());
        }
        if (value instanceof StringRepresentable) {
            StringRepresentable string = (StringRepresentable)value;
            return Component.literal((String)string.getSerializedName());
        }
        if (value == null) {
            return defaultValue;
        }
        return Component.literal((String)Objects.toString(value));
    }
}

