/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.SpriteButton;
import com.teamresourceful.resourcefulconfig.client.screens.base.OverlayScreen;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class ColorOptionWidget
extends BaseWidget {
    private static final int SIZE = 16;
    private static final int PADDING = 4;
    private static final int SPACING = 2;
    private final int[] presets;
    private final IntSupplier getter;
    private final IntConsumer setter;

    public ColorOptionWidget(int[] presets, IntSupplier getter, IntConsumer setter) {
        super(16, 16);
        this.presets = presets;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(ModSprites.BUTTON, this.getX(), this.getY(), this.height, this.height);
        graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.height - 1, this.getY() + this.height - 1, this.getter.getAsInt());
    }

    public void onClick(double d, double e) {
        if (this.presets.length == 0) {
            return;
        }
        Minecraft.getInstance().setScreen((Screen)new PresetsOverlay(this));
    }

    private static class PresetsOverlay
    extends OverlayScreen {
        private final ColorOptionWidget widget;
        private int x;
        private int y;
        private int width;
        private int height;

        protected PresetsOverlay(ColorOptionWidget widget) {
            super(Minecraft.getInstance().screen);
            this.widget = widget;
        }

        @Override
        protected void init() {
            GridLayout layout = new GridLayout().spacing(2);
            GridLayout.RowHelper helper = layout.createRowHelper(5);
            for (int color : this.widget.presets) {
                helper.addChild((LayoutElement)new ColorButton(12, 12, 1, () -> {
                    this.widget.setter.accept(color);
                    this.onClose();
                }, color & 0xFFFFFF | 0xFF000000));
            }
            layout.arrangeElements();
            int y = this.widget.getY() > this.height / 2 ? this.widget.getY() - layout.getHeight() - 8 - 2 : this.widget.getY() + this.widget.getHeight() + 8 + 2;
            layout.setPosition(this.widget.getX() + 4, y + 4);
            layout.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
            this.x = this.widget.getX();
            this.y = y;
            this.width = layout.getWidth() + 8;
            this.height = layout.getHeight() + 8;
        }

        @Override
        public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderBackground(graphics, mouseX, mouseY, partialTicks);
            graphics.blitSprite(ModSprites.ACCENT, this.x, this.y, this.width, this.height);
            graphics.blitSprite(ModSprites.BUTTON, this.x + 1, this.y + 1, this.width - 2, this.height - 2);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            super.mouseClicked(mouseX, mouseY, button);
            this.onClose();
            return true;
        }
    }

    private static class ColorButton
    extends SpriteButton {
        private final int color;

        protected ColorButton(int width, int height, int padding, Runnable onPress, int color) {
            super(width, height, padding, null, onPress, null);
            this.color = color;
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            ResourceLocation button = this.isHovered() ? ModSprites.BUTTON_HOVER : ModSprites.BUTTON;
            graphics.blitSprite(button, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            graphics.fill(this.getX() + this.padding, this.getY() + this.padding, this.getX() + this.getWidth() - this.padding, this.getY() + this.getHeight() - this.padding, this.color);
        }
    }
}

