/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.loader;

import com.teamresourceful.resourcefulconfig.api.annotations.Category;
import com.teamresourceful.resourcefulconfig.api.annotations.Config;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigButton;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.api.loader.ConfigParser;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.entries.Observable;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.info.ParsedInfo;
import com.teamresourceful.resourcefulconfig.common.loader.ParsedCategory;
import com.teamresourceful.resourcefulconfig.common.loader.ParsedConfig;
import com.teamresourceful.resourcefulconfig.common.loader.buttons.ParsedButton;
import com.teamresourceful.resourcefulconfig.common.loader.entries.ParsedInstanceEntry;
import com.teamresourceful.resourcefulconfig.common.loader.entries.ParsedObjectEntry;
import com.teamresourceful.resourcefulconfig.common.loader.entries.ParsedObservableEntry;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class JavaConfigParser
implements ConfigParser {
    @Override
    public int priority() {
        return Integer.MIN_VALUE;
    }

    @Override
    public ResourcefulConfig parse(Class<?> clazz) {
        Config data = JavaConfigParser.assertAnnotation(clazz, Config.class);
        return JavaConfigParser.populateEntries(clazz, new ParsedConfig(data, ParsedInfo.of(clazz, data.value())), data.categories());
    }

    private static <T extends ResourcefulConfig> T populateEntries(Class<?> clazz, T config, Class<?>[] categories) {
        Annotation data;
        JavaConfigParser.assertValidClass(clazz);
        for (Field field : clazz.getDeclaredFields()) {
            ConfigButton button;
            data = JavaConfigParser.assertEntry(field);
            if (data != null) {
                if (data.type() == EntryType.OBJECT) {
                    Object instance = ParsingUtils.getField(field, null);
                    ParsedObjectEntry objectEntry = new ParsedObjectEntry(data.type(), field);
                    JavaConfigParser.populateEntries(instance, objectEntry);
                    config.entries().put(data.id(), objectEntry);
                } else if (field.getType() == Observable.class) {
                    ParsedObservableEntry observableEntry = ParsedObservableEntry.of(data.type(), field, null);
                    config.entries().put(data.id(), observableEntry);
                    if (observableEntry.defaultValue() == null) {
                        throw new IllegalArgumentException("Entry " + field.getName() + " must not have a null default value!");
                    }
                } else {
                    ParsedInstanceEntry instanceEntry = new ParsedInstanceEntry(data.type(), field, null);
                    config.entries().put(data.id(), instanceEntry);
                    if (instanceEntry.defaultValue() == null) {
                        throw new IllegalArgumentException("Entry " + field.getName() + " must not have a null default value!");
                    }
                }
            }
            if ((button = JavaConfigParser.assertButton(field)) == null) continue;
            String lastEntry = config.entries().isEmpty() ? "" : (String)config.entries().lastEntry().getKey();
            config.buttons().add(ParsedButton.of(field, lastEntry));
        }
        for (AnnotatedElement annotatedElement : categories) {
            data = JavaConfigParser.assertAnnotation(annotatedElement, Category.class);
            config.categories().put(data.value(), JavaConfigParser.populateEntries(annotatedElement, new ParsedCategory((Category)data, ParsedInfo.of(annotatedElement, data.value()), config), data.categories()));
        }
        return config;
    }

    private static void populateEntries(Object instance, ParsedObjectEntry entry) {
        JavaConfigParser.assertValidClass(instance.getClass());
        for (Field field : instance.getClass().getDeclaredFields()) {
            ConfigEntry data = JavaConfigParser.assertAcciessbleEntry(instance, field);
            if (data == null) continue;
            if (data.type() == EntryType.OBJECT) {
                throw new IllegalArgumentException("Entry " + field.getName() + " cannot be an object!");
            }
            Record valueEntry = field.getType() == Observable.class ? ParsedObservableEntry.of(data.type(), field, null) : new ParsedInstanceEntry(data.type(), field, instance);
            if (valueEntry.defaultValue() == null) {
                throw new IllegalArgumentException("Entry " + field.getName() + " must not have a null default value!");
            }
            entry.entries().put(data.id(), (ResourcefulConfigEntry)((Object)valueEntry));
        }
    }

    private static ConfigButton assertButton(Field field) {
        ConfigButton data = field.getAnnotation(ConfigButton.class);
        if (data == null) {
            return null;
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new IllegalArgumentException("Button " + field.getName() + " is not public!");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Button " + field.getName() + " is not static!");
        }
        if (!Modifier.isFinal(field.getModifiers())) {
            throw new IllegalArgumentException("Button " + field.getName() + " is not final!");
        }
        if (field.getType() != Runnable.class) {
            throw new IllegalArgumentException("Button " + field.getName() + " is not of type Runnable!");
        }
        return data;
    }

    private static ConfigEntry assertEntry(Field field) {
        ConfigEntry data = JavaConfigParser.assertAcciessbleEntry(null, field);
        String name = field.getName();
        if (data == null) {
            return null;
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Entry " + name + " is not static!");
        }
        return data;
    }

    private static Class<?> getFieldType(Object instance, Field field, EntryType entry) {
        Class<?> type = field.getType();
        if (type.isArray()) {
            if (!entry.isAllowedInArrays()) {
                throw new IllegalArgumentException("Entry " + field.getName() + " is an array but its type is not allowed in arrays!");
            }
            type = type.getComponentType();
        } else if (type == Observable.class) {
            try {
                return ((Observable)field.get(instance)).type();
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Entry " + field.getName() + " is not accessible!");
            }
        }
        return type;
    }

    private static ConfigEntry assertAcciessbleEntry(Object instance, Field field) {
        ConfigEntry data = field.getAnnotation(ConfigEntry.class);
        String name = field.getName();
        if (data == null) {
            return null;
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new IllegalArgumentException("Entry " + name + " is not public!");
        }
        if (data.type().mustBeFinal() && !Modifier.isFinal(field.getModifiers())) {
            throw new IllegalArgumentException("Entry " + name + " must be final!");
        }
        if (!data.type().mustBeFinal() && Modifier.isFinal(field.getModifiers())) {
            throw new IllegalArgumentException("Entry " + name + " must not be final!");
        }
        Class<?> type = JavaConfigParser.getFieldType(instance, field, data.type());
        if (!data.type().test(type)) {
            throw new IllegalArgumentException("Entry " + field.getName() + " is not of type " + data.type().name() + "!");
        }
        if (data.id().contains(".")) {
            throw new IllegalArgumentException("Entry " + field.getName() + " has an invalid id! Ids must not contain '.'");
        }
        return data;
    }

    private static <T extends Annotation> T assertAnnotation(AnnotatedElement element, Class<T> annotation) {
        T instance = element.getAnnotation(annotation);
        if (instance == null) {
            throw new IllegalArgumentException("Class " + String.valueOf(element) + " is missing required annotation " + annotation.getName());
        }
        return instance;
    }

    private static void assertValidClass(Class<?> config) {
        if (!Modifier.isPublic(config.getModifiers())) {
            throw new IllegalArgumentException("Config class must be public!");
        }
        if (config.getEnclosingClass() != null && !Modifier.isStatic(config.getModifiers())) {
            throw new IllegalArgumentException("Config class must be static!");
        }
        if (config.isEnum()) {
            throw new IllegalArgumentException("Config class cannot be an enum!");
        }
        if (config.isInterface()) {
            throw new IllegalArgumentException("Config class cannot be an interface!");
        }
        if (config.isAnnotation()) {
            throw new IllegalArgumentException("Config class cannot be an annotation!");
        }
        if (config.isRecord()) {
            throw new IllegalArgumentException("Config class cannot be a record!");
        }
    }
}

