/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneVisibilities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class EditWaystoneMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<EditWaystoneMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)"edit_waystone"));
    private final UUID waystoneUid;
    private final String name;
    private final WaystoneVisibility visibility;

    public EditWaystoneMessage(UUID waystoneUid, String name, WaystoneVisibility visibility) {
        this.waystoneUid = waystoneUid;
        this.name = name;
        this.visibility = visibility;
    }

    public static void encode(FriendlyByteBuf buf, EditWaystoneMessage message) {
        buf.writeUUID(message.waystoneUid);
        buf.writeUtf(message.name);
        buf.writeEnum((Enum)message.visibility);
    }

    public static EditWaystoneMessage decode(FriendlyByteBuf buf) {
        UUID waystoneUid = buf.readUUID();
        String name = buf.readUtf(255);
        WaystoneVisibility visibility = (WaystoneVisibility)buf.readEnum(WaystoneVisibility.class);
        return new EditWaystoneMessage(waystoneUid, name, visibility);
    }

    public static void handle(ServerPlayer player, EditWaystoneMessage message) {
        WaystoneProxy waystone = new WaystoneProxy(player.server, message.waystoneUid);
        Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone((Player)player, player.level(), waystone);
        if (error.isPresent()) {
            return;
        }
        WaystoneVisibility visibility = message.visibility;
        List<WaystoneVisibility> visibilityOptions = WaystoneVisibilities.getVisibilityOptions((Player)player, waystone);
        if (!visibilityOptions.contains((Object)message.visibility)) {
            Waystones.logger.warn("{} tried to edit a waystone with an invalid visibility {}", (Object)player.getName().getString(), (Object)message.visibility);
            visibility = visibilityOptions.getFirst();
        }
        if (!WaystonePermissionManager.isAllowedVisibility(visibility) && !WaystonePermissionManager.skipsPermissions((Player)player)) {
            Waystones.logger.warn("{} tried to edit a restricted waystone without permission", (Object)player.getName().getString());
            return;
        }
        BlockPos pos = waystone.getPos();
        if (player.distanceToSqr((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f)) > 64.0) {
            return;
        }
        WaystoneImpl backingWaystone = (WaystoneImpl)waystone.getBackingWaystone();
        Component legalName = EditWaystoneMessage.makeNameLegal(player.server, message.name);
        backingWaystone.setName(legalName);
        if (visibility == WaystoneVisibility.GLOBAL && (WaystonePermissionManager.isAllowedVisibility(visibility) || WaystonePermissionManager.skipsPermissions((Player)player)) && backingWaystone.getVisibility() != WaystoneVisibility.GLOBAL) {
            PlayerWaystoneManager.activeWaystoneForEveryone(player.server, backingWaystone);
        }
        backingWaystone.setVisibility(visibility);
        WaystoneManagerImpl.get(player.server).setDirty();
        WaystoneSyncManager.sendWaystoneUpdateToAll(player.server, backingWaystone);
        player.closeContainer();
    }

    private static Component makeNameLegal(MinecraftServer server, String input) {
        if (input.trim().isEmpty()) {
            return Component.translatable((String)"waystones.untitled_waystone");
        }
        String inventoryButtonMode = WaystonesConfig.getActive().inventoryButton.inventoryButton;
        if (inventoryButtonMode.equals(input) && WaystoneManagerImpl.get(server).findWaystoneByName(input).isPresent()) {
            return Component.literal((String)(input + "*"));
        }
        return Component.literal((String)input);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

