/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.GuardStats;
import tallestegg.guardvillagers.GuardVillagerTags;
import tallestegg.guardvillagers.GuardVillagers;
import tallestegg.guardvillagers.client.GuardSounds;
import tallestegg.guardvillagers.common.entities.Guard;
import tallestegg.guardvillagers.common.entities.ai.goals.AttackEntityDaytimeGoal;
import tallestegg.guardvillagers.common.entities.ai.goals.GetOutOfWaterGoal;
import tallestegg.guardvillagers.common.entities.ai.goals.HealGolemGoal;
import tallestegg.guardvillagers.common.entities.ai.goals.HealGuardAndPlayerGoal;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.ai.goals.GolemFloatWaterGoal;

@EventBusSubscriber(modid="guardvillagers")
public class HandlerEvents {
    @SubscribeEvent
    public static void onEntityTarget(LivingChangeTargetEvent event) {
        boolean isVillager;
        LivingEntity entity = event.getEntity();
        LivingEntity target = event.getNewAboutToBeSetTarget();
        if (target == null || entity.getType() == GuardEntityType.GUARD.get()) {
            return;
        }
        boolean bl = isVillager = target.getType() == EntityType.VILLAGER || target.getType() == GuardEntityType.GUARD.get();
        if (isVillager) {
            List list = entity.level().getEntitiesOfClass(Mob.class, entity.getBoundingBox().inflate(((Double)GuardConfig.COMMON.GuardVillagerHelpRange.get()).doubleValue(), 5.0, ((Double)GuardConfig.COMMON.GuardVillagerHelpRange.get()).doubleValue()));
            for (Mob mob : list) {
                if (mob.getTarget() != null || mob.getType() != GuardEntityType.GUARD.get() && mob.getType() != EntityType.IRON_GOLEM) continue;
                if (mob.getTeam() != null && entity.getTeam() != null && entity.getTeam().isAlliedTo((Team)mob.getTeam())) {
                    return;
                }
                mob.setTarget(entity);
            }
        }
        if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            if (target instanceof Guard) {
                golem.setTarget(null);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent.Pre event) {
        boolean isGolem;
        LivingEntity entity = event.getEntity();
        Entity trueSource = event.getContainer().getSource().getEntity();
        if (entity == null || trueSource == null) {
            return;
        }
        boolean isVillager = entity.getType() == EntityType.VILLAGER || entity.getType() == GuardEntityType.GUARD.get();
        boolean bl = isGolem = isVillager || entity.getType() == EntityType.IRON_GOLEM;
        if (isGolem && trueSource.getType() == GuardEntityType.GUARD.get() && !((Boolean)GuardConfig.COMMON.guardArrowsHurtVillagers.get()).booleanValue()) {
            event.getContainer().setNewDamage(0.0f);
        }
        if (isVillager && event.getContainer().getSource().getEntity() instanceof Mob) {
            List list = trueSource.level().getEntitiesOfClass(Mob.class, trueSource.getBoundingBox().inflate(((Double)GuardConfig.COMMON.GuardVillagerHelpRange.get()).doubleValue(), 5.0, ((Double)GuardConfig.COMMON.GuardVillagerHelpRange.get()).doubleValue()));
            for (Mob mob : list) {
                boolean type = mob.getType() == GuardEntityType.GUARD.get() || mob.getType() == EntityType.IRON_GOLEM;
                boolean trueSourceGolem = trueSource.getType() == GuardEntityType.GUARD.get() || trueSource.getType() == EntityType.IRON_GOLEM;
                if (trueSourceGolem || !type || mob.getTarget() != null) continue;
                if (mob.getTeam() != null && entity.getTeam() != null && entity.getTeam().isAlliedTo((Team)mob.getTeam())) {
                    return;
                }
                mob.setTarget((LivingEntity)((Mob)event.getContainer().getSource().getEntity()));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            Vec3 vec3 = new Vec3((double)horse.xxa, (double)horse.yya, (double)horse.zza);
            if (horse.hasControllingPassenger() && horse.getControllingPassenger() instanceof Guard) {
                horse.setSpeed((float)horse.getAttributeValue(Attributes.MOVEMENT_SPEED));
                horse.travel(vec3);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Zombie zombie;
            Mob mob = (Mob)entity;
            if (mob instanceof Raider && ((Raider)mob).hasActiveRaid() && ((Boolean)GuardConfig.COMMON.RaidAnimals.get()).booleanValue()) {
                mob.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)((Raider)mob), Animal.class, false));
            }
            if (((Boolean)GuardConfig.COMMON.MobsAttackGuards.get()).booleanValue() && mob instanceof Enemy && !((List)GuardConfig.COMMON.MobBlackList.get()).contains(mob.getEncodeId())) {
                if (!(mob instanceof Spider)) {
                    mob.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal(mob, Guard.class, false));
                } else {
                    mob.targetSelector.addGoal(3, new AttackEntityDaytimeGoal<Guard>((Spider)mob, Guard.class));
                }
            }
            if (mob instanceof AbstractIllager) {
                AbstractIllager illager = (AbstractIllager)mob;
                if (((Boolean)GuardConfig.COMMON.IllagersRunFromPolarBears.get()).booleanValue()) {
                    illager.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)illager, PolarBear.class, 6.0f, 1.0, 1.2));
                }
                illager.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)illager, Guard.class, false));
            }
            if (mob instanceof AbstractVillager) {
                AbstractVillager abstractvillager = (AbstractVillager)mob;
                if (((Boolean)GuardConfig.COMMON.VillagersRunFromPolarBears.get()).booleanValue()) {
                    abstractvillager.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)abstractvillager, PolarBear.class, 6.0f, 1.0, 1.2));
                }
                if (((Boolean)GuardConfig.COMMON.WitchesVillager.get()).booleanValue()) {
                    abstractvillager.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)abstractvillager, Witch.class, 6.0f, 1.0, 1.2));
                }
            }
            if (mob instanceof Villager) {
                Villager villager = (Villager)mob;
                if (((Boolean)GuardConfig.COMMON.BlacksmithHealing.get()).booleanValue()) {
                    villager.goalSelector.addGoal(1, (Goal)new HealGolemGoal((Mob)villager));
                }
                if (((Boolean)GuardConfig.COMMON.ClericHealing.get()).booleanValue()) {
                    villager.goalSelector.addGoal(1, (Goal)new HealGuardAndPlayerGoal((Mob)villager, 1.0, 100, 0, 10.0f));
                }
            }
            if (mob instanceof IronGolem) {
                IronGolem golem = (IronGolem)mob;
                HurtByTargetGoal tolerateFriendlyFire = new HurtByTargetGoal((PathfinderMob)golem, new Class[]{Guard.class}).setAlertOthers(new Class[0]);
                golem.targetSelector.getAvailableGoals().stream().map(it -> it.getGoal()).filter(it -> it instanceof HurtByTargetGoal).findFirst().ifPresent(angerGoal -> {
                    golem.targetSelector.removeGoal(angerGoal);
                    golem.targetSelector.addGoal(2, (Goal)tolerateFriendlyFire);
                });
                if (((Boolean)GuardConfig.COMMON.golemFloat.get()).booleanValue()) {
                    golem.goalSelector.addGoal(1, (Goal)new GolemFloatWaterGoal((Mob)golem));
                    golem.goalSelector.addGoal(0, (Goal)new GetOutOfWaterGoal((PathfinderMob)golem, 1.0));
                }
            }
            if (mob instanceof Zombie && !((zombie = (Zombie)mob) instanceof ZombifiedPiglin)) {
                zombie.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Guard.class, false));
            }
            if (mob instanceof Ravager) {
                Ravager ravager = (Ravager)mob;
                ravager.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)ravager, Guard.class, false));
            }
            if (mob instanceof Witch) {
                Witch witch = (Witch)mob;
                if (((Boolean)GuardConfig.COMMON.WitchesVillager.get()).booleanValue()) {
                    witch.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)witch, AbstractVillager.class, true));
                    witch.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)witch, IronGolem.class, true));
                    witch.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)witch, Guard.class, false));
                }
            }
            if (mob instanceof Cat) {
                Cat cat = (Cat)mob;
                cat.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)cat, AbstractIllager.class, 12.0f, 1.0, 1.2));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Villager villager;
        Player player = event.getEntity();
        ItemStack itemstack = event.getEntity().getMainHandItem();
        Entity target = event.getTarget();
        if (itemstack.is(GuardVillagerTags.GUARD_CONVERT) && player.isCrouching() && target instanceof Villager && !(villager = (Villager)target).isBaby() && (villager.getVillagerData().getProfession() == VillagerProfession.NONE || villager.getVillagerData().getProfession() == VillagerProfession.NITWIT) && (!((Boolean)GuardConfig.COMMON.ConvertVillagerIfHaveHOTV.get()).booleanValue() || player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && ((Boolean)GuardConfig.COMMON.ConvertVillagerIfHaveHOTV.get()).booleanValue())) {
            HandlerEvents.convertVillager((LivingEntity)villager, player);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity blockEntity;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getHitVec().getBlockPos();
        BlockState originalBlock = player.level().getBlockState(pos);
        if (((Boolean)GuardConfig.COMMON.multiFollow.get()).booleanValue() && originalBlock.getBlock() instanceof BellBlock && (blockEntity = level.getBlockEntity(pos)) instanceof BellBlockEntity) {
            BellBlockEntity bellBlockEntity = (BellBlockEntity)blockEntity;
            if (!bellBlockEntity.shaking) {
                List list = player.level().getEntitiesOfClass(Guard.class, player.getBoundingBox().inflate(32.0, 32.0, 32.0));
                for (Guard guard : list) {
                    if (!GuardVillagers.canFollow(player)) continue;
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    guard.setFollowing(!guard.isFollowing());
                    guard.playSound((SoundEvent)GuardSounds.GUARD_YES.value());
                    if (guard.isFollowing()) {
                        guard.setOwnerId(player.getUUID());
                        guard.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 1));
                        level.playSound(null, pos, SoundEvents.BELL_RESONATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        continue;
                    }
                    guard.removeEffect(MobEffects.GLOWING);
                }
            }
        }
    }

    private static void convertVillager(LivingEntity entity, Player player) {
        player.swing(InteractionHand.MAIN_HAND);
        ItemStack itemstack = player.getItemBySlot(EquipmentSlot.MAINHAND);
        Guard guard = (Guard)((EntityType)GuardEntityType.GUARD.get()).create(entity.level());
        Villager villager = (Villager)entity;
        if (guard == null) {
            return;
        }
        if (entity.level().isClientSide) {
            SimpleParticleType iparticledata = ParticleTypes.HAPPY_VILLAGER;
            for (int i = 0; i < 10; ++i) {
                double d0 = villager.getRandom().nextGaussian() * 0.02;
                double d1 = villager.getRandom().nextGaussian() * 0.02;
                double d2 = villager.getRandom().nextGaussian() * 0.02;
                villager.level().addParticle((ParticleOptions)iparticledata, villager.getX() + (double)(villager.getRandom().nextFloat() * villager.getBbWidth() * 2.0f) - (double)villager.getBbWidth(), villager.getY() + 0.5 + (double)(villager.getRandom().nextFloat() * villager.getBbHeight()), villager.getZ() + (double)(villager.getRandom().nextFloat() * villager.getBbWidth() * 2.0f) - (double)villager.getBbWidth(), d0, d1, d2);
            }
        }
        guard.copyPosition((Entity)villager);
        guard.playSound((SoundEvent)GuardSounds.GUARD_YES.value(), 1.0f, 1.0f);
        guard.setItemSlot(EquipmentSlot.MAINHAND, itemstack.copy());
        guard.setVariant(villager.getVariant().toString());
        guard.setPersistenceRequired();
        guard.setCustomName(villager.getCustomName());
        guard.setCustomNameVisible(villager.isCustomNameVisible());
        guard.setDropChance(EquipmentSlot.HEAD, 100.0f);
        guard.setDropChance(EquipmentSlot.CHEST, 100.0f);
        guard.setDropChance(EquipmentSlot.FEET, 100.0f);
        guard.setDropChance(EquipmentSlot.LEGS, 100.0f);
        guard.setDropChance(EquipmentSlot.MAINHAND, 100.0f);
        guard.setDropChance(EquipmentSlot.OFFHAND, 100.0f);
        guard.getGossips().add(player.getUUID(), GossipType.MINOR_POSITIVE, ((Integer)GuardConfig.COMMON.reputationRequirement.get()).intValue());
        villager.level().addFreshEntity((Entity)guard);
        villager.releasePoi(MemoryModuleType.HOME);
        villager.releasePoi(MemoryModuleType.JOB_SITE);
        villager.releasePoi(MemoryModuleType.MEETING_POINT);
        villager.discard();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)guard);
            player.awardStat((ResourceLocation)GuardStats.GUARDS_MADE.get());
        }
    }
}

