/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.common.entities;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import org.jetbrains.annotations.NotNull;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.ModCompat;
import tallestegg.guardvillagers.client.GuardSounds;
import tallestegg.guardvillagers.common.entities.GuardContainer;
import tallestegg.guardvillagers.common.entities.ai.goals.ArmorerRepairGuardArmorGoal;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.loot_tables.GuardLootTables;
import tallestegg.guardvillagers.networking.GuardOpenInventoryPacket;

public class Guard
extends PathfinderMob
implements CrossbowAttackMob,
RangedAttackMob,
NeutralMob,
ContainerListener,
ReputationEventHandler {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final AttributeModifier USE_ITEM_SPEED_PENALTY = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"item_slow_down"), -0.25, AttributeModifier.Operation.ADD_VALUE);
    private static final EntityDataAccessor<Optional<BlockPos>> GUARD_POS = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Boolean> PATROLLING = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> GUARD_VARIANT = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> RUNNING_TO_EAT = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> KICKING = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FOLLOWING = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Map<Pose, EntityDimensions> SIZE_BY_POSE = ImmutableMap.builder().put((Object)Pose.SLEEPING, (Object)SLEEPING_DIMENSIONS).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.scalable((float)0.6f, (float)0.6f).withEyeHeight(0.4f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.scalable((float)0.6f, (float)0.6f).withEyeHeight(0.4f)).put((Object)Pose.SPIN_ATTACK, (Object)EntityDimensions.scalable((float)0.6f, (float)0.6f).withEyeHeight(0.4f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.scalable((float)0.6f, (float)1.5f).withEyeHeight(1.27f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, new Vec3(0.0, 0.6, 0.0)))).put((Object)Pose.DYING, (Object)EntityDimensions.fixed((float)0.2f, (float)0.2f).withEyeHeight(1.62f)).build();
    private static final UniformInt angerTime = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private final GossipContainer gossips = new GossipContainer();
    public long lastGossipTime;
    public long lastGossipDecayTime;
    public SimpleContainer guardInventory = new SimpleContainer(6);
    public int kickTicks;
    public int shieldCoolDown;
    public int kickCoolDown;
    public boolean interacting;
    protected boolean spawnWithArmor;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public Guard(EntityType<? extends Guard> type, Level world) {
        super(type, world);
        this.guardInventory.addListener((ContainerListener)this);
        this.setPersistenceRequired();
        if (((Boolean)GuardConfig.COMMON.GuardsOpenDoors.get()).booleanValue()) {
            ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        }
    }

    public static int slotToInventoryIndex(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> 1;
            case EquipmentSlot.FEET -> 3;
            case EquipmentSlot.HEAD -> 0;
            case EquipmentSlot.LEGS -> 2;
            default -> 0;
        };
    }

    public static String getVariantFromBiome(LevelAccessor world, BlockPos pos) {
        VillagerType type = VillagerType.byBiome((Holder)world.getBiome(pos));
        return type.toString();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ((Double)GuardConfig.STARTUP.healthModifier.get()).doubleValue()).add(Attributes.MOVEMENT_SPEED, ((Double)GuardConfig.STARTUP.speedModifier.get()).doubleValue()).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, ((Double)GuardConfig.STARTUP.followRangeModifier.get()).doubleValue());
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setPersistenceRequired();
        String type = Guard.getVariantFromBiome((LevelAccessor)this.level(), this.blockPosition());
        this.setVariant(type);
        RandomSource randomsource = worldIn.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, difficultyIn);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void doPush(@NotNull Entity entityIn) {
        if (entityIn instanceof PathfinderMob) {
            boolean attackTargets;
            PathfinderMob living = (PathfinderMob)entityIn;
            boolean bl = attackTargets = living.getTarget() instanceof Villager || living.getTarget() instanceof IronGolem || living.getTarget() instanceof Guard;
            if (attackTargets) {
                this.setTarget((LivingEntity)living);
            }
        }
        super.doPush(entityIn);
    }

    @Nullable
    public BlockPos getPatrolPos() {
        return ((Optional)this.entityData.get(GUARD_POS)).orElse(null);
    }

    public void setPatrolPos(BlockPos position) {
        this.entityData.set(GUARD_POS, Optional.ofNullable(position));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)GuardSounds.GUARD_AMBIENT.value();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)GuardSounds.GUARD_HURT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)GuardSounds.GUARD_DEATH.value();
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource source, boolean recentlyHitIn) {
        for (int i = 0; i < this.guardInventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.guardInventory.getItem(i);
            RandomSource randomsource = this.level().getRandom();
            if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || !(randomsource.nextFloat() < ((Double)GuardConfig.COMMON.chanceToDropEquipment.get()).floatValue())) continue;
            this.spawnAtLocation(itemstack);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        if (compound.contains("Type", 99)) {
            int variantint = compound.getInt("Type");
            if (variantint == 1) {
                compound.putString("Variant", "desert");
            } else if (variantint == 2) {
                compound.putString("Variant", "savanna");
            } else if (variantint == 3) {
                compound.putString("Variant", "swamp");
            } else if (variantint == 4) {
                compound.putString("Variant", "jungle");
            } else if (variantint == 5) {
                compound.putString("Variant", "taiga");
            } else if (variantint == 6) {
                compound.putString("Variant", "snow");
            } else if (variantint == 0) {
                compound.putString("Variant", "plains");
            }
        }
        UUID uUID = uuid = compound.hasUUID("Owner") ? compound.getUUID("Owner") : null;
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                this.setOwnerId(null);
            }
        }
        this.kickTicks = compound.getInt("KickTicks");
        this.setFollowing(compound.getBoolean("Following"));
        this.interacting = compound.getBoolean("Interacting");
        this.setPatrolling(compound.getBoolean("Patrolling"));
        this.shieldCoolDown = compound.getInt("KickCooldown");
        this.kickCoolDown = compound.getInt("ShieldCooldown");
        this.lastGossipDecayTime = compound.getLong("LastGossipDecay");
        this.lastGossipTime = compound.getLong("LastGossipTime");
        this.spawnWithArmor = compound.getBoolean("SpawnWithArmor");
        this.setVariant(compound.getString("Variant"));
        if (compound.contains("PatrolPosX")) {
            int x = compound.getInt("PatrolPosX");
            int y = compound.getInt("PatrolPosY");
            int z = compound.getInt("PatrolPosZ");
            this.entityData.set(GUARD_POS, Optional.of(new BlockPos(x, y, z)));
        }
        ListTag listtag = compound.getList("Gossips", 10);
        this.gossips.update(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)listtag));
        ListTag listnbt = compound.getList("Inventory", 9);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.getCompound(i);
            int j = compoundnbt.getByte("Slot") & 0xFF;
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compoundnbt);
            if (!stack.isEmpty()) {
                this.guardInventory.setItem(j, stack);
                continue;
            }
            listtag.add((Object)new CompoundTag());
        }
        if (compound.contains("ArmorItems", 9)) {
            ListTag armorItems = compound.getList("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)armorItems.getCompound(i));
                if (!stack.isEmpty()) {
                    int index = Guard.slotToInventoryIndex(this.getEquipmentSlotForItem(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)armorItems.getCompound(i)).orElse(ItemStack.EMPTY)));
                    this.guardInventory.setItem(index, stack);
                    continue;
                }
                listtag.add((Object)new CompoundTag());
            }
            if (compound.contains("HandItems", 9)) {
                ListTag handItems = compound.getList("HandItems", 10);
                for (int i = 0; i < this.handItems.size(); ++i) {
                    int handSlot;
                    int n = handSlot = i == 0 ? 5 : 4;
                    if (!ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)handItems.getCompound(i)).isEmpty()) {
                        this.guardInventory.setItem(handSlot, ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)handItems.getCompound(i)));
                        continue;
                    }
                    listtag.add((Object)new CompoundTag());
                }
                if (!this.level().isClientSide) {
                    this.readPersistentAngerSaveData(this.level(), compound);
                }
            }
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Variant", this.getVariant());
        compound.putInt("KickTicks", this.kickTicks);
        compound.putInt("ShieldCooldown", this.shieldCoolDown);
        compound.putInt("KickCooldown", this.kickCoolDown);
        compound.putBoolean("Following", this.isFollowing());
        compound.putBoolean("Interacting", this.interacting);
        compound.putBoolean("Patrolling", this.isPatrolling());
        compound.putBoolean("SpawnWithArmor", this.spawnWithArmor);
        compound.putLong("LastGossipTime", this.lastGossipTime);
        compound.putLong("LastGossipDecay", this.lastGossipDecayTime);
        if (this.getOwnerId() != null) {
            compound.putUUID("Owner", this.getOwnerId());
        }
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.guardInventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.guardInventory.getItem(i);
            if (!itemstack.isEmpty()) {
                CompoundTag compoundnbt = new CompoundTag();
                compoundnbt.putByte("Slot", (byte)i);
                listnbt.add((Object)itemstack.save((HolderLookup.Provider)this.registryAccess(), (Tag)compoundnbt));
                continue;
            }
            listnbt.add((Object)new CompoundTag());
        }
        compound.put("Inventory", (Tag)listnbt);
        if (this.getPatrolPos() != null) {
            compound.putInt("PatrolPosX", this.getPatrolPos().getX());
            compound.putInt("PatrolPosY", this.getPatrolPos().getY());
            compound.putInt("PatrolPosZ", this.getPatrolPos().getZ());
        }
        compound.put("Gossips", (Tag)this.gossips.store((DynamicOps)NbtOps.INSTANCE));
        this.addPersistentAngerSaveData(compound);
    }

    private void maybeDecayGossip() {
        long i = this.level().getGameTime();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = i;
        } else if (i >= this.lastGossipDecayTime + 24000L) {
            this.gossips.decay();
            this.lastGossipDecayTime = i;
        }
    }

    protected void completeUsingItem() {
        if (this.isUsingItem()) {
            InteractionHand interactionhand = this.getUsedItemHand();
            if (!this.useItem.equals(this.getItemInHand(interactionhand))) {
                this.releaseUsingItem();
            } else if (!this.useItem.isEmpty() && this.isUsingItem()) {
                this.triggerItemUseEffects(this.useItem, 16);
                ItemStack copy = this.useItem.copy();
                ItemStack itemstack = EventHooks.onItemUseFinish((LivingEntity)this, (ItemStack)copy, (int)this.getUseItemRemainingTicks(), (ItemStack)this.useItem.finishUsingItem(this.level(), (LivingEntity)this));
                if (itemstack != this.useItem) {
                    this.setItemInHand(interactionhand, itemstack);
                }
                if (this.useItem.getUseAnimation() != UseAnim.EAT) {
                    this.useItem.shrink(1);
                }
                this.stopUsingItem();
            }
        }
    }

    @NotNull
    public ItemStack getItemBySlot(EquipmentSlot pSlot) {
        return switch (pSlot) {
            case EquipmentSlot.HEAD -> this.guardInventory.getItem(0);
            case EquipmentSlot.CHEST -> this.guardInventory.getItem(1);
            case EquipmentSlot.LEGS -> this.guardInventory.getItem(2);
            case EquipmentSlot.FEET -> this.guardInventory.getItem(3);
            case EquipmentSlot.OFFHAND -> this.guardInventory.getItem(4);
            case EquipmentSlot.MAINHAND -> this.guardInventory.getItem(5);
            default -> ItemStack.EMPTY;
        };
    }

    public GossipContainer getGossips() {
        return this.gossips;
    }

    public int getPlayerReputation(Player player) {
        return this.gossips.getReputation(player.getUUID(), gossipType -> true);
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            boolean heroOfTheVillage = uuid != null && this.level().getPlayerByUUID(uuid) != null && Objects.requireNonNull(this.level().getPlayerByUUID(uuid)).hasEffect(MobEffects.HERO_OF_THE_VILLAGE);
            return uuid == null || this.level().getPlayerByUUID(uuid) != null && !heroOfTheVillage && (Boolean)GuardConfig.COMMON.followHero.get() != false || (Boolean)GuardConfig.COMMON.followHero.get() == false && this.level().getPlayerByUUID(uuid) == null ? null : this.level().getPlayerByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(LivingEntity entityIn) {
        return entityIn == this.getOwner();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public boolean doHurtTarget(@NotNull Entity entityIn) {
        if (this.isKicking()) {
            ((LivingEntity)entityIn).knockback(1.0, (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
            this.kickTicks = 10;
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            this.lookAt(entityIn, 90.0f, 90.0f);
        }
        ItemStack hand = this.getMainHandItem();
        hand.hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.MAINHAND);
        return super.doHurtTarget(entityIn);
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.kickTicks = 10;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean isImmobile() {
        return this.interacting || super.isImmobile();
    }

    public void die(@NotNull DamageSource source) {
        if ((this.level().getDifficulty() == Difficulty.NORMAL || this.level().getDifficulty() == Difficulty.HARD) && source.getEntity() instanceof Zombie && EventHooks.canLivingConvert((LivingEntity)((LivingEntity)source.getEntity()), (EntityType)EntityType.ZOMBIE_VILLAGER, timer -> {})) {
            ZombieVillager zombieguard = (ZombieVillager)this.convertTo(EntityType.ZOMBIE_VILLAGER, true);
            if (this.level().getDifficulty() != Difficulty.HARD && this.random.nextBoolean() || zombieguard == null) {
                return;
            }
            if (!this.isSilent()) {
                this.level().levelEvent(null, 1026, this.blockPosition(), 0);
            }
            this.discard();
        }
        super.die(source);
    }

    @NotNull
    public ItemStack eat(@NotNull Level world, ItemStack stack, @NotNull FoodProperties foodProperties) {
        if (stack.getUseAnimation() == UseAnim.EAT) {
            this.heal(foodProperties.nutrition());
        }
        world.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        super.eat(world, stack, foodProperties);
        return stack;
    }

    public void aiStep() {
        if (this.kickTicks > 0) {
            --this.kickTicks;
        }
        if (this.kickCoolDown > 0) {
            --this.kickCoolDown;
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
        }
        if (this.getHealth() < this.getMaxHealth() && this.tickCount % 200 == 0) {
            this.heal(((Double)GuardConfig.COMMON.amountOfHealthRegenerated.get()).floatValue());
        }
        if (this.spawnWithArmor) {
            Guard.getItemsFromLootTable((LivingEntity)this);
            this.spawnWithArmor = false;
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
        this.updateSwingTime();
        super.aiStep();
    }

    public void tick() {
        this.maybeDecayGossip();
        super.tick();
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        return SIZE_BY_POSE.getOrDefault(pose, EntityDimensions.scalable((float)0.6f, (float)1.95f));
    }

    protected void blockUsingShield(@NotNull LivingEntity entityIn) {
        super.blockUsingShield(entityIn);
        this.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, 1.0f);
        if (entityIn.getMainHandItem().canDisableShield(this.useItem, (LivingEntity)this, entityIn)) {
            this.disableShield();
        }
    }

    protected void hurtCurrentlyUsedShield(float damage) {
        if (this.useItem.canPerformAction(ItemAbilities.SHIELD_BLOCK) && damage >= 3.0f) {
            int i = 1 + Mth.floor((float)damage);
            InteractionHand hand = this.getUsedItemHand();
            this.useItem.hurtAndBreak(i, (LivingEntity)this, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (this.useItem.isEmpty()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                } else {
                    this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                }
                this.useItem = ItemStack.EMPTY;
                this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
            }
        }
    }

    public void startUsingItem(@NotNull InteractionHand hand) {
        super.startUsingItem(hand);
        ItemStack itemstack = this.getItemInHand(hand);
        if (itemstack.canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
            AttributeInstance modifiableattributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
            assert (modifiableattributeinstance != null);
            modifiableattributeinstance.removeModifier(USE_ITEM_SPEED_PENALTY);
            modifiableattributeinstance.addTransientModifier(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void stopUsingItem() {
        super.stopUsingItem();
        if (this.getAttribute(Attributes.MOVEMENT_SPEED).hasModifier(USE_ITEM_SPEED_PENALTY.id())) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void disableShield() {
        this.shieldCoolDown = 100;
        this.stopUsingItem();
        this.level().broadcastEntityEvent((Entity)this, (byte)30);
    }

    protected void defineSynchedData(SynchedEntityData.Builder data) {
        super.defineSynchedData(data);
        data.define(GUARD_VARIANT, (Object)VillagerType.PLAINS.toString());
        data.define(DATA_CHARGING_STATE, (Object)false);
        data.define(KICKING, (Object)false);
        data.define(OWNER_UNIQUE_ID, Optional.empty());
        data.define(FOLLOWING, (Object)false);
        data.define(GUARD_POS, Optional.empty());
        data.define(PATROLLING, (Object)false);
        data.define(RUNNING_TO_EAT, (Object)false);
    }

    public void setChargingCrossbow(boolean charging) {
        this.entityData.set(DATA_CHARGING_STATE, (Object)charging);
    }

    public boolean isKicking() {
        return (Boolean)this.entityData.get(KICKING);
    }

    public void setKicking(boolean kicking) {
        this.entityData.set(KICKING, (Object)kicking);
    }

    protected void populateDefaultEquipmentSlots(RandomSource source, DifficultyInstance instance) {
        this.handDropChances[EquipmentSlot.MAINHAND.getIndex()] = 100.0f;
        this.handDropChances[EquipmentSlot.OFFHAND.getIndex()] = 100.0f;
        this.spawnWithArmor = true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new KickGoal(this));
        this.goalSelector.addGoal(0, (Goal)new GuardEatFoodGoal(this));
        this.goalSelector.addGoal(0, (Goal)new RaiseShieldGoal(this));
        this.goalSelector.addGoal(1, (Goal)new GuardRunToEatGoal(this));
        this.goalSelector.addGoal(3, new RangedCrossbowAttackPassiveGoal<Guard>(this, 1.0, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new GuardBowAttack(this, 0.5, 20, 15.0f));
        if (ModList.get().isLoaded("musketmod")) {
            this.goalSelector.addGoal(3, new ModCompat.UseMusketGoal<Guard>(this, 1.55, 20, 15.0f));
        }
        this.goalSelector.addGoal(3, (Goal)new GuardMeleeGoal(this, 0.8, true));
        this.goalSelector.addGoal(4, (Goal)new FollowHeroGoal(this, 0.8f, 10.0f, 4.0f));
        if (((Boolean)GuardConfig.COMMON.GuardsRunFromPolarBears.get()).booleanValue()) {
            this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 12.0f, 1.0, 1.2));
        }
        this.goalSelector.addGoal(4, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.5, false));
        if (((Boolean)GuardConfig.COMMON.GuardsOpenDoors.get()).booleanValue()) {
            this.goalSelector.addGoal(4, (Goal)new GuardInteractDoorGoal(this, true));
        }
        if (((Boolean)GuardConfig.COMMON.GuardFormation.get()).booleanValue()) {
            this.goalSelector.addGoal(6, (Goal)new FollowShieldGuards(this));
        }
        if (((Boolean)GuardConfig.COMMON.ClericHealing.get()).booleanValue()) {
            this.goalSelector.addGoal(6, (Goal)new RunToClericGoal(this));
        }
        if (((Boolean)GuardConfig.COMMON.armorersRepairGuardArmor.get()).booleanValue()) {
            this.goalSelector.addGoal(6, (Goal)new ArmorerRepairGuardArmorGoal(this));
        }
        this.goalSelector.addGoal(5, (Goal)new WalkBackToCheckPointGoal(this, 0.5));
        this.goalSelector.addGoal(5, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.5));
        if (((Boolean)GuardConfig.COMMON.guardPatrolVillageAi.get()).booleanValue()) {
            this.goalSelector.addGoal(5, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.5, false, 4, () -> false));
        }
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new GuardLookAtAndStopMovingWhenBeingTheInteractionTarget(this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Guard.class, IronGolem.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new HeroHurtByTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new HeroHurtTargetGoal(this));
        this.targetSelector.addGoal(5, (Goal)new DefendVillageGuardGoal(this));
        if (((Boolean)GuardConfig.COMMON.AttackAllMobs.get()).booleanValue()) {
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, true, mob -> mob instanceof Enemy && !((List)GuardConfig.COMMON.MobBlackList.get()).contains(mob.getEncodeId())));
        } else {
            this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, true));
            this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, true));
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
            this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, mob -> !(mob instanceof ZombifiedPiglin)));
        }
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, true, true, mob -> ((List)GuardConfig.COMMON.MobWhiteList.get()).contains(mob.getEncodeId())));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Guard)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean mayBeLeashed() {
        return false;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        this.shieldCoolDown = 8;
        if (this.getMainHandItem().getItem() instanceof CrossbowItem) {
            this.performCrossbowAttack((LivingEntity)this, 1.6f);
        }
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            ItemStack hand = this.getMainHandItem();
            ItemStack itemstack = this.getProjectile(hand);
            AbstractArrow abstractarrowentity = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor, (ItemStack)hand);
            abstractarrowentity = ((BowItem)this.getMainHandItem().getItem()).customArrow(abstractarrowentity, itemstack, hand);
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - abstractarrowentity.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            abstractarrowentity.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
            this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)abstractarrowentity);
            hand.hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.MAINHAND);
        }
        if (ModList.get().isLoaded("musketmod")) {
            ModCompat.shootGun(this);
        }
    }

    public void performCrossbowAttack(LivingEntity p_32337_, float p_32338_) {
        InteractionHand interactionhand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)p_32337_, item -> item instanceof CrossbowItem);
        ItemStack itemstack = p_32337_.getItemInHand(interactionhand);
        Item item2 = itemstack.getItem();
        if (item2 instanceof CrossbowItem) {
            CrossbowItem crossbowitem = (CrossbowItem)item2;
            crossbowitem.performShooting(p_32337_.level(), p_32337_, interactionhand, itemstack, p_32338_, 1.0f, null);
        }
        this.onCrossbowAttackPerformed();
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
        super.setItemSlot(slotIn, stack);
        switch (slotIn) {
            case CHEST: {
                if (!this.guardInventory.getItem(1).isEmpty()) break;
                this.guardInventory.setItem(1, (ItemStack)this.armorItems.get(slotIn.getIndex()));
                break;
            }
            case FEET: {
                if (!this.guardInventory.getItem(3).isEmpty()) break;
                this.guardInventory.setItem(3, (ItemStack)this.armorItems.get(slotIn.getIndex()));
                break;
            }
            case HEAD: {
                if (!this.guardInventory.getItem(0).isEmpty()) break;
                this.guardInventory.setItem(0, (ItemStack)this.armorItems.get(slotIn.getIndex()));
                break;
            }
            case LEGS: {
                if (!this.guardInventory.getItem(2).isEmpty()) break;
                this.guardInventory.setItem(2, (ItemStack)this.armorItems.get(slotIn.getIndex()));
                break;
            }
            case MAINHAND: {
                this.guardInventory.setItem(5, (ItemStack)this.handItems.get(slotIn.getIndex()));
                break;
            }
            case OFFHAND: {
                this.guardInventory.setItem(4, (ItemStack)this.handItems.get(slotIn.getIndex()));
            }
        }
    }

    public ItemStack getProjectile(ItemStack shootable) {
        if (shootable.getItem() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)shootable.getItem()).getSupportedHeldProjectiles();
            ItemStack itemstack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)this, (Predicate)predicate);
            return itemstack.isEmpty() ? new ItemStack((ItemLike)Items.ARROW) : itemstack;
        }
        return ItemStack.EMPTY;
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public boolean isFollowing() {
        return (Boolean)this.entityData.get(FOLLOWING);
    }

    public void setFollowing(boolean following) {
        this.entityData.set(FOLLOWING, (Object)following);
    }

    public boolean canAttack(LivingEntity target) {
        return !((List)GuardConfig.COMMON.MobBlackList.get()).contains(target.getEncodeId()) && !target.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && !this.isOwner(target) && super.canAttack(target);
    }

    public void rideTick() {
        super.rideTick();
        Entity entity = this.getVehicle();
        if (entity instanceof PathfinderMob) {
            PathfinderMob creatureentity = (PathfinderMob)entity;
            this.yBodyRot = creatureentity.yBodyRot;
        }
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public void setTarget(LivingEntity entity) {
        TamableAnimal tamed;
        if (entity != null && (this.getTeam() != null && entity.getTeam() != null && this.getTeam().isAlliedTo((Team)this.getTeam()) || ((List)GuardConfig.COMMON.MobBlackList.get()).contains(entity.getEncodeId()) || entity.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) || this.isOwner(entity) || entity instanceof TamableAnimal && (tamed = (TamableAnimal)entity).getOwnerUUID() == this.getOwnerId())) {
            return;
        }
        super.setTarget(entity);
    }

    public void gossip(Villager villager, long gameTime) {
        if (!(gameTime >= this.lastGossipTime && gameTime < this.lastGossipTime + 1200L || gameTime >= villager.lastGossipTime && gameTime < villager.lastGossipTime + 1200L)) {
            this.gossips.transferFrom(villager.getGossips(), this.random, 10);
            this.lastGossipTime = gameTime;
            villager.lastGossipTime = gameTime;
        }
    }

    protected void blockedByShield(LivingEntity entityIn) {
        if (this.isKicking()) {
            this.setKicking(false);
        }
        super.blockedByShield((LivingEntity)this);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean inventoryRequirements;
        boolean configValues = player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && (Boolean)GuardConfig.COMMON.giveGuardStuffHOTV.get() != false || player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && (Boolean)GuardConfig.COMMON.setGuardPatrolHotv.get() != false || player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && (Boolean)GuardConfig.COMMON.giveGuardStuffHOTV.get() != false && (Boolean)GuardConfig.COMMON.setGuardPatrolHotv.get() != false || this.getPlayerReputation(player) >= (Integer)GuardConfig.COMMON.reputationRequirement.get() || player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && (Boolean)GuardConfig.COMMON.giveGuardStuffHOTV.get() == false && (Boolean)GuardConfig.COMMON.setGuardPatrolHotv.get() == false || this.getOwnerId() != null && this.getOwnerId().equals(player.getUUID());
        boolean bl = inventoryRequirements = !player.isSecondaryUseActive();
        if (inventoryRequirements) {
            if (this.getTarget() != player && this.isEffectiveAi() && configValues && player instanceof ServerPlayer) {
                this.openGui((ServerPlayer)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public void onReputationEventFrom(ReputationEventType reputationEventType, Entity entity) {
    }

    public void containerChanged(Container invBasic) {
    }

    protected void hurtArmor(DamageSource damageSource, float damage) {
        this.doHurtEquipment(damageSource, damage, new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD});
    }

    public void thunderHit(ServerLevel p_241841_1_, LightningBolt p_241841_2_) {
        if (p_241841_1_.getDifficulty() != Difficulty.PEACEFUL && EventHooks.canLivingConvert((LivingEntity)this, (EntityType)EntityType.WITCH, timer -> {})) {
            Witch witchentity = (Witch)EntityType.WITCH.create((Level)p_241841_1_);
            if (witchentity == null) {
                return;
            }
            witchentity.copyPosition((Entity)this);
            witchentity.finalizeSpawn((ServerLevelAccessor)p_241841_1_, p_241841_1_.getCurrentDifficultyAt(witchentity.blockPosition()), MobSpawnType.CONVERSION, null);
            witchentity.setNoAi(this.isNoAi());
            witchentity.setCustomName(this.getCustomName());
            witchentity.setCustomNameVisible(this.isCustomNameVisible());
            witchentity.setPersistenceRequired();
            p_241841_1_.addFreshEntityWithPassengers((Entity)witchentity);
            this.discard();
        } else {
            super.thunderHit(p_241841_1_, p_241841_2_);
        }
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID arg0) {
        this.persistentAngerTarget = arg0;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int arg0) {
        this.remainingPersistentAngerTime = arg0;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(angerTime.sample(this.random));
    }

    public void openGui(ServerPlayer player) {
        this.setOwnerId(player.getUUID());
        if (player.containerMenu != player.inventoryMenu) {
            player.closeContainer();
        }
        this.interacting = true;
        player.nextContainerCounter();
        player.connection.send((CustomPacketPayload)new GuardOpenInventoryPacket(player.containerCounter, this.guardInventory.getContainerSize(), this.getId()));
        player.containerMenu = new GuardContainer(player.containerCounter, player.getInventory(), (Container)this.guardInventory, this);
        player.initMenu(player.containerMenu);
        NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.containerMenu));
    }

    public boolean isEating() {
        return Guard.isConsumable(this.getUseItem()) && this.isUsingItem();
    }

    public boolean isPatrolling() {
        return (Boolean)this.entityData.get(PATROLLING);
    }

    public void setPatrolling(boolean patrolling) {
        this.entityData.set(PATROLLING, (Object)patrolling);
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem item) {
        return item instanceof BowItem || item instanceof CrossbowItem || super.canFireProjectileWeapon(item);
    }

    public static boolean isConsumable(ItemStack stack) {
        return stack.getUseAnimation() == UseAnim.EAT || stack.getUseAnimation() == UseAnim.DRINK && !(stack.getItem() instanceof SplashPotionItem);
    }

    public void tryToTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        if (livingentity != null) {
            this.teleportToAroundBlockPos(livingentity.blockPosition());
        }
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        return livingentity != null && this.distanceToSqr((Entity)this.getOwner()) >= 144.0 && (Boolean)GuardConfig.COMMON.guardTeleport.get() != false && this.getTarget() == null;
    }

    private void teleportToAroundBlockPos(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.random.nextIntBetweenInclusive(-4, 4);
            int k = this.random.nextIntBetweenInclusive(-4, 4);
            if (Math.abs(j) < 3 && Math.abs(k) < 3) continue;
            int l = this.random.nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(pos.getX() + j, pos.getY() + l, pos.getZ() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.moveTo((double)x + 0.5, y, (double)z + 0.5, this.getYRot(), this.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)this, (BlockPos)pos);
        if (pathtype != PathType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level().getBlockState(pos.below());
        if (blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)this.blockPosition());
        return this.level().noCollision((Entity)this, this.getBoundingBox().move(blockpos));
    }

    public static List<ItemStack> getItemsFromLootTable(LivingEntity entity) {
        LootTable loot = entity.level().getServer().reloadableRegistries().getLootTable(Guard.getLootTableFromData());
        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)entity.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        return loot.getRandomItems(lootcontext$builder.create(GuardLootTables.SLOT));
    }

    public static ResourceKey<LootTable> getLootTableFromData() {
        ResourceLocation lootTable = ResourceLocation.fromNamespaceAndPath((String)"guardvillagers", (String)"entities/guard_armor");
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable);
    }

    public void setVariant(String variant) {
        this.entityData.set(GUARD_VARIANT, (Object)variant);
    }

    public String getVariant() {
        return (String)this.entityData.get(GUARD_VARIANT);
    }

    public static class KickGoal
    extends Goal {
        public final Guard guard;

        public KickGoal(Guard guard) {
            this.guard = guard;
        }

        public boolean canUse() {
            return this.guard.getTarget() != null && (double)this.guard.getTarget().distanceTo((Entity)this.guard) <= 2.5 && this.guard.getMainHandItem().getItem().useOnRelease(this.guard.getMainHandItem()) && !this.guard.isBlocking() && this.guard.kickCoolDown == 0;
        }

        public void start() {
            this.guard.setKicking(true);
            if (this.guard.kickTicks <= 0) {
                this.guard.kickTicks = 10;
            }
            this.guard.doHurtTarget((Entity)this.guard.getTarget());
        }

        public void stop() {
            this.guard.setKicking(false);
            this.guard.kickCoolDown = 50;
        }
    }

    public static class GuardEatFoodGoal
    extends Goal {
        public final Guard guard;

        public GuardEatFoodGoal(Guard guard) {
            this.guard = guard;
        }

        public boolean canUse() {
            return this.guard.getHealth() < this.guard.getMaxHealth() && Guard.isConsumable(this.guard.getOffhandItem()) && this.guard.isEating() || this.guard.getHealth() < this.guard.getMaxHealth() && Guard.isConsumable(this.guard.getOffhandItem()) && this.guard.getTarget() == null && !this.guard.isAggressive();
        }

        public boolean canContinueToUse() {
            List list = this.guard.level().getEntitiesOfClass(LivingEntity.class, this.guard.getBoundingBox().inflate(5.0, 3.0, 5.0));
            if (!list.isEmpty()) {
                for (LivingEntity mob : list) {
                    if (mob == null || !(mob instanceof Mob) || !(((Mob)mob).getTarget() instanceof Guard)) continue;
                    return false;
                }
            }
            return this.guard.isUsingItem() && this.guard.getTarget() == null && this.guard.getHealth() < this.guard.getMaxHealth() || this.guard.getTarget() != null && this.guard.getHealth() < this.guard.getMaxHealth() / 2.0f + 2.0f && this.guard.isEating();
        }

        public void start() {
            this.guard.startUsingItem(InteractionHand.OFF_HAND);
        }
    }

    public static class RaiseShieldGoal
    extends Goal {
        public final Guard guard;

        public RaiseShieldGoal(Guard guard) {
            this.guard = guard;
        }

        public boolean canUse() {
            return !CrossbowItem.isCharged((ItemStack)this.guard.getMainHandItem()) && this.guard.getOffhandItem().getItem().canPerformAction(this.guard.getOffhandItem(), ItemAbilities.SHIELD_BLOCK) && this.raiseShield() && this.guard.shieldCoolDown == 0 && !this.guard.getOffhandItem().getItem().equals(BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"piglinproliferation", (String)"buckler")));
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void start() {
            if (this.guard.getOffhandItem().getItem().canPerformAction(this.guard.getOffhandItem(), ItemAbilities.SHIELD_BLOCK)) {
                this.guard.startUsingItem(InteractionHand.OFF_HAND);
            }
        }

        public void stop() {
            if (!((Boolean)GuardConfig.COMMON.GuardRaiseShield.get()).booleanValue()) {
                this.guard.stopUsingItem();
            }
        }

        protected boolean raiseShield() {
            LivingEntity target = this.guard.getTarget();
            if (target != null && this.guard.shieldCoolDown == 0) {
                boolean ranged = this.guard.getMainHandItem().getItem() instanceof CrossbowItem || this.guard.getMainHandItem().getItem() instanceof BowItem;
                return (double)this.guard.distanceTo((Entity)target) <= 4.0 || target instanceof Creeper || target instanceof RangedAttackMob && (double)target.distanceTo((Entity)this.guard) >= 5.0 && !ranged || target instanceof Ravager || (Boolean)GuardConfig.COMMON.GuardRaiseShield.get() != false;
            }
            return false;
        }
    }

    public static class GuardRunToEatGoal
    extends RandomStrollGoal {
        private final Guard guard;
        private int walkTimer;

        public GuardRunToEatGoal(Guard guard) {
            super((PathfinderMob)guard, 1.0);
            this.guard = guard;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.guard.getHealth() < this.guard.getMaxHealth() / 2.0f && Guard.isConsumable(this.guard.getOffhandItem()) && !this.guard.isEating() && this.guard.getTarget() != null && this.getPosition() != null;
        }

        public void start() {
            super.start();
            this.guard.setTarget(null);
            if (this.walkTimer <= 0) {
                this.walkTimer = 20;
            }
        }

        public void tick() {
            --this.walkTimer;
            List list = this.guard.level().getEntitiesOfClass(LivingEntity.class, this.guard.getBoundingBox().inflate(5.0, 3.0, 5.0));
            if (!list.isEmpty()) {
                for (LivingEntity mob : list) {
                    if (mob == null || !(mob.getLastHurtMob() instanceof Guard) && (!(mob instanceof Mob) || !(((Mob)mob).getTarget() instanceof Guard)) || this.walkTimer >= 20) continue;
                    this.walkTimer += 5;
                }
            }
        }

        protected Vec3 getPosition() {
            List list = this.guard.level().getEntitiesOfClass(LivingEntity.class, this.guard.getBoundingBox().inflate(5.0, 3.0, 5.0));
            if (!list.isEmpty()) {
                for (LivingEntity mob : list) {
                    if (mob == null || !(mob.getLastHurtMob() instanceof Guard) && (!(mob instanceof Mob) || !(((Mob)mob).getTarget() instanceof Guard))) continue;
                    return DefaultRandomPos.getPosAway((PathfinderMob)this.guard, (int)16, (int)7, (Vec3)mob.position());
                }
            }
            return super.getPosition();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.walkTimer > 0 && !this.guard.isEating();
        }

        public void stop() {
            super.stop();
            this.guard.startUsingItem(InteractionHand.OFF_HAND);
            this.guard.getNavigation().stop();
        }
    }

    public static class RangedCrossbowAttackPassiveGoal<T extends Guard>
    extends Goal {
        public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.rangeOfSeconds((int)1, (int)2);
        private final T mob;
        private final double speedModifier;
        private final float attackRadiusSqr;
        protected double wantedX;
        protected double wantedY;
        protected double wantedZ;
        private CrossbowState crossbowState = CrossbowState.UNCHARGED;
        private int seeTime;
        private int attackDelay;
        private int updatePathDelay;

        public RangedCrossbowAttackPassiveGoal(T pMob, double pSpeedModifier, float pAttackRadius) {
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.attackRadiusSqr = pAttackRadius * pAttackRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.isValidTarget() && this.isHoldingCrossbow();
        }

        private boolean isHoldingCrossbow() {
            return this.mob.isHolding(is -> is.getItem() instanceof CrossbowItem);
        }

        public boolean canContinueToUse() {
            return this.isValidTarget() && (this.canUse() || !this.mob.getNavigation().isDone()) && this.isHoldingCrossbow();
        }

        private boolean isValidTarget() {
            return this.mob.getTarget() != null && this.mob.getTarget().isAlive();
        }

        public void stop() {
            super.stop();
            this.mob.setAggressive(false);
            ((Guard)((Object)this.mob)).setTarget(null);
            this.seeTime = 0;
            if (this.mob.isUsingItem()) {
                ((Guard)((Object)this.mob)).stopUsingItem();
                ((Guard)((Object)this.mob)).setChargingCrossbow(false);
            }
            this.mob.setPose(Pose.STANDING);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void start() {
            this.mob.setAggressive(true);
        }

        public void tick() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity != null) {
                boolean canSee2;
                boolean hasSeenEntityRecently;
                boolean canSee = this.mob.getSensing().hasLineOfSight((Entity)livingentity);
                boolean bl = hasSeenEntityRecently = this.seeTime > 0;
                if (canSee != hasSeenEntityRecently) {
                    this.seeTime = 0;
                }
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                double d0 = this.mob.distanceToSqr((Entity)livingentity);
                double d1 = livingentity.distanceTo(this.mob);
                if (d1 <= 4.0) {
                    this.mob.getMoveControl().strafe(this.mob.isUsingItem() ? -0.5f : -3.0f, 0.0f);
                    this.mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
                }
                if (this.mob.getRandom().nextInt(50) == 0) {
                    if (this.mob.hasPose(Pose.STANDING)) {
                        this.mob.setPose(Pose.CROUCHING);
                    } else {
                        this.mob.setPose(Pose.STANDING);
                    }
                }
                boolean bl2 = canSee2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
                if (canSee2) {
                    --this.updatePathDelay;
                    if (this.updatePathDelay <= 0 && !((Guard)((Object)this.mob)).isPatrolling()) {
                        this.mob.getNavigation().moveTo((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                        this.updatePathDelay = PATHFINDING_DELAY_RANGE.sample(this.mob.getRandom());
                    }
                } else {
                    this.updatePathDelay = 0;
                    this.mob.getNavigation().stop();
                }
                this.mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
                this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
                if (RangedCrossbowAttackPassiveGoal.friendlyInLineOfSight(this.mob)) {
                    this.crossbowState = CrossbowState.FIND_NEW_POSITION;
                }
                if (this.crossbowState == CrossbowState.FIND_NEW_POSITION) {
                    ((Guard)((Object)this.mob)).stopUsingItem();
                    ((Guard)((Object)this.mob)).setChargingCrossbow(false);
                    if (this.findPosition()) {
                        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.mob.isCrouching() ? 0.5 : 0.9);
                    }
                    this.crossbowState = CrossbowState.UNCHARGED;
                } else if (this.crossbowState == CrossbowState.UNCHARGED) {
                    if (!canSee2) {
                        ((Guard)((Object)this.mob)).startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                        this.crossbowState = CrossbowState.CHARGING;
                        ((Guard)((Object)this.mob)).setChargingCrossbow(true);
                    }
                } else if (this.crossbowState == CrossbowState.CHARGING) {
                    ItemStack itemstack;
                    int i;
                    if (!this.mob.isUsingItem()) {
                        this.crossbowState = CrossbowState.UNCHARGED;
                    }
                    if ((i = this.mob.getTicksUsingItem()) >= CrossbowItem.getChargeDuration((ItemStack)(itemstack = this.mob.getUseItem()), this.mob) || CrossbowItem.isCharged((ItemStack)itemstack)) {
                        this.mob.releaseUsingItem();
                        this.crossbowState = CrossbowState.CHARGED;
                        this.attackDelay = 10 + this.mob.getRandom().nextInt(5);
                        ((Guard)((Object)this.mob)).setChargingCrossbow(false);
                    }
                } else if (this.crossbowState == CrossbowState.CHARGED) {
                    --this.attackDelay;
                    if (this.attackDelay == 0) {
                        this.crossbowState = CrossbowState.READY_TO_ATTACK;
                    }
                } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && canSee) {
                    ((Guard)((Object)this.mob)).performRangedAttack(livingentity, 1.0f);
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
            }
        }

        public static boolean friendlyInLineOfSight(Mob mob) {
            Vec3 lookAngle = mob.getViewVector(1.0f);
            AABB aabb = mob.getBoundingBox().expandTowards(lookAngle.scale(6.0)).inflate(1.0, 1.0, 1.0);
            List list = mob.level().getEntities((Entity)mob, aabb);
            for (Entity guard : list) {
                boolean isVillager;
                if (guard == mob.getTarget() || !(isVillager = ((Guard)mob).getOwner() == guard || guard.getType() == EntityType.VILLAGER || guard.getType() == GuardEntityType.GUARD.get() || guard.getType() == EntityType.IRON_GOLEM)) continue;
                Vec3 vector3d = mob.getLookAngle();
                Vec3 vector3d1 = guard.position().vectorTo(mob.position()).normalize();
                vector3d1 = new Vec3(vector3d1.x, vector3d1.y, vector3d1.z);
                if (!(vector3d1.dot(vector3d) < 1.0) || !mob.hasLineOfSight(guard)) continue;
                return (Boolean)GuardConfig.COMMON.FriendlyFire.get();
            }
            return false;
        }

        public boolean findPosition() {
            Vec3 vector3d = this.getPosition();
            if (vector3d == null) {
                return false;
            }
            this.wantedX = vector3d.x;
            this.wantedY = vector3d.y;
            this.wantedZ = vector3d.z;
            return true;
        }

        @Nullable
        protected Vec3 getPosition() {
            if (this.isValidTarget() && this.mob.getTarget().position() != null) {
                return DefaultRandomPos.getPosAway(this.mob, (int)16, (int)7, (Vec3)this.mob.getTarget().position());
            }
            return DefaultRandomPos.getPos(this.mob, (int)16, (int)7);
        }

        private boolean canRun() {
            return this.crossbowState == CrossbowState.UNCHARGED;
        }

        public static enum CrossbowState {
            UNCHARGED,
            CHARGING,
            CHARGED,
            READY_TO_ATTACK,
            FIND_NEW_POSITION;

        }
    }

    public static class GuardBowAttack
    extends RangedBowAttackGoal<Guard> {
        protected Guard guard;

        public GuardBowAttack(Guard mob, double speedModifier, int attackIntervalMin, float attackRadius) {
            super((Mob)mob, speedModifier, attackIntervalMin, attackRadius);
            this.guard = mob;
        }

        public boolean canUse() {
            return this.guard.getTarget() != null && this.isBowInMainhand() && !this.guard.isEating() && !this.guard.isBlocking();
        }

        protected boolean isBowInMainhand() {
            return this.guard.getMainHandItem().getItem() instanceof BowItem;
        }

        public void tick() {
            super.tick();
            if (this.guard.isPatrolling()) {
                this.guard.getNavigation().stop();
                this.guard.getMoveControl().strafe(0.0f, 0.0f);
            }
            if (RangedCrossbowAttackPassiveGoal.friendlyInLineOfSight((Mob)this.guard)) {
                this.guard.stopUsingItem();
            }
        }

        public boolean canContinueToUse() {
            return (this.canUse() || !this.guard.getNavigation().isDone()) && this.isBowInMainhand();
        }
    }

    public static class GuardMeleeGoal
    extends MeleeAttackGoal {
        private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
        public final Guard guard;

        public GuardMeleeGoal(Guard guard, double speedIn, boolean useLongMemory) {
            super((PathfinderMob)guard, speedIn, useLongMemory);
            this.guard = guard;
        }

        public boolean canUse() {
            return (!(this.mob.getMainHandItem().getItem() instanceof CrossbowItem) || !(this.mob.getMainHandItem().getItem() instanceof BowItem)) && this.guard.getTarget() != null && !this.guard.isEating() && super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.guard.getTarget() != null;
        }

        public void tick() {
            LivingEntity target = this.guard.getTarget();
            if (target != null) {
                if ((double)target.distanceTo((Entity)this.guard) <= 2.5 && !this.guard.isBlocking()) {
                    this.guard.getMoveControl().strafe(-2.0f, 0.0f);
                    this.guard.lookAt((Entity)target, 30.0f, 30.0f);
                }
                if (this.path != null && (double)target.distanceTo((Entity)this.guard) <= 2.0) {
                    this.guard.getNavigation().stop();
                }
                super.tick();
            }
        }

        protected void checkAndPerformAttack(LivingEntity enemy) {
            if (this.canPerformAttack(enemy)) {
                this.resetAttackCooldown();
                this.guard.stopUsingItem();
                if (this.guard.shieldCoolDown == 0) {
                    this.guard.shieldCoolDown = 8;
                }
                this.guard.swing(InteractionHand.MAIN_HAND);
                this.guard.doHurtTarget((Entity)enemy);
            }
        }

        protected boolean canPerformAttack(LivingEntity mob) {
            return this.isTimeToAttack() && this.mobHitBox((LivingEntity)this.mob).inflate(0.65).intersects(this.mobHitBox(mob)) && this.mob.getSensing().hasLineOfSight((Entity)mob);
        }

        protected AABB mobHitBox(LivingEntity mob) {
            AABB aabb;
            Entity entity = mob.getVehicle();
            if (entity != null) {
                AABB aabb1 = entity.getBoundingBox();
                AABB aabb2 = mob.getBoundingBox();
                aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
            } else {
                aabb = mob.getBoundingBox();
            }
            return aabb.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
        }
    }

    public static class FollowHeroGoal
    extends Goal {
        private final Guard guard;
        private LivingEntity owner;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;

        public FollowHeroGoal(Guard guard, double speedModifier, float startDistance, float stopDistance) {
            this.guard = guard;
            this.speedModifier = speedModifier;
            this.navigation = guard.getNavigation();
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.guard.getOwner();
            if (livingentity == null) {
                return false;
            }
            if (this.guard.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingentity;
            return this.guard.isFollowing();
        }

        public boolean canContinueToUse() {
            if (!this.navigation.isDone()) {
                return this.guard.distanceToSqr((Entity)this.owner) >= (double)(this.stopDistance * this.stopDistance) && this.guard.isFollowing();
            }
            return false;
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.guard.getPathfindingMalus(PathType.WATER);
            this.guard.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.owner = null;
            this.navigation.stop();
            this.guard.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            boolean shouldTryTeleportToOwner = this.guard.shouldTryTeleportToOwner();
            if (!shouldTryTeleportToOwner) {
                this.guard.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.guard.getMaxHeadXRot());
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(10);
                if (shouldTryTeleportToOwner) {
                    this.guard.tryToTeleportToOwner();
                } else {
                    this.navigation.moveTo((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    public static class GuardInteractDoorGoal
    extends OpenDoorGoal {
        private final Guard guard;

        public GuardInteractDoorGoal(Guard pMob, boolean pCloseDoor) {
            super((Mob)pMob, pCloseDoor);
            this.guard = pMob;
        }

        public boolean canUse() {
            return super.canUse();
        }

        public void start() {
            if (this.areOtherMobsComingThroughDoor(this.guard)) {
                super.start();
                this.guard.swing(InteractionHand.MAIN_HAND);
            }
        }

        private boolean areOtherMobsComingThroughDoor(Guard pEntity) {
            List nearbyEntityList = pEntity.level().getEntitiesOfClass(PathfinderMob.class, pEntity.getBoundingBox().inflate(4.0));
            if (!nearbyEntityList.isEmpty()) {
                for (PathfinderMob mob : nearbyEntityList) {
                    if (!mob.blockPosition().closerToCenterThan((Position)pEntity.position(), 2.0)) continue;
                    return this.isMobComingThroughDoor(mob);
                }
            }
            return false;
        }

        private boolean isMobComingThroughDoor(PathfinderMob pEntity) {
            if (pEntity.getNavigation() == null) {
                return false;
            }
            Path path = pEntity.getNavigation().getPath();
            if (path == null || path.isDone()) {
                return false;
            }
            Node node = path.getPreviousNode();
            if (node == null) {
                return false;
            }
            Node node1 = path.getNextNode();
            return pEntity.blockPosition().equals((Object)node.asBlockPos()) || pEntity.blockPosition().equals((Object)node1.asBlockPos());
        }
    }

    public static class FollowShieldGuards
    extends Goal {
        private static final TargetingConditions NEARBY_GUARDS = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
        private final Guard taskOwner;
        private Guard guardtofollow;
        private double x;
        private double y;
        private double z;

        public FollowShieldGuards(Guard taskOwnerIn) {
            this.taskOwner = taskOwnerIn;
        }

        public boolean canUse() {
            List list = this.taskOwner.level().getEntitiesOfClass(((Object)((Object)this.taskOwner)).getClass(), this.taskOwner.getBoundingBox().inflate(8.0, 8.0, 8.0));
            if (!list.isEmpty()) {
                for (Guard guard : list) {
                    if (guard.isInvisible() || !guard.getOffhandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK) || !guard.isBlocking() || this.taskOwner.level().getNearbyEntities(Guard.class, NEARBY_GUARDS.range(3.0), (LivingEntity)guard, this.taskOwner.getBoundingBox().inflate(5.0)).size() >= 5) continue;
                    this.guardtofollow = guard;
                    Vec3 vec3d = this.getPosition();
                    if (vec3d == null) {
                        return false;
                    }
                    this.x = vec3d.x;
                    this.y = vec3d.y;
                    this.z = vec3d.z;
                    return true;
                }
            }
            return false;
        }

        @Nullable
        protected Vec3 getPosition() {
            return DefaultRandomPos.getPosTowards((PathfinderMob)this.taskOwner, (int)16, (int)7, (Vec3)this.guardtofollow.position(), (double)1.5707963705062866);
        }

        public boolean canContinueToUse() {
            return !this.taskOwner.getNavigation().isDone() && !this.taskOwner.isVehicle();
        }

        public void stop() {
            this.taskOwner.getNavigation().stop();
            super.stop();
        }

        public void start() {
            this.taskOwner.getNavigation().moveTo(this.x, this.y, this.z, 0.4);
        }
    }

    public static class RunToClericGoal
    extends Goal {
        public final Guard guard;
        public Villager cleric;

        public RunToClericGoal(Guard guard) {
            this.guard = guard;
        }

        public boolean canUse() {
            List list = this.guard.level().getEntitiesOfClass(Villager.class, this.guard.getBoundingBox().inflate(10.0, 3.0, 10.0));
            if (!list.isEmpty()) {
                for (Villager mob : list) {
                    if (mob == null || mob.getVillagerData().getProfession() != VillagerProfession.CLERIC || !(this.guard.getHealth() < this.guard.getMaxHealth()) || this.guard.getTarget() != null || this.guard.hasEffect(MobEffects.REGENERATION) || mob.isSleeping()) continue;
                    this.cleric = mob;
                    return (Boolean)GuardConfig.COMMON.ClericHealing.get();
                }
            }
            return false;
        }

        public void tick() {
            this.guard.lookAt((Entity)this.cleric, 30.0f, 30.0f);
            this.guard.getLookControl().setLookAt((Entity)this.cleric, 30.0f, 30.0f);
            if ((double)this.guard.distanceTo((Entity)this.cleric) >= 6.0) {
                this.guard.getNavigation().moveTo((Entity)this.cleric, 0.5);
            } else {
                this.guard.getMoveControl().strafe(-1.0f, 0.0f);
                this.guard.getNavigation().stop();
            }
        }
    }

    public static class WalkBackToCheckPointGoal
    extends Goal {
        private final Guard guard;
        private final double speed;

        public WalkBackToCheckPointGoal(Guard guard, double speedIn) {
            this.guard = guard;
            this.speed = speedIn;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.guard.getPatrolPos() != null && this.guard.blockPosition() != this.guard.getPatrolPos() && !this.guard.isFollowing() && this.guard.isPatrolling();
        }

        public boolean canContinueToUse() {
            return this.canUse() && this.guard.getNavigation().isInProgress();
        }

        public void start() {
            BlockPos blockpos = this.guard.getPatrolPos();
            if (blockpos != null) {
                Vec3 vector3d = Vec3.atCenterOf((Vec3i)blockpos);
                this.guard.getNavigation().moveTo(vector3d.x, vector3d.y, vector3d.z, this.speed);
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    public static class GuardLookAtAndStopMovingWhenBeingTheInteractionTarget
    extends Goal {
        private final Guard guard;
        private Villager villager;

        public GuardLookAtAndStopMovingWhenBeingTheInteractionTarget(Guard guard) {
            this.guard = guard;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            List list = this.guard.level().getEntitiesOfClass(Villager.class, this.guard.getBoundingBox().inflate(10.0));
            if (!list.isEmpty()) {
                for (Villager villager : list) {
                    if (!villager.getBrain().hasMemoryValue(MemoryModuleType.INTERACTION_TARGET) || !((LivingEntity)villager.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get()).is((Entity)this.guard)) continue;
                    this.villager = villager;
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            super.tick();
            this.guard.getNavigation().stop();
            this.guard.lookAt((Entity)this.villager, 30.0f, 30.0f);
            this.guard.getLookControl().setLookAt((Entity)this.villager);
        }
    }

    public static class HeroHurtByTargetGoal
    extends TargetGoal {
        private final Guard guard;
        private LivingEntity attacker;
        private int timestamp;

        public HeroHurtByTargetGoal(Guard guard) {
            super((Mob)guard, false);
            this.guard = guard;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.guard.getOwner();
            if (livingentity == null) {
                return false;
            }
            this.attacker = livingentity.getLastHurtByMob();
            int i = livingentity.getLastHurtByMobTimestamp();
            return i != this.timestamp && this.canAttack(this.attacker, TargetingConditions.DEFAULT);
        }

        protected boolean canAttack(@Nullable LivingEntity potentialTarget, TargetingConditions targetPredicate) {
            return super.canAttack(potentialTarget, targetPredicate) && !(potentialTarget instanceof IronGolem) && !(potentialTarget instanceof Guard);
        }

        public void start() {
            this.mob.setTarget(this.attacker);
            LivingEntity livingentity = this.guard.getOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.getLastHurtByMobTimestamp();
            }
            super.start();
        }
    }

    public static class HeroHurtTargetGoal
    extends TargetGoal {
        private final Guard guard;
        private LivingEntity attacker;
        private int timestamp;

        public HeroHurtTargetGoal(Guard theEntityTameableIn) {
            super((Mob)theEntityTameableIn, false);
            this.guard = theEntityTameableIn;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.guard.getOwner();
            if (livingentity == null) {
                return false;
            }
            this.attacker = livingentity.getLastHurtMob();
            int i = livingentity.getLastHurtMobTimestamp();
            return i != this.timestamp && this.canAttack(this.attacker, TargetingConditions.DEFAULT);
        }

        protected boolean canAttack(@Nullable LivingEntity potentialTarget, TargetingConditions targetPredicate) {
            return super.canAttack(potentialTarget, targetPredicate) && !(potentialTarget instanceof AbstractVillager) && !(potentialTarget instanceof Guard);
        }

        public void start() {
            this.mob.setTarget(this.attacker);
            LivingEntity livingentity = this.guard.getOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.getLastHurtMobTimestamp();
            }
            super.start();
        }
    }

    public static class DefendVillageGuardGoal
    extends TargetGoal {
        private final Guard guard;
        private LivingEntity villageAggressorTarget;

        public DefendVillageGuardGoal(Guard guardIn) {
            super((Mob)guardIn, true, true);
            this.guard = guardIn;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            AABB axisalignedbb = this.guard.getBoundingBox().inflate(10.0, 8.0, 10.0);
            List list = this.guard.level().getEntitiesOfClass(Villager.class, axisalignedbb);
            List list1 = this.guard.level().getEntitiesOfClass(Player.class, axisalignedbb);
            for (Villager villager : list) {
                for (Player player : list1) {
                    int i = villager.getPlayerReputation(player);
                    if (i > (Integer)GuardConfig.COMMON.reputationRequirementToBeAttacked.get()) continue;
                    this.villageAggressorTarget = player;
                    if (this.villageAggressorTarget.getTeam() == null || this.guard.getTeam() == null || !this.guard.getTeam().isAlliedTo((Team)this.villageAggressorTarget.getTeam())) continue;
                    return false;
                }
            }
            return this.villageAggressorTarget != null && !this.villageAggressorTarget.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && !this.villageAggressorTarget.isSpectator() && !((Player)this.villageAggressorTarget).isCreative();
        }

        public void start() {
            this.guard.setTarget(this.villageAggressorTarget);
            super.start();
        }
    }
}

