/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.configuration;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GuardConfig {
    public static final ModConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    public static final ModConfigSpec STARTUP_SPEC;
    public static final StartUpConfig STARTUP;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        Pair specPair1 = new ModConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)specPair1.getLeft();
        CLIENT_SPEC = (ModConfigSpec)specPair1.getRight();
        Pair specPair2 = new ModConfigSpec.Builder().configure(StartUpConfig::new);
        STARTUP = (StartUpConfig)specPair2.getLeft();
        STARTUP_SPEC = (ModConfigSpec)specPair2.getRight();
    }

    public static class CommonConfig {
        public final ModConfigSpec.BooleanValue RaidAnimals;
        public final ModConfigSpec.BooleanValue WitchesVillager;
        public final ModConfigSpec.BooleanValue AttackAllMobs;
        public final ModConfigSpec.BooleanValue MobsAttackGuards;
        public final ModConfigSpec.BooleanValue VillagersRunFromPolarBears;
        public final ModConfigSpec.BooleanValue IllagersRunFromPolarBears;
        public final ModConfigSpec.BooleanValue GuardsRunFromPolarBears;
        public final ModConfigSpec.BooleanValue GuardsOpenDoors;
        public final ModConfigSpec.BooleanValue GuardRaiseShield;
        public final ModConfigSpec.BooleanValue GuardFormation;
        public final ModConfigSpec.BooleanValue FriendlyFire;
        public final ModConfigSpec.BooleanValue ConvertVillagerIfHaveHOTV;
        public final ModConfigSpec.BooleanValue guardTeleport;
        public final ModConfigSpec.BooleanValue BlacksmithHealing;
        public final ModConfigSpec.BooleanValue ClericHealing;
        public final ModConfigSpec.DoubleValue GuardVillagerHelpRange;
        public final ModConfigSpec.DoubleValue amountOfHealthRegenerated;
        public final ModConfigSpec.BooleanValue guardArrowsHurtVillagers;
        public final ModConfigSpec.BooleanValue armorersRepairGuardArmor;
        public final ModConfigSpec.ConfigValue<List<? extends String>> MobBlackList;
        public final ModConfigSpec.ConfigValue<List<? extends String>> MobWhiteList;
        public final ModConfigSpec.BooleanValue giveGuardStuffHOTV;
        public final ModConfigSpec.BooleanValue setGuardPatrolHotv;
        public final ModConfigSpec.BooleanValue followHero;
        public final ModConfigSpec.BooleanValue golemFloat;
        public final ModConfigSpec.BooleanValue multiFollow;
        public final ModConfigSpec.BooleanValue guardPatrolVillageAi;
        public final ModConfigSpec.IntValue reputationRequirement;
        public final ModConfigSpec.IntValue reputationRequirementToBeAttacked;
        public final ModConfigSpec.DoubleValue chanceToDropEquipment;

        public CommonConfig(ModConfigSpec.Builder builder) {
            builder.push("raids and illagers");
            this.RaidAnimals = builder.comment("Illagers In Raids Attack Animals?").translation("guardvillagers.config.RaidAnimals").define("Illagers in raids attack animals?", true);
            this.WitchesVillager = builder.comment("Witches Attack Villagers?").translation("guardvillagers.config.WitchesVillager").define("Witches attack villagers?", true);
            this.IllagersRunFromPolarBears = builder.comment("This makes Illagers run from polar bears, as anyone with common sense would.").translation("guardvillagers.config.IllagersRunFromPolarBears").define("Have Illagers have some common sense?", true);
            builder.pop();
            builder.push("mob ai in general");
            this.AttackAllMobs = builder.comment("Guards will attack all hostiles with this option, when set to false guards will only attack zombies and illagers.").translation("guardvillagers.config.AttackAllMobs").define("Guards attack all mobs?", true);
            this.MobsAttackGuards = builder.comment("Hostiles attack guards, by default only illagers and zombies will attack guards, the mob blacklist below will effect this option").define("All mobs attack guards", false);
            this.MobBlackList = builder.comment("Guards won't attack mobs in this list at all, for example, putting \"minecraft:creeper\" in this list will make guards ignore creepers.").defineListAllowEmpty("Mob Blacklist", (List)ImmutableList.of((Object)"minecraft:villager", (Object)"minecraft:iron_golem", (Object)"minecraft:wandering_trader", (Object)"guardvillagers:guard", (Object)"minecraft:creeper", (Object)"minecraft:enderman"), () -> "", obj -> true);
            this.MobWhiteList = builder.comment("Guards will additionally attack mobs ids put in this list, for example, putting \"minecraft:cow\" in this list will make guards attack cows.").defineListAllowEmpty("Mob Whitelist", new ArrayList(), () -> "", obj -> true);
            builder.pop();
            builder.push("villager stuff");
            this.armorersRepairGuardArmor = builder.translation("guardvillagers.config.armorvillager").define("Allow armorers and weaponsmiths repair guard items when down below half durability?", true);
            this.ConvertVillagerIfHaveHOTV = builder.comment("This will make it so villagers will only be converted into guards if the player has hero of the village").translation("guardvillagers.config.hotv").define("Make it so players have to have hero of the village to convert villagers into guards?", false);
            this.BlacksmithHealing = builder.translation("guardvillagers.config.blacksmith").define("Have it so blacksmiths heal golems under 60 health?", true);
            this.ClericHealing = builder.translation("guardvillagers.config.cleric").define("Have it so clerics heal guards and players with hero of the village?", true);
            this.VillagersRunFromPolarBears = builder.comment("This makes villagers run from polar bears, as anyone with common sense would.").translation("guardvillagers.config.VillagersRunFromPolarBears").define("Have Villagers have some common sense?", true);
            builder.pop();
            builder.push("golem stuff");
            this.golemFloat = builder.define("Allow Iron Golems to float on water?", true);
            builder.pop();
            builder.push("guard stuff");
            this.multiFollow = builder.translation("guardvillagers.config.multifollow").define("Allow the player to right click on bells to mass order guards to follow them?", true);
            this.chanceToDropEquipment = builder.defineInRange("Chance to drop equipment", 100.0, (double)-999.9f, 999.0);
            this.GuardsRunFromPolarBears = builder.comment("This makes Guards run from polar bears, as anyone with common sense would.").translation("guardvillagers.config.IllagersRunFromPolarBears").define("Have Guards have some common sense?", false);
            this.GuardsOpenDoors = builder.comment("This lets Guards open doors.").translation("guardvillagers.config.GuardsOpenDoors").define("Have Guards open doors?", true);
            this.GuardRaiseShield = builder.comment("This will make guards raise their shields all the time, on default they will only raise their shields under certain conditions").translation("guardvillagers.config.GuardRaiseShield").define("Have Guards raise their shield all the time?", false);
            this.guardTeleport = builder.define("Allow guards to teleport if following the player", true);
            this.GuardFormation = builder.comment("This makes guards form a phalanx").translation("guardvillagers.config.GuardFormation").define("Have guards form a phalanx?", true);
            this.FriendlyFire = builder.translation("guardvillagers.config.FriendlyFire").define("Have guards attempt to avoid firing into other friendlies?", true);
            this.GuardVillagerHelpRange = builder.translation("guardvillagers.config.range").comment("This is the range in which the guards will be aggroed to mobs that are attacking villagers. Higher values are more resource intensive, and setting this to zero will disable the goal.").defineInRange("Range", 50.0, -500.0, 500.0);
            this.amountOfHealthRegenerated = builder.translation("guardvillagers.config.amountofHealthRegenerated").comment("How much health a guard regenerates.").defineInRange("Guard health regeneration amount", 1.0, -500.0, 500.0);
            this.guardArrowsHurtVillagers = builder.translation("guardvillagers.config.guardArrows").define("Allow guard arrows to damage villagers, iron golems, or other guards? The i-frames will still be shown for them but they won't lose any health if this is set to false", true);
            this.giveGuardStuffHOTV = builder.translation("guardvillagers.config.hotvArmor").define("Allow players to give guards stuff only if they have the hero of the village effect?", false);
            this.setGuardPatrolHotv = builder.translation("guardvillagers.config.hotvPatrolPoint").define("Allow players to set guard patrol points only if they have hero of the village", false);
            this.reputationRequirement = builder.defineInRange("Minimum reputation requirement for guards to give you access to their inventories", 15, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.followHero = builder.define("Have guards only follow the player if they have hero of the village?", true);
            this.reputationRequirementToBeAttacked = builder.defineInRange("How low of a reputation of a player should have to be instantly aggroed upon by guards and golems?", -100, -9999, 9999);
            this.guardPatrolVillageAi = builder.define("Allow guards to naturally patrol villages? This feature can cause lag if a lot of guards are spawned", false);
            builder.pop();
        }
    }

    public static class ClientConfig {
        public final ModConfigSpec.BooleanValue GuardSteve;
        public final ModConfigSpec.BooleanValue bigHeadBabyVillager;

        public ClientConfig(ModConfigSpec.Builder builder) {
            this.GuardSteve = builder.comment("Textures not included, make your own textures by making a resource pack that adds guard_steve_0 - 6").translation("guardvillagers.config.steveModel").define("Have guards use the steve model?", false);
            this.bigHeadBabyVillager = builder.define("Have baby villagers have big heads like in bedrock?", true);
        }
    }

    public static class StartUpConfig {
        public final ModConfigSpec.DoubleValue healthModifier;
        public final ModConfigSpec.DoubleValue speedModifier;
        public final ModConfigSpec.DoubleValue followRangeModifier;

        public StartUpConfig(ModConfigSpec.Builder builder) {
            this.healthModifier = builder.defineInRange("Guard health", 20.0, -500.0, 900.0);
            this.speedModifier = builder.defineInRange("Guard speed", 0.5, -500.0, 900.0);
            this.followRangeModifier = builder.defineInRange("Guard follow range", 20.0, 0.0, 900.0);
        }
    }
}

