/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.NativeJavaMap;
import dev.latvian.mods.rhino.type.TypeInfo;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.CustomData;

public interface DataComponentWrapper {
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(object -> Component.translatableEscape((String)"arguments.item.component.unknown", (Object[])new Object[]{object}));
    public static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((object, object2) -> Component.translatableEscape((String)"arguments.item.component.malformed", (Object[])new Object[]{object, object2}));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_COMPONENT = new SimpleCommandExceptionType((Message)Component.translatable((String)"arguments.item.component.expected"));
    public static final Lazy<Map<DataComponentType<?>, TypeInfo>> TYPE_INFOS = Lazy.of(() -> {
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        try {
            for (Field field : DataComponents.class.getDeclaredFields()) {
                Type patt0$temp;
                if (field.getType() != DataComponentType.class || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !((patt0$temp = field.getGenericType()) instanceof ParameterizedType)) continue;
                ParameterizedType t = (ParameterizedType)patt0$temp;
                DataComponentType key = (DataComponentType)field.get(null);
                TypeInfo typeInfo = TypeInfo.of((Type)t.getActualTypeArguments()[0]);
                map.put((Object)key, (Object)typeInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        KubeJSPlugins.forEachPlugin((arg_0, arg_1) -> ((Reference2ObjectOpenHashMap)map).put(arg_0, arg_1), KubeJSPlugin::registerDataComponentTypeDescriptions);
        return Map.copyOf(map);
    });

    public static TypeInfo getTypeInfo(DataComponentType<?> type) {
        return TYPE_INFOS.get().getOrDefault(type, TypeInfo.NONE);
    }

    public static DataComponentType<?> wrapType(Object object) {
        if (object instanceof DataComponentType) {
            return (DataComponentType)object;
        }
        return (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ID.mc(object));
    }

    public static DataComponentMap readMap(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        DataComponentMap.Builder builder = null;
        if (reader.canRead() && reader.peek() == '[') {
            reader.skip();
            while (reader.canRead() && reader.peek() != ']') {
                reader.skipWhitespace();
                DataComponentType<?> dataComponentType = DataComponentWrapper.readComponentType(reader);
                reader.skipWhitespace();
                reader.expect('=');
                reader.skipWhitespace();
                int i = reader.getCursor();
                DataResult dataResult = dataComponentType.codecOrThrow().parse(registryOps, (Object)new TagParser(reader).readValue());
                if (builder == null) {
                    builder = DataComponentMap.builder();
                }
                builder.set(dataComponentType, Cast.to(dataResult.getOrThrow(string -> {
                    reader.setCursor(i);
                    return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)reader, (Object)dataComponentType.toString(), string);
                })));
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != ',') break;
                reader.skip();
                reader.skipWhitespace();
                if (reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)reader);
            }
            reader.expect(']');
        }
        if (reader.canRead() && reader.peek() == '{') {
            CompoundTag tag = new TagParser(reader).readStruct();
            if (builder == null) {
                builder = DataComponentMap.builder();
            }
            builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return builder == null ? DataComponentMap.EMPTY : builder.build();
    }

    public static DataComponentPatch readPatch(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        DataComponentPatch.Builder builder = null;
        if (reader.canRead() && reader.peek() == '[') {
            reader.skip();
            while (reader.canRead() && reader.peek() != ']') {
                boolean remove;
                reader.skipWhitespace();
                boolean bl = remove = reader.canRead() && reader.peek() == '!';
                if (remove) {
                    reader.skipWhitespace();
                }
                DataComponentType<?> dataComponentType = DataComponentWrapper.readComponentType(reader);
                if (remove) {
                    reader.skipWhitespace();
                    if (reader.canRead() && reader.peek() != ']') {
                        reader.expect(',');
                        reader.skipWhitespace();
                    }
                    if (builder == null) {
                        builder = DataComponentPatch.builder();
                    }
                    builder.remove(dataComponentType);
                    continue;
                }
                reader.skipWhitespace();
                reader.expect('=');
                reader.skipWhitespace();
                int i = reader.getCursor();
                DataResult dataResult = dataComponentType.codecOrThrow().parse(registryOps, (Object)new TagParser(reader).readValue());
                if (builder == null) {
                    builder = DataComponentPatch.builder();
                }
                builder.set(dataComponentType, Cast.to(dataResult.getOrThrow(string -> {
                    reader.setCursor(i);
                    return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)reader, (Object)dataComponentType.toString(), string);
                })));
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != ',') break;
                reader.skip();
                reader.skipWhitespace();
                if (reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)reader);
            }
            reader.expect(']');
        }
        if (reader.canRead() && reader.peek() == '{') {
            CompoundTag tag = new TagParser(reader).readStruct();
            if (builder == null) {
                builder = DataComponentPatch.builder();
            }
            builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return builder == null ? DataComponentPatch.EMPTY : builder.build();
    }

    public static DataComponentType<?> readComponentType(StringReader stringReader) throws CommandSyntaxException {
        if (!stringReader.canRead()) {
            throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)stringReader);
        }
        int i = stringReader.getCursor();
        ResourceLocation resourceLocation = ResourceLocation.read((StringReader)stringReader);
        DataComponentType dataComponentType = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(resourceLocation);
        if (dataComponentType != null && !dataComponentType.isTransient()) {
            return dataComponentType;
        }
        stringReader.setCursor(i);
        throw ERROR_UNKNOWN_COMPONENT.createWithContext((ImmutableStringReader)stringReader, (Object)resourceLocation);
    }

    public static DataComponentPredicate readPredicate(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        DataComponentMap map = reader.canRead() ? DataComponentWrapper.readMap(registryOps, reader) : DataComponentMap.EMPTY;
        return map.isEmpty() ? DataComponentPredicate.EMPTY : DataComponentPredicate.allOf((DataComponentMap)map);
    }

    public static boolean filter(Object from, TypeInfo target) {
        String s;
        return from == null || from instanceof DataComponentMap || from instanceof DataComponentPatch || from instanceof Map || from instanceof NativeJavaMap || from instanceof String && ((s = (String)from).isEmpty() || s.charAt(0) == '[');
    }

    public static DataComponentMap mapOf(RegistryAccessContainer registries, Object o) {
        try {
            return DataComponentWrapper.readMap(registries.nbt(), new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException("Error parsing DataComponentMap from " + String.valueOf(o), ex);
        }
    }

    public static DataComponentPatch patchOf(RegistryAccessContainer registries, Object o) {
        try {
            return DataComponentWrapper.readPatch(registries.nbt(), new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException("Error parsing DataComponentPatch from " + String.valueOf(o), ex);
        }
    }

    public static StringBuilder mapToString(StringBuilder builder, DynamicOps<Tag> dynamicOps, DataComponentMap map) {
        builder.append('[');
        boolean first = true;
        for (TypedDataComponent comp : map) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            ResourceLocation id = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)comp.type());
            Optional optional = comp.encodeValue(dynamicOps).result();
            if (id == null || optional.isEmpty()) continue;
            builder.append(id.getNamespace().equals("minecraft") ? id.getPath() : id.toString()).append('=').append(optional.get());
        }
        builder.append(']');
        return builder;
    }

    public static StringBuilder patchToString(StringBuilder builder, DynamicOps<Tag> dynamicOps, DataComponentPatch patch) {
        builder.append('[');
        boolean first = true;
        for (Map.Entry comp : patch.entrySet()) {
            ResourceLocation id;
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            if ((id = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)comp.getKey()))) == null) continue;
            if (((Optional)comp.getValue()).isPresent()) {
                Tag value = (Tag)((DataComponentType)comp.getKey()).codecOrThrow().encodeStart(dynamicOps, Cast.to(((Optional)comp.getValue()).get())).result().get();
                builder.append(id.getNamespace().equals("minecraft") ? id.getPath() : id.toString()).append('=').append(value);
                continue;
            }
            builder.append('!').append(id.getNamespace().equals("minecraft") ? id.getPath() : id.toString());
        }
        builder.append(']');
        return builder;
    }
}

