/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.mods.kubejs.bindings.IngredientWrapper;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

@Info(value="Various SizedIngredient related helper methods")
public interface SizedIngredientWrapper {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(SizedIngredient.class);
    @Info(value="A completely empty ingredient that will only match air")
    public static final SizedIngredient empty = new SizedIngredient(Ingredient.EMPTY, 1);
    @Info(value="An ingredient that matches everything")
    public static final SizedIngredient all = new SizedIngredient(IngredientWrapper.all, 1);

    @Info(value="Returns a sized ingredient of the input")
    public static SizedIngredient of(SizedIngredient ingredient) {
        return ingredient;
    }

    @Info(value="Returns a sized ingredient of the input")
    public static SizedIngredient of(Ingredient ingredient, int count) {
        return new SizedIngredient(ingredient, count);
    }

    public static SizedIngredient ofTag(TagKey<Item> tag, int count) {
        return SizedIngredient.of(tag, (int)count);
    }

    public static SizedIngredient wrap(RegistryAccessContainer registries, Object from) {
        if (from instanceof SizedIngredient) {
            SizedIngredient s = (SizedIngredient)from;
            return s;
        }
        if (from instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)from;
            return ingredient.kjs$asStack();
        }
        if (from instanceof ItemStack) {
            ItemStack stack = (ItemStack)from;
            return Ingredient.of((ItemStack[])new ItemStack[]{stack.kjs$withCount(1)}).kjs$withCount(stack.getCount());
        }
        if (from instanceof ItemLike) {
            ItemLike item = (ItemLike)from;
            return Ingredient.of((ItemLike[])new ItemLike[]{item}).kjs$asStack();
        }
        if (from instanceof CharSequence) {
            try {
                return SizedIngredientWrapper.read(registries, new StringReader(from.toString()));
            }
            catch (Exception ex) {
                return empty;
            }
        }
        return IngredientJS.wrap(registries, from).kjs$asStack();
    }

    public static SizedIngredient read(RegistryAccessContainer registries, StringReader reader) throws CommandSyntaxException {
        int count = 1;
        if (StringReader.isAllowedNumber((char)reader.peek())) {
            count = Mth.ceil((double)reader.readDouble());
            reader.skipWhitespace();
            reader.expect('x');
            reader.skipWhitespace();
            if (count < 1) {
                throw new IllegalArgumentException("SizedIngredient count smaller than 1 is not allowed!");
            }
        }
        return IngredientJS.read(registries, reader).kjs$withCount(count);
    }
}

