/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.latvian.mods.kubejs.bindings.event.BlockEvents;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.DetectorBlockKubeEvent;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DetectorBlock
extends Block {
    private final Builder builder;

    public DetectorBlock(Builder b) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK));
        this.builder = b;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Deprecated
    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        boolean p;
        boolean bl2 = p = (Boolean)blockState.getValue((Property)BlockStateProperties.POWERED) == false;
        if (p == level.hasNeighborSignal(blockPos)) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(p)), 2);
            if (BlockEvents.DETECTOR_CHANGED.hasListeners(this.builder.detectorId) || (p ? BlockEvents.DETECTOR_POWERED : BlockEvents.DETECTOR_UNPOWERED).hasListeners(this.builder.detectorId)) {
                DetectorBlockKubeEvent e = new DetectorBlockKubeEvent(this.builder.detectorId, level, blockPos, p);
                BlockEvents.DETECTOR_CHANGED.post((ScriptTypeHolder)level, this.builder.detectorId, e);
                if (p) {
                    BlockEvents.DETECTOR_POWERED.post((ScriptTypeHolder)level, this.builder.detectorId, e);
                } else {
                    BlockEvents.DETECTOR_UNPOWERED.post((ScriptTypeHolder)level, this.builder.detectorId, e);
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }

    @ReturnsSelf
    public static class Builder
    extends BlockBuilder {
        public transient String detectorId;

        public Builder(ResourceLocation i) {
            super(i);
            this.detectorId = (String)(this.id.getNamespace().equals("kubejs") ? "" : this.id.getNamespace() + ".") + this.id.getPath().replace('/', '.');
            if (this.detectorId.endsWith("_detector")) {
                this.detectorId = this.detectorId.substring(0, this.detectorId.length() - 9);
            }
            if (this.detectorId.startsWith("detector_")) {
                this.detectorId = this.detectorId.substring(9);
            }
            this.displayName((Component)Component.literal((String)("KubeJS Detector [" + this.detectorId + "]")));
        }

        public Builder detectorId(String id) {
            this.detectorId = id;
            this.displayName((Component)Component.literal((String)("KubeJS Detector [" + this.detectorId + "]")));
            return this;
        }

        @Override
        public Block createObject() {
            return new DetectorBlock(this);
        }

        @Override
        public void generateAssets(KubeAssetGenerator generator) {
            generator.blockState(this.id, bs -> {
                bs.simpleVariant("powered=false", "kubejs:block/detector");
                bs.simpleVariant("powered=true", "kubejs:block/detector_on");
            });
            generator.itemModel(this.id, m -> m.parent("kubejs:block/detector"));
        }
    }
}

