/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.block.BlockItemBuilder;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.common.SpecialPlantable;
import org.jetbrains.annotations.Nullable;

public class SeedItemBuilder
extends BlockItemBuilder {
    public SeedItemBuilder(ResourceLocation i) {
        super(i);
    }

    @Override
    public String getTranslationKeyGroup() {
        return "item";
    }

    @Override
    public Item createObject() {
        return new SeedItemJS(this);
    }

    @Override
    public void generateAssets(KubeAssetGenerator generator) {
        if (this.modelJson != null) {
            generator.json(KubeAssetGenerator.asItemModelLocation(this.id), (JsonElement)this.modelJson);
            return;
        }
        generator.itemModel(this.id, m -> {
            if (!this.parentModel.isEmpty()) {
                m.parent(this.parentModel);
            } else {
                m.parent("minecraft:item/generated");
            }
            if (this.textureJson.size() == 0) {
                this.texture(this.newID("item/", "").toString());
            }
            m.textures(this.textureJson);
        });
    }

    public static class SeedItemJS
    extends Item
    implements SpecialPlantable {
        public SeedItemJS(SeedItemBuilder b) {
            super(b.createItemProperties());
        }

        public boolean canPlacePlantAtPosition(ItemStack stack, LevelReader level, BlockPos pos, @Nullable Direction direction) {
            return false;
        }

        public void spawnPlantAtPosition(ItemStack stack, LevelAccessor level, BlockPos pos, @Nullable Direction direction) {
        }

        public boolean villagerCanPlantItem(Villager villager) {
            return false;
        }
    }
}

