/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import dev.latvian.mods.kubejs.block.custom.ShapedBlockBuilder;
import dev.latvian.mods.kubejs.client.ModelGenerator;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.properties.BlockSetType;

@ReturnsSelf
public class PressurePlateBlockBuilder
extends ShapedBlockBuilder {
    public static final ResourceLocation[] PRESSURE_PLATE_TAGS = new ResourceLocation[]{BlockTags.PRESSURE_PLATES.location()};
    public transient BlockSetType behaviour;

    public PressurePlateBlockBuilder(ResourceLocation i) {
        super(i, "_pressure_plate");
        this.noCollision();
        this.tagBoth(PRESSURE_PLATE_TAGS);
        this.behaviour = BlockSetType.OAK;
    }

    public PressurePlateBlockBuilder behaviour(BlockSetType wt) {
        this.behaviour = wt;
        return this;
    }

    public PressurePlateBlockBuilder behaviour(String wt) {
        for (BlockSetType type : BlockSetType.values().toList()) {
            if (!type.name().equals(wt)) continue;
            this.behaviour = type;
            return this;
        }
        return this;
    }

    @Override
    public Block createObject() {
        return new PressurePlateBlock(this.behaviour, this.createProperties());
    }

    @Override
    protected void generateBlockStateJson(VariantBlockStateGenerator bs) {
        bs.variant("powered=true", v -> v.model(this.newID("block/", "_down").toString()));
        bs.variant("powered=false", v -> v.model(this.newID("block/", "_up").toString()));
    }

    @Override
    protected void generateBlockModelJsons(KubeAssetGenerator generator) {
        String texture = this.textures.get("texture").getAsString();
        generator.blockModel(this.newID("", "_down"), m -> {
            m.parent("minecraft:block/pressure_plate_down");
            m.texture("texture", texture);
        });
        generator.blockModel(this.newID("", "_up"), m -> {
            m.parent("minecraft:block/pressure_plate_up");
            m.texture("texture", texture);
        });
    }

    @Override
    protected void generateItemModelJson(ModelGenerator m) {
        m.parent(this.newID("block/", "_up").toString());
    }
}

