/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.entity;

import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachmentHolder;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachmentType;
import dev.latvian.mods.kubejs.block.entity.BlockEntityEventCallback;
import dev.latvian.mods.kubejs.block.entity.KubeBlockEntity;
import dev.latvian.mods.kubejs.core.ServerPlayerKJS;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityInfo {
    public final transient BlockBuilder blockBuilder;
    public transient BlockEntityType<?> entityType;
    public transient CompoundTag initialData;
    public transient boolean serverTicking;
    public transient boolean clientTicking;
    public transient int tickFrequency;
    public transient int tickOffset;
    public transient boolean sync;
    public transient List<BlockEntityAttachmentHolder> attachments;
    public transient Int2ObjectMap<BlockEntityEventCallback> eventHandlers;

    public BlockEntityInfo(BlockBuilder blockBuilder) {
        this.blockBuilder = blockBuilder;
        this.initialData = new CompoundTag();
        this.serverTicking = false;
        this.clientTicking = false;
        this.tickFrequency = 1;
        this.tickOffset = 0;
        this.sync = false;
        this.attachments = new ArrayList<BlockEntityAttachmentHolder>(1);
        this.eventHandlers = new Int2ObjectArrayMap(0);
    }

    public void initialData(CompoundTag data) {
        this.initialData = data;
    }

    public void serverTicking() {
        this.serverTicking = true;
    }

    public void clientTicking() {
        this.clientTicking = true;
    }

    public void ticking() {
        this.serverTicking();
        this.clientTicking();
    }

    public void tickFrequency(int frequency) {
        this.tickFrequency = Math.max(1, frequency);
    }

    public void tickOffset(int offset) {
        this.tickOffset = Math.max(0, offset);
    }

    public void enableSync() {
        this.sync = true;
    }

    public void attach(Context cx, String type, Map<String, Object> args) {
        BlockEntityAttachmentType att = BlockEntityAttachmentType.ALL.get().get(type);
        if (att != null) {
            try {
                this.attachments.add(new BlockEntityAttachmentHolder(this.attachments.size(), att.factory().createFactory(cx, args)));
            }
            catch (Exception ex) {
                ConsoleJS.STARTUP.error("Error while creating BlockEntity attachment '" + type + "'", ex);
            }
        } else {
            ConsoleJS.STARTUP.error("BlockEntity attachment '" + type + "' not found!");
        }
    }

    public void inventory(Context cx, int width, int height) {
        this.attach(cx, "inventory", Map.of("width", width, "height", height));
    }

    public void inventory(Context cx, int width, int height, ItemPredicate inputFilter) {
        this.attach(cx, "inventory", Map.of("width", width, "height", height, "inputFilter", inputFilter));
    }

    public void eventHandler(int eventId, BlockEntityEventCallback callback) {
        this.eventHandlers.put(eventId, (Object)callback);
    }

    public void rightClickOpensInventory() {
        this.blockBuilder.rightClick = e -> {
            BlockEntity patt0$temp = e.getBlock().getEntity();
            if (patt0$temp instanceof KubeBlockEntity) {
                KubeBlockEntity entity = (KubeBlockEntity)patt0$temp;
                if (entity.inventory != null) {
                    ((ServerPlayerKJS)e.getPlayer()).kjs$openInventoryGUI(entity.inventory, (Component)((Block)this.blockBuilder.get()).getName());
                }
            }
        };
    }

    @HideFromJS
    public BlockEntity createBlockEntity(BlockPos pos, BlockState state) {
        return new KubeBlockEntity(pos, state, this);
    }

    @HideFromJS
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level) {
        if (level.isClientSide()) {
            return this.clientTicking ? KubeBlockEntity.TICKER : null;
        }
        return this.serverTicking ? KubeBlockEntity.TICKER : null;
    }

    public String toString() {
        return "BlockEntityInfo[" + String.valueOf(this.blockBuilder.id) + "]";
    }
}

