/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSCommon;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.bindings.event.NetworkEvents;
import dev.latvian.mods.kubejs.client.ClientProperties;
import dev.latvian.mods.kubejs.client.KubeJSErrorScreen;
import dev.latvian.mods.kubejs.client.KubeSessionData;
import dev.latvian.mods.kubejs.item.ModifyItemTooltipsKubeEvent;
import dev.latvian.mods.kubejs.kubedex.KubedexHighlight;
import dev.latvian.mods.kubejs.net.KubeServerData;
import dev.latvian.mods.kubejs.net.NetworkKubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleLine;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.ExportablePackResources;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import dev.latvian.mods.kubejs.script.data.GeneratedDataStage;
import dev.latvian.mods.kubejs.script.data.VirtualAssetPack;
import dev.latvian.mods.kubejs.text.tooltip.ItemTooltipData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import org.jetbrains.annotations.Nullable;

public class KubeJSClient
extends KubeJSCommon {
    public static final ResourceLocation WHITE_TEXTURE = ResourceLocation.parse((String)"textures/misc/white.png");
    public static final ResourceLocation RECIPE_BUTTON_TEXTURE = ResourceLocation.parse((String)"textures/gui/recipe_button.png");
    public static final Map<GeneratedDataStage, VirtualAssetPack> CLIENT_PACKS = new EnumMap<GeneratedDataStage, VirtualAssetPack>(GeneratedDataStage.class);
    public static List<ItemTooltipData> clientItemTooltips = List.of();
    private static final char[] POWER;

    @Override
    public void reloadClientInternal() {
        KubeJSClient.reloadClientScripts();
    }

    public static void reloadClientScripts() {
        KubeJS.getClientScriptManager().reload();
        ArrayList list = new ArrayList();
        ItemEvents.MODIFY_TOOLTIPS.post(ScriptType.CLIENT, new ModifyItemTooltipsKubeEvent(list::add));
        clientItemTooltips = List.copyOf(list);
    }

    public static void copyDefaultOptionsFile(File optionsFile) {
        Path defOptions;
        if (!optionsFile.exists() && Files.exists(defOptions = KubeJSPaths.CONFIG.resolve("defaultoptions.txt"), new LinkOption[0])) {
            try {
                KubeJS.LOGGER.info("Loaded default options from kubejs/config/defaultoptions.txt");
                PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(optionsFile), StandardCharsets.UTF_8));
                printwriter.println("version:" + SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                printwriter.print(Files.readString(defOptions));
                printwriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void handleDataFromServerPacket(String channel, @Nullable CompoundTag data) {
        if (NetworkEvents.DATA_RECEIVED.hasListeners(channel)) {
            NetworkEvents.DATA_RECEIVED.post(ScriptType.CLIENT, channel, new NetworkKubeEvent((Player)Minecraft.getInstance().player, channel, data));
        }
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    private void reload(PreparableReloadListener listener) {
        long start = System.currentTimeMillis();
        Minecraft mc = Minecraft.getInstance();
        mc.getResourceManager().getResource(GeneratedData.INTERNAL_RELOAD.id());
        listener.reload(CompletableFuture::completedFuture, mc.getResourceManager(), (ProfilerFiller)InactiveProfiler.INSTANCE, (ProfilerFiller)InactiveProfiler.INSTANCE, (Executor)Util.backgroundExecutor(), (Executor)mc).thenAccept(unused -> mc.player.sendSystemMessage((Component)Component.literal((String)"Done! You still may have to reload all assets with F3 + T")));
    }

    @Override
    public void reloadTextures() {
        this.reload((PreparableReloadListener)Minecraft.getInstance().getTextureManager());
    }

    @Override
    public void reloadLang() {
        KubeJSClient.reloadClientScripts();
        this.reload((PreparableReloadListener)Minecraft.getInstance().getLanguageManager());
    }

    @Override
    public void generateTypings(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"WIP!"), false);
    }

    @Override
    public void reloadConfig() {
        super.reloadConfig();
        ClientProperties.reload();
    }

    @Override
    public void reloadStartupScripts(boolean dedicated) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            CreativeModeTabs.CACHED_PARAMETERS = null;
            CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)mc.player.connection.enabledFeatures(), (mc.player.canUseGameMasterBlocks() && (Boolean)mc.options.operatorItemsTab().get() != false ? 1 : 0) != 0, (HolderLookup.Provider)mc.level.registryAccess());
        }
    }

    @Override
    public void export(List<ExportablePackResources> packs) {
        for (PackResources pack : Minecraft.getInstance().getResourceManager().listPacks().toList()) {
            ExportablePackResources e;
            if (!(pack instanceof ExportablePackResources) || packs.contains(e = (ExportablePackResources)pack)) continue;
            packs.add(e);
        }
    }

    @Override
    public void openErrors(ScriptType type) {
        this.runInMainThread(() -> Minecraft.getInstance().setScreen((Screen)new KubeJSErrorScreen(null, type.console, true)));
    }

    @Override
    public void openErrors(ScriptType type, List<ConsoleLine> errors, List<ConsoleLine> warnings) {
        this.runInMainThread(() -> Minecraft.getInstance().setScreen((Screen)new KubeJSErrorScreen(null, type, null, errors, warnings, true)));
    }

    @Override
    public void runInMainThread(Runnable runnable) {
        Minecraft mc = Minecraft.getInstance();
        if (mc != null) {
            mc.execute(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void updateServerData(KubeServerData data) {
        KubeSessionData sessionData = KubeSessionData.of(Minecraft.getInstance());
        if (sessionData != null) {
            sessionData.sync(data);
        }
    }

    public static void loadPostChains(Minecraft mc) {
        KubedexHighlight.INSTANCE.loadPostChains(mc);
    }

    public static void resizePostChains(int width, int height) {
        KubedexHighlight.INSTANCE.resizePostChains(width, height);
    }

    public static String formatNumber(int count) {
        if (Screen.hasAltDown()) {
            return String.format("%,d", count);
        }
        int index = 0;
        if (count > 9999) {
            while (count / 1000 != 0) {
                count /= 1000;
                ++index;
            }
        }
        if (index > 0) {
            return count + String.valueOf(POWER[index - 1]);
        }
        return String.valueOf(count);
    }

    public static int drawStackSize(GuiGraphics graphics, Font font, int size, int x, int y, int color, boolean dropShadow) {
        String str = KubeJSClient.formatNumber(size);
        int w = font.width(str);
        float scale = ClientProperties.get().shrinkStackSizeText ? (str.length() >= 4 ? 0.5f : (str.length() == 3 ? 0.75f : 1.0f)) : 1.0f;
        graphics.pose().pushPose();
        graphics.pose().translate((float)((int)((float)x + 16.0f - ((float)w - 1.0f) * scale)), (float)((int)((float)y + 16.0f - 7.0f * scale)), 0.0f);
        graphics.pose().scale(scale, scale, 1.0f);
        int s = graphics.drawString(font, str, 0.0f, 0.0f, color, dropShadow);
        graphics.pose().popPose();
        return Mth.ceil((float)((float)s * scale));
    }

    static {
        for (GeneratedDataStage stage : GeneratedDataStage.values()) {
            CLIENT_PACKS.put(stage, new VirtualAssetPack(stage));
        }
        POWER = new char[]{'K', 'M', 'B', 'T'};
    }
}

