/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.color.Color;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class LoadedTexture {
    public static final LoadedTexture EMPTY = new LoadedTexture(0, 0, new int[0], null);
    public final int width;
    public final int height;
    public final int[] pixels;
    public final byte[] mcmeta;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoadedTexture load(ResourceLocation id) {
        try {
            Path path = KubeJSPaths.ASSETS.resolve(id.getNamespace() + "/textures/" + id.getPath() + ".png");
            if (Files.exists(path, new LinkOption[0])) {
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    Path metaPath = KubeJSPaths.ASSETS.resolve(id.getNamespace() + "/textures/" + id.getPath() + ".png.mcmeta");
                    LoadedTexture loadedTexture = new LoadedTexture(ImageIO.read(in), Files.exists(metaPath, new LinkOption[0]) ? Files.readAllBytes(metaPath) : null);
                    return loadedTexture;
                }
            }
            if (!id.getNamespace().equals("kubejs")) return EMPTY;
            Path path1 = KubeJS.thisMod.getModInfo().getOwningFile().getFile().findResource(new String[]{"assets", "kubejs", "textures", id.getPath() + ".png"});
            if (!Files.exists(path1, new LinkOption[0])) return EMPTY;
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path1, new OpenOption[0]));){
                Path metaPath = KubeJS.thisMod.getModInfo().getOwningFile().getFile().findResource(new String[]{"assets", "kubejs", "textures", id.getPath() + ".png.mcmeta"});
                LoadedTexture loadedTexture = new LoadedTexture(ImageIO.read(in), Files.exists(metaPath, new LinkOption[0]) ? Files.readAllBytes(metaPath) : null);
                return loadedTexture;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LoadedTexture(int width, int height, int[] pixels, @Nullable byte[] mcmeta) {
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.mcmeta = mcmeta;
    }

    public LoadedTexture(BufferedImage img, @Nullable byte[] mcmeta) {
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.pixels = new int[this.width * this.height];
        img.getRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        this.mcmeta = mcmeta;
    }

    public byte[] toBytes() {
        if (this.width == 0 || this.height == 0) {
            return new byte[0];
        }
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        img.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return out.toByteArray();
    }

    public LoadedTexture copy() {
        return new LoadedTexture(this.width, this.height, (int[])this.pixels.clone(), this.mcmeta);
    }

    public LoadedTexture remap(Map<Color, Color> remap) {
        if (remap.isEmpty()) {
            return this;
        }
        Int2IntArrayMap colorMap = new Int2IntArrayMap(remap.size());
        for (Map.Entry<Color, Color> entry : remap.entrySet()) {
            Color k = entry.getKey();
            Color v = entry.getValue();
            colorMap.put(k.getArgbJS(), v.getArgbJS());
        }
        int[] result = new int[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            result[i] = (this.pixels[i] & 0xFF000000) == 0 ? 0 : colorMap.getOrDefault(this.pixels[i], this.pixels[i]);
        }
        return new LoadedTexture(this.width, this.height, result, this.mcmeta);
    }

    public LoadedTexture resize(int newWidth, int newHeight) {
        if (this.width == newWidth && this.height == newHeight) {
            return this;
        }
        BufferedImage source = new BufferedImage(this.width, this.height, 2);
        source.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        BufferedImage dst = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D bg = dst.createGraphics();
        bg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        float sx = (float)newWidth / (float)this.width;
        float sy = (float)newHeight / (float)this.height;
        bg.scale(sx, sy);
        bg.drawImage((Image)source, 0, 0, null);
        bg.dispose();
        return new LoadedTexture(dst, this.mcmeta);
    }

    public LoadedTexture tint(@Nullable Color tint) {
        if (tint == null) {
            return this;
        }
        int argb = tint.getArgbJS();
        float l = (float)(argb >> 24 & 0xFF) / 255.0f;
        if (l <= 0.0f) {
            return this;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        float tr = (float)(argb >> 16 & 0xFF) / 255.0f;
        float tg = (float)(argb >> 8 & 0xFF) / 255.0f;
        float tb = (float)(argb & 0xFF) / 255.0f;
        int[] result = new int[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            float pr = (float)(this.pixels[i] >> 16 & 0xFF) / 255.0f;
            float pg = (float)(this.pixels[i] >> 8 & 0xFF) / 255.0f;
            float pb = (float)(this.pixels[i] & 0xFF) / 255.0f;
            result[i] = this.pixels[i] & 0xFF000000 | (int)(Mth.lerp((float)l, (float)pr, (float)(pr * tr)) * 255.0f) << 16 | (int)(Mth.lerp((float)l, (float)pg, (float)(pg * tg)) * 255.0f) << 8 | (int)(Mth.lerp((float)l, (float)pb, (float)(pb * tb)) * 255.0f);
        }
        return new LoadedTexture(this.width, this.height, result, this.mcmeta);
    }
}

