/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.TextIcons;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.command.DumpCommands;
import dev.latvian.mods.kubejs.command.InformationCommands;
import dev.latvian.mods.kubejs.command.PersistentDataCommands;
import dev.latvian.mods.kubejs.command.StageCommands;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.net.DisplayClientErrorsPayload;
import dev.latvian.mods.kubejs.net.DisplayServerErrorsPayload;
import dev.latvian.mods.kubejs.net.ReloadStartupScriptsPayload;
import dev.latvian.mods.kubejs.script.ConsoleLine;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.ExportablePackResources;
import dev.latvian.mods.kubejs.server.BasicCommandKubeEvent;
import dev.latvian.mods.kubejs.server.DataExport;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.PacketDistributor;

public class KubeJSCommands {
    public static final DynamicCommandExceptionType NO_REGISTRY = new DynamicCommandExceptionType(id -> Component.literal((String)("No builtin or static registry found for " + String.valueOf(id))));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        com.google.common.base.Predicate spOrOP = source -> source.getServer().isSingleplayer() || source.hasPermission(2);
        LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kubejs").then(Commands.literal((String)"help").executes(context -> KubeJSCommands.help((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"hand").executes(context -> InformationCommands.hand(((CommandSourceStack)context.getSource()).getPlayerOrException(), InteractionHand.MAIN_HAND)))).then(Commands.literal((String)"offhand").executes(context -> InformationCommands.hand(((CommandSourceStack)context.getSource()).getPlayerOrException(), InteractionHand.OFF_HAND)))).then(Commands.literal((String)"inventory").executes(context -> InformationCommands.inventory(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(Commands.literal((String)"hotbar").executes(context -> InformationCommands.hotbar(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"errors").then(((LiteralArgumentBuilder)Commands.literal((String)"startup").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.errors((CommandSourceStack)context.getSource(), ScriptType.STARTUP)))).then(((LiteralArgumentBuilder)Commands.literal((String)"server").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.errors((CommandSourceStack)context.getSource(), ScriptType.SERVER)))).then(((LiteralArgumentBuilder)Commands.literal((String)"client").requires(source -> true)).executes(context -> KubeJSCommands.errors((CommandSourceStack)context.getSource(), ScriptType.CLIENT))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").then(((LiteralArgumentBuilder)Commands.literal((String)"config").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.reloadConfig((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"startup-scripts").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.reloadStartup((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"server-scripts").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.reloadServer((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"client-scripts").requires(source -> true)).executes(context -> KubeJSCommands.reloadClient((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"textures").requires(source -> true)).executes(context -> KubeJSCommands.reloadTextures((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"lang").requires(source -> true)).executes(context -> KubeJSCommands.reloadLang((CommandSourceStack)context.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"export").requires((Predicate)spOrOP)).then(Commands.literal((String)"debug").executes(context -> KubeJSCommands.export((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"pack-zips").executes(context -> KubeJSCommands.exportPacks((CommandSourceStack)context.getSource(), true)))).then(Commands.literal((String)"pack-folders").executes(context -> KubeJSCommands.exportPacks((CommandSourceStack)context.getSource(), false))))).then(Commands.literal((String)"list-tag").then(((RequiredArgumentBuilder)Commands.argument((String)"registry", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(((CommandSourceStack)ctx.getSource()).registryAccess().registries().map(entry -> entry.key().location().toString()), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.listTagsFor((CommandSourceStack)ctx.getSource(), KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry")))).then(Commands.argument((String)"tag", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(KubeJSCommands.allTags((CommandSourceStack)ctx.getSource(), KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry")).map(TagKey::location).map(ResourceLocation::toString), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.tagObjects((CommandSourceStack)ctx.getSource(), TagKey.create(KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry"), (ResourceLocation)ResourceLocationArgument.getId((CommandContext)ctx, (String)"tag")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"dump").then(Commands.literal((String)"registry").then(Commands.argument((String)"registry", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(((CommandSourceStack)ctx.getSource()).registryAccess().registries().map(entry -> entry.key().location().toString()), (SuggestionsBuilder)builder)).executes(ctx -> DumpCommands.registry((CommandSourceStack)ctx.getSource(), KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"events").requires((Predicate)spOrOP)).executes(context -> DumpCommands.events((CommandSourceStack)context.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stages").requires((Predicate)spOrOP)).then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> StageCommands.addStage((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> StageCommands.removeStage((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.literal((String)"clear").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> StageCommands.clearStages((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player")))))).then(Commands.literal((String)"list").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> StageCommands.listStages((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"generate-typings").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.generateTypings((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"packmode").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.packmode((CommandSourceStack)context.getSource(), ""))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> KubeJSCommands.packmode((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"persistent-data").requires((Predicate)spOrOP)).then(PersistentDataCommands.addPersistentDataCommands(Commands.literal((String)"server"), ctx -> Set.of(((CommandSourceStack)ctx.getSource()).getServer())))).then(((LiteralArgumentBuilder)Commands.literal((String)"dimension").then(PersistentDataCommands.addPersistentDataCommands(Commands.literal((String)"*"), ctx -> (Collection)((CommandSourceStack)ctx.getSource()).getServer().getAllLevels()))).then(PersistentDataCommands.addPersistentDataCommands(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()), ctx -> Set.of(DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension")))))).then(Commands.literal((String)"entity").then(PersistentDataCommands.addPersistentDataCommands(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entities()), ctx -> EntityArgument.getEntities((CommandContext)ctx, (String)"entity")))));
        if (!FMLLoader.isProduction()) {
            cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"eval").requires((Predicate)spOrOP)).then(Commands.argument((String)"code", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> KubeJSCommands.eval((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"code")))));
        }
        LiteralCommandNode cmd1 = dispatcher.register(cmd);
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"kjs").redirect((CommandNode)cmd1));
        for (String id : ServerEvents.BASIC_COMMAND.findUniqueExtraIds(ScriptType.SERVER)) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)id).requires((Predicate)spOrOP)).executes(ctx -> KubeJSCommands.customCommand((CommandSourceStack)ctx.getSource(), id, ""))).then(Commands.argument((String)"input", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> KubeJSCommands.customCommand((CommandSourceStack)ctx.getSource(), id, StringArgumentType.getString((CommandContext)ctx, (String)"input")))));
        }
    }

    private static <T> ResourceKey<Registry<T>> registry(CommandContext<CommandSourceStack> ctx, String arg) {
        return ResourceKey.createRegistryKey((ResourceLocation)ResourceLocationArgument.getId(ctx, (String)arg));
    }

    private static <T> Stream<TagKey<T>> allTags(CommandSourceStack source, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        return ((Registry)source.registryAccess().registry(registry).orElseThrow(() -> NO_REGISTRY.create((Object)registry.location()))).getTagNames();
    }

    private static void link(CommandSourceStack source, ChatFormatting color, String name, String url) {
        source.sendSystemMessage((Component)Component.literal((String)"\u2022 ").append((Component)Component.literal((String)name).withStyle(color).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)))));
    }

    private static int help(CommandSourceStack source) {
        KubeJSCommands.link(source, ChatFormatting.GOLD, "Wiki", "https://kubejs.com/?" + KubeJS.QUERY);
        KubeJSCommands.link(source, ChatFormatting.GREEN, "Support", "https://kubejs.com/support?" + KubeJS.QUERY);
        KubeJSCommands.link(source, ChatFormatting.BLUE, "Changelog", "https://kubejs.com/changelog?" + KubeJS.QUERY);
        return 1;
    }

    private static int customCommand(CommandSourceStack source, String id, String input) {
        if (ServerEvents.BASIC_COMMAND.hasListeners(id)) {
            EventResult result = ServerEvents.BASIC_COMMAND.post(new BasicCommandKubeEvent((Level)source.getLevel(), source.getEntity(), BlockPos.containing((Position)source.getPosition()), id, input.trim()), id);
            Object object = result.value();
            if (object instanceof Throwable) {
                Throwable ex = (Throwable)object;
                source.sendFailure((Component)Component.literal((String)ex.toString()));
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private static int errors(CommandSourceStack source, ScriptType type) throws CommandSyntaxException {
        if (type == ScriptType.CLIENT) {
            ServerPlayer player = source.getPlayerOrException();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DisplayClientErrorsPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        }
        if (source.getServer().isSingleplayer()) {
            KubeJS.PROXY.openErrors(type);
            return 1;
        }
        ServerPlayer player = source.getPlayerOrException();
        ArrayList<ConsoleLine> errors = new ArrayList<ConsoleLine>(type.console.errors);
        ArrayList<ConsoleLine> warnings = new ArrayList<ConsoleLine>(type.console.warnings);
        player.sendSystemMessage((Component)Component.literal((String)"You need KubeJS on client side!").withStyle(ChatFormatting.RED), true);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DisplayServerErrorsPayload(type.ordinal(), errors, warnings), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }

    private static int reloadConfig(CommandSourceStack source) {
        KubeJS.PROXY.reloadConfig();
        source.sendSystemMessage((Component)Component.literal((String)"Done!"));
        return 1;
    }

    private static int reloadStartup(CommandSourceStack source) {
        KubeJS.getStartupScriptManager().reload();
        source.sendSystemMessage((Component)Component.literal((String)"Done!"));
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ReloadStartupScriptsPayload(source.getServer().isDedicatedServer()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }

    private static int reloadServer(CommandSourceStack source) {
        MinecraftServer.ReloadableResources resources = source.getServer().getServerResources();
        resources.managers().kjs$getServerScriptManager().reload();
        source.sendSuccess(() -> Component.literal((String)"Done! To reload recipes, tags, loot tables and other datapack things, run ").append((Component)Component.literal((String)"'/reload'").kjs$clickRunCommand("/reload").kjs$hover((Component)Component.literal((String)"Click to run"))), false);
        return 1;
    }

    private static int reloadClient(CommandSourceStack source) {
        KubeJS.PROXY.reloadClientInternal();
        source.sendSystemMessage((Component)Component.literal((String)"Done! To reload textures, models and other assets, press F3 + T"));
        return 1;
    }

    private static int reloadTextures(CommandSourceStack source) {
        KubeJS.PROXY.reloadTextures();
        return 1;
    }

    private static int reloadLang(CommandSourceStack source) {
        KubeJS.PROXY.reloadLang();
        return 1;
    }

    private static int export(CommandSourceStack source) {
        if (DataExport.export != null) {
            return 0;
        }
        DataExport.export = new DataExport();
        DataExport.export.source = source;
        source.sendSuccess(() -> Component.literal((String)"Reloading server and exporting data..."), true);
        source.getServer().kjs$runCommand("reload");
        return 1;
    }

    private static void afterReload(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"Reloaded!"), true);
    }

    private static int exportPacks(CommandSourceStack source, boolean exportZip) {
        ArrayList<ExportablePackResources> packs = new ArrayList<ExportablePackResources>();
        for (PackResources pack : source.getServer().getResourceManager().listPacks().toList()) {
            if (!(pack instanceof ExportablePackResources)) continue;
            ExportablePackResources e = (ExportablePackResources)pack;
            packs.add(e);
        }
        KubeJS.PROXY.export(packs);
        int success = 0;
        Path combinedPath = KubeJSPaths.EXPORTED_PACKS.resolve(exportZip ? "combined.zip" : "combined");
        try {
            if (exportZip) {
                Files.deleteIfExists(combinedPath);
            } else if (Files.exists(combinedPath, new LinkOption[0])) {
                Files.walk(combinedPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (ExportablePackResources pack : packs) {
            Object packName = exportZip ? pack.exportPath() + ".zip" : pack.exportPath();
            try {
                Path path = KubeJSPaths.EXPORTED_PACKS.resolve((String)packName);
                Path parent = path.getParent();
                if (Files.notExists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                if (exportZip) {
                    Files.deleteIfExists(path);
                    try (FileSystem fs = FileSystems.newFileSystem(path, Map.of("create", true));){
                        pack.export(fs.getPath(".", new String[0]));
                    }
                    fs = FileSystems.newFileSystem(combinedPath, Map.of("create", true));
                    try {
                        pack.export(fs.getPath(".", new String[0]));
                    }
                    finally {
                        if (fs != null) {
                            fs.close();
                        }
                    }
                }
                if (Files.exists(path, new LinkOption[0])) {
                    Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                Files.createDirectories(path, new FileAttribute[0]);
                pack.export(path);
                pack.export(combinedPath);
                source.sendSuccess(() -> KubeJSCommands.lambda$exportPacks$51((String)packName), false);
                ++success;
            }
            catch (IOException e) {
                e.printStackTrace();
                source.sendFailure((Component)Component.empty().append((Component)TextIcons.no().kjs$white()).append("Failed to export %s!".formatted(packName)).withStyle(style -> style.withColor(ChatFormatting.RED).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)e.getMessage())))));
            }
        }
        int success1 = success;
        if (source.getServer().isSingleplayer() && !source.getServer().isPublished()) {
            source.sendSuccess(() -> Component.literal((String)("Exported " + success1 + " packs")).kjs$clickOpenFile(KubeJSPaths.EXPORTED_PACKS.toAbsolutePath().toString()), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)("Exported " + success1 + " packs")), false);
        }
        return success;
    }

    private static <T> int listTagsFor(CommandSourceStack source, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        Stream<TagKey<TagKey>> tags = KubeJSCommands.allTags(source, registry);
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)("List of all Tags for " + String.valueOf(registry.location()) + ":")));
        source.sendSystemMessage((Component)Component.empty());
        long size = tags.map(TagKey::location).map(tag -> Component.literal((String)"- %s".formatted(tag)).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/kubejs list_tag %s %s".formatted(registry.location(), tag))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"[Show all entries for %s]".formatted(tag)))))).mapToLong(msg -> {
            source.sendSystemMessage((Component)msg);
            return 1L;
        }).sum();
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)"Total: %d tags".formatted(size)));
        source.sendSystemMessage((Component)Component.literal((String)"(Click on any of the above tags to list their contents!)"));
        source.sendSystemMessage((Component)Component.empty());
        return 1;
    }

    private static <T> int tagObjects(CommandSourceStack source, TagKey<T> key) throws CommandSyntaxException {
        Registry registry = (Registry)source.registryAccess().registry(key.registry()).orElseThrow(() -> NO_REGISTRY.create((Object)key.registry().location()));
        Optional tag = registry.getTag(key);
        if (tag.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"Tag not found or empty!"));
            return 0;
        }
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)("Contents of #" + String.valueOf(key.location()) + " [" + String.valueOf(key.registry().location()) + "]:")));
        source.sendSystemMessage((Component)Component.empty());
        HolderSet.Named items = (HolderSet.Named)tag.get();
        for (Holder holder : items) {
            String id = (String)holder.unwrap().map(o -> o.location().toString(), o -> String.valueOf(o) + " (unknown ID)");
            source.sendSystemMessage((Component)Component.literal((String)("- " + id)));
        }
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)("Total: " + items.size() + " elements")));
        source.sendSystemMessage((Component)Component.empty());
        return 1;
    }

    private static int generateTypings(CommandSourceStack source) {
        if (!source.getServer().isSingleplayer()) {
            source.sendFailure((Component)Component.literal((String)"You can only run this command in singleplayer!"));
            return 0;
        }
        KubeJS.PROXY.generateTypings(source);
        return 1;
    }

    private static int packmode(CommandSourceStack source, String packmode) {
        if (packmode.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("Current packmode: " + CommonProperties.get().packMode)), false);
        } else {
            CommonProperties.get().setPackMode(packmode);
            source.sendSuccess(() -> Component.literal((String)("Set packmode to: " + packmode)), true);
        }
        return 1;
    }

    private static int eval(CommandSourceStack source, String code) {
        KubeJSContext cx = (KubeJSContext)source.getServer().getServerResources().managers().kjs$getServerScriptManager().contextFactory.enter();
        cx.evaluateString(cx.topLevelScope, code, "eval", 1, null);
        return 1;
    }

    private static /* synthetic */ Component lambda$exportPacks$51(String packName) {
        return Component.empty().append((Component)TextIcons.yes()).append((Component)Component.literal((String)packName).withStyle(ChatFormatting.BLUE));
    }
}

