/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.client.LoadedTexture;
import dev.latvian.mods.kubejs.color.Color;
import dev.latvian.mods.kubejs.color.SimpleColor;
import dev.latvian.mods.kubejs.fluid.FlowingFluidBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBlockBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBucketItemBuilder;
import dev.latvian.mods.kubejs.fluid.FluidTypeBuilder;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.registry.AdditionalObjectRegistry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@ReturnsSelf
public class FluidBuilder
extends BuilderBase<FlowingFluid> {
    public static final Color WATER_COLOR = new SimpleColor(-12618012);
    public transient int slopeFindDistance = 4;
    public transient int levelDecreasePerBlock = 1;
    public transient float explosionResistance = 1.0f;
    public transient int tickRate = 5;
    public FluidTypeBuilder fluidType = new FluidTypeBuilder(this.id);
    public FlowingFluidBuilder flowingFluid = new FlowingFluidBuilder(this);
    public FluidBlockBuilder block = new FluidBlockBuilder(this);
    public FluidBucketItemBuilder bucketItem = new FluidBucketItemBuilder(this);
    private BaseFlowingFluid.Properties properties;

    public FluidBuilder(ResourceLocation i) {
        super(i);
    }

    @Override
    public BuilderBase<FlowingFluid> displayName(Component name) {
        if (this.block != null) {
            this.block.displayName(name);
        }
        if (this.bucketItem != null) {
            this.bucketItem.displayName((Component)Component.literal((String)"").append(name).append(" Bucket"));
        }
        return super.displayName(name);
    }

    public BaseFlowingFluid.Properties createProperties() {
        if (this.properties == null) {
            this.properties = new BaseFlowingFluid.Properties((Supplier)this.fluidType, (Supplier)this, (Supplier)this.flowingFluid);
            this.properties.bucket((Supplier)this.bucketItem);
            this.properties.block((Supplier)this.block);
            this.properties.slopeFindDistance(this.slopeFindDistance);
            this.properties.levelDecreasePerBlock(this.levelDecreasePerBlock);
            this.properties.explosionResistance(this.explosionResistance);
            this.properties.tickRate(this.tickRate);
        }
        return this.properties;
    }

    @Override
    public FlowingFluid createObject() {
        return new BaseFlowingFluid.Source(this.createProperties());
    }

    @Override
    public void createAdditionalObjects(AdditionalObjectRegistry registry) {
        registry.add(NeoForgeRegistries.Keys.FLUID_TYPES, this.fluidType);
        registry.add(Registries.FLUID, this.flowingFluid);
        if (this.block != null) {
            registry.add(Registries.BLOCK, this.block);
        }
        if (this.bucketItem != null) {
            registry.add(Registries.ITEM, this.bucketItem);
        }
    }

    @Override
    public BuilderBase<FlowingFluid> tag(ResourceLocation[] tag) {
        this.flowingFluid.tag(tag);
        return super.tag(tag);
    }

    public FluidBuilder type(Consumer<FluidTypeBuilder> builder) {
        builder.accept(this.fluidType);
        return this;
    }

    public FluidBuilder tint(Color c) {
        this.fluidType.tint = c;
        return this;
    }

    public FluidBuilder stillTexture(ResourceLocation id) {
        this.fluidType.stillTexture = id;
        return this;
    }

    public FluidBuilder flowingTexture(ResourceLocation id) {
        this.fluidType.flowingTexture = id;
        return this;
    }

    public FluidBuilder renderType(BlockRenderType l) {
        this.fluidType.renderType = l;
        return this;
    }

    public FluidBuilder translucent() {
        return this.renderType(BlockRenderType.TRANSLUCENT);
    }

    public FluidBuilder slopeFindDistance(int slopeFindDistance) {
        this.slopeFindDistance = slopeFindDistance;
        return this;
    }

    public FluidBuilder levelDecreasePerBlock(int levelDecreasePerBlock) {
        this.levelDecreasePerBlock = levelDecreasePerBlock;
        return this;
    }

    public FluidBuilder explosionResistance(float explosionResistance) {
        this.explosionResistance = explosionResistance;
        return this;
    }

    public FluidBuilder tickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public FluidBuilder noBucket() {
        this.bucketItem = null;
        return this;
    }

    public FluidBuilder noBlock() {
        this.block = null;
        return this;
    }

    @Override
    public void generateAssets(KubeAssetGenerator generator) {
        LoadedTexture flowingTexture;
        LoadedTexture stillTexture = generator.loadTexture(this.fluidType.stillTexture);
        if (stillTexture != null) {
            generator.texture(this.fluidType.actualStillTexture, stillTexture.tint(this.fluidType.tint));
        }
        if ((flowingTexture = generator.loadTexture(this.fluidType.flowingTexture)) != null) {
            generator.texture(this.fluidType.actualFlowingTexture, flowingTexture.tint(this.fluidType.tint));
        }
        generator.blockState(this.id, m -> m.simpleVariant("", this.id.getNamespace() + ":block/" + this.id.getPath()));
        generator.blockModel(this.id, m -> {
            m.parent("");
            m.texture("particle", this.fluidType.actualStillTexture.toString());
        });
        if (this.bucketItem != null) {
            if (this.bucketItem.modelJson != null) {
                generator.json(KubeAssetGenerator.asItemModelLocation(this.id), (JsonElement)this.bucketItem.modelJson);
                return;
            }
            ResourceLocation fluidPath = this.newID("item/generated/", "_bucket_fluid");
            generator.mask(fluidPath, KubeJS.id("item/bucket_mask"), this.fluidType.actualStillTexture);
            generator.itemModel(this.bucketItem.id, m -> {
                if (!this.bucketItem.parentModel.isEmpty()) {
                    m.parent(this.bucketItem.parentModel);
                } else {
                    m.parent("kubejs:item/generated_bucket");
                }
                m.texture("bucket_fluid", fluidPath);
                if (this.bucketItem.textureJson.size() > 0) {
                    m.textures(this.bucketItem.textureJson);
                }
            });
        }
    }
}

