/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.holder;

import dev.latvian.mods.kubejs.holder.NamespaceHolderSet;
import dev.latvian.mods.kubejs.holder.RegExHolderSet;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public interface HolderWrapper {
    public static final TypeInfo HOLDER = TypeInfo.of(Holder.class);
    public static final TypeInfo HOLDER_SET = TypeInfo.of(HolderSet.class);

    public static Holder<?> wrap(KubeJSContext cx, Object from, TypeInfo param) {
        if (from instanceof Holder) {
            Holder h = (Holder)from;
            return h;
        }
        if (from == null) {
            throw Context.reportRuntimeError((String)"Can't interpret 'null' as a Holder", (Context)cx);
        }
        Registry<?> registry = cx.lookupRegistry(param, from);
        if (!ID.isKey(from)) {
            Class<?> baseClass;
            Holder h = registry.wrapAsHolder(Cast.to(from));
            if (h instanceof Holder.Direct && !(baseClass = cx.lookupRegistryType(param, from).baseClass()).isInstance(from)) {
                throw Context.reportRuntimeError((String)("Can't interpret '" + String.valueOf(from) + "' as Holder: can't cast object to '" + baseClass.getName() + "' of " + String.valueOf(registry.key().location())), (Context)cx);
            }
            return h;
        }
        ResourceLocation id = ID.mc(from);
        Optional holder = registry.getHolder(id);
        if (holder.isEmpty()) {
            throw Context.reportRuntimeError((String)("Can't interpret '" + String.valueOf(from) + "' as Holder: entry not found"), (Context)cx);
        }
        return (Holder)holder.get();
    }

    public static HolderSet<?> wrapSet(KubeJSContext cx, Object from, TypeInfo param) {
        if (from instanceof HolderSet) {
            HolderSet h = (HolderSet)from;
            return h;
        }
        Registry<?> registry = cx.lookupRegistry(param, from);
        HolderSet<?> simpleHolders = HolderWrapper.wrapSimpleSet(registry, from);
        if (simpleHolders != null) {
            return simpleHolders;
        }
        if (from instanceof Iterable) {
            List holder = (List)cx.jsToJava(from, TypeInfo.RAW_LIST.withParams(new TypeInfo[]{HOLDER.withParams(new TypeInfo[]{param})}));
            return HolderSet.direct((List)holder);
        }
        Holder<?> holder = HolderWrapper.wrap(cx, from, param);
        return HolderSet.direct((Holder[])new Holder[]{holder});
    }

    @Nullable
    public static <T> HolderSet<T> wrapSimpleSet(Registry<T> registry, Object from) {
        Pattern regex = RegExpKJS.wrap(from);
        if (regex != null) {
            return new RegExHolderSet(registry.asLookup(), regex);
        }
        if (from instanceof CharSequence) {
            String s = from.toString();
            if (s.isEmpty()) {
                return HolderSet.empty();
            }
            if (s.charAt(0) == '@') {
                return new NamespaceHolderSet(registry.asLookup(), s.substring(1));
            }
            if (s.charAt(0) == '#') {
                TagKey tagKey = TagKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.parse((String)s.substring(1)));
                return registry.getOrCreateTag(tagKey);
            }
        }
        return null;
    }
}

