/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.bindings.DataComponentWrapper;
import dev.latvian.mods.kubejs.bindings.IngredientWrapper;
import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.ingredient.CreativeTabIngredient;
import dev.latvian.mods.kubejs.ingredient.NamespaceIngredient;
import dev.latvian.mods.kubejs.ingredient.RegExIngredient;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public interface IngredientJS {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(Ingredient.class);

    public static Ingredient wrap(RegistryAccessContainer registries, @Nullable Object o) {
        while (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.EMPTY || o == Items.AIR || o == Ingredient.EMPTY) {
            return Ingredient.EMPTY;
        }
        if (o instanceof IngredientSupplierKJS) {
            IngredientSupplierKJS ingr = (IngredientSupplierKJS)o;
            return ingr.kjs$asIngredient();
        }
        if (o instanceof TagKey) {
            TagKey tag = (TagKey)o;
            return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)tag.location()));
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = RegExpKJS.wrap(o);
            if (reg != null) {
                return new RegExIngredient(reg).toVanilla();
            }
            return Ingredient.EMPTY;
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return IngredientJS.ofJson(registries, json);
        }
        if (o instanceof CharSequence) {
            return IngredientJS.ofString(registries, o.toString());
        }
        List<?> list = ListJS.of(o);
        if (list != null) {
            ArrayList<Ingredient> inList = new ArrayList<Ingredient>(list.size());
            for (Object o1 : list) {
                Ingredient ingredient = IngredientJS.wrap(registries, o1);
                if (ingredient == Ingredient.EMPTY) continue;
                inList.add(ingredient);
            }
            if (inList.isEmpty()) {
                return Ingredient.EMPTY;
            }
            if (inList.size() == 1) {
                return (Ingredient)inList.getFirst();
            }
            return CompoundIngredient.of((Ingredient[])inList.toArray(new Ingredient[0]));
        }
        Map<?, ?> map = MapJS.of(o);
        if (map != null) {
            return Ingredient.CODEC.decode((DynamicOps)JavaOps.INSTANCE, map).result().map(Pair::getFirst).orElse(Ingredient.EMPTY);
        }
        return ItemStackJS.wrap(registries, o).kjs$asIngredient();
    }

    public static Ingredient ofString(RegistryAccessContainer registries, String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return Ingredient.EMPTY;
        }
        if (s.equals("*")) {
            return IngredientWrapper.all;
        }
        try {
            return IngredientJS.read(registries, new StringReader(s));
        }
        catch (CommandSyntaxException e) {
            KubeJS.LOGGER.error("Failed to read ingredient from '" + s + "': " + String.valueOf((Object)e));
            return Ingredient.EMPTY;
        }
    }

    public static Ingredient ofJson(RegistryAccessContainer registries, JsonElement json) {
        if (json == null || json.isJsonNull() || json.isJsonArray() && json.getAsJsonArray().isEmpty()) {
            return Ingredient.EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return IngredientJS.wrap(registries, json.getAsString());
        }
        return Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().map(Pair::getFirst).orElseThrow();
    }

    public static boolean isIngredientLike(Object from) {
        return from instanceof Ingredient || from instanceof SizedIngredient || from instanceof ItemStack;
    }

    public static Ingredient read(RegistryAccessContainer registries, StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            return Ingredient.EMPTY;
        }
        return switch (reader.peek()) {
            case '-' -> {
                reader.skip();
                yield Ingredient.EMPTY;
            }
            case '*' -> {
                reader.skip();
                yield IngredientWrapper.all;
            }
            case '#' -> {
                reader.skip();
                yield Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.read((StringReader)reader)));
            }
            case '@' -> {
                reader.skip();
                yield new NamespaceIngredient(reader.readUnquotedString()).toVanilla();
            }
            case '%' -> {
                reader.skip();
                ResourceLocation id = ResourceLocation.read((StringReader)reader);
                CreativeModeTab group = UtilsJS.findCreativeTab(id);
                if (group == null) {
                    yield Ingredient.EMPTY;
                }
                yield new CreativeTabIngredient(group).toVanilla();
            }
            case '/' -> {
                Pattern regex = RegExpKJS.read(reader);
                yield new RegExIngredient(regex).toVanilla();
            }
            case '[' -> {
                reader.skip();
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() == ']') {
                    yield Ingredient.EMPTY;
                }
                ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(2);
                while (true) {
                    ingredients.add(IngredientJS.read(registries, reader));
                    reader.skipWhitespace();
                    if (reader.canRead() && reader.peek() == ',') {
                        reader.skip();
                        reader.skipWhitespace();
                        continue;
                    }
                    if (!reader.canRead() || reader.peek() == ']') break;
                }
                reader.expect(']');
                reader.skipWhitespace();
                yield CompoundIngredient.of((Ingredient[])ingredients.toArray(new Ingredient[0]));
            }
            default -> {
                DataComponentPredicate components;
                char next;
                ResourceLocation itemId = ResourceLocation.read((StringReader)reader);
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                char v1 = next = reader.canRead() ? reader.peek() : (char)'\u0000';
                if ((next == '[' || next == '{') && (components = DataComponentWrapper.readPredicate(registries.nbt(), reader)) != DataComponentPredicate.EMPTY) {
                    yield new DataComponentIngredient((HolderSet)HolderSet.direct((Holder[])new Holder[]{item.builtInRegistryHolder()}), components, false).toVanilla();
                }
                yield Ingredient.of((ItemLike[])new ItemLike[]{item});
            }
        };
    }
}

