/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.kubedex;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.net.RequestBlockKubedexPayload;
import dev.latvian.mods.kubejs.net.RequestEntityKubedexPayload;
import dev.latvian.mods.kubejs.net.RequestInventoryKubedexPayload;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class KubedexHighlight {
    public static KubedexHighlight INSTANCE = new KubedexHighlight();
    public static KeyMapping keyMapping;
    public int color = 10092467;
    public Mode mode = Mode.NONE;
    public boolean actualKey;
    @Nullable
    public PostChain postChain;
    @Nullable
    public RenderTarget renderInput;
    @Nullable
    public RenderTarget mcDepthInput;
    @Nullable
    public RenderTarget renderOutput;
    @Nullable
    public ShaderInstance highlightShader;
    public boolean renderAnything;
    public final Set<Slot> hoveredSlots = new HashSet<Slot>();

    public void loadPostChains(Minecraft mc) {
        if (this.postChain != null) {
            this.postChain.close();
            this.postChain = null;
            this.renderInput = null;
            this.mcDepthInput = null;
            this.renderOutput = null;
        }
        ResourceLocation id = ResourceLocation.withDefaultNamespace((String)"shaders/post/kubejs/highlight.json");
        try {
            this.postChain = new PostChain(mc.getTextureManager(), (ResourceProvider)mc.getResourceManager(), mc.getMainRenderTarget(), id);
            this.postChain.resize(mc.getWindow().getWidth(), mc.getWindow().getHeight());
            this.renderInput = this.postChain.getTempTarget("input");
            this.mcDepthInput = this.postChain.getTempTarget("mcdepth");
            this.renderOutput = this.postChain.getTempTarget("output");
        }
        catch (IOException ex) {
            KubeJS.LOGGER.warn("Failed to load shader: {}", (Object)id, (Object)ex);
        }
        catch (JsonSyntaxException ex) {
            KubeJS.LOGGER.warn("Failed to parse shader: {}", (Object)id, (Object)ex);
        }
    }

    public void tickPre(Minecraft mc) {
        boolean prevKeyDown = this.actualKey;
        boolean bl = this.actualKey = mc.level != null && mc.player != null && keyMapping != null && !mc.isPaused() && mc.player.hasPermissions(2) && mc.kjs$isKeyMappingDown(keyMapping);
        while (this.actualKey && this.mode != Mode.NONE && mc.options.keyInventory.consumeClick()) {
            this.keyToggled(mc, Mode.NONE, false);
        }
        if (prevKeyDown != this.actualKey) {
            if (!this.actualKey) {
                this.keyToggled(mc, Mode.NONE, true);
            } else if (mc.screen != null) {
                this.keyToggled(mc, Mode.SCREEN, true);
            } else {
                this.keyToggled(mc, Mode.WORLD, true);
            }
        }
    }

    private void playSound(Minecraft mc) {
        String sound = DevProperties.get().kubedexSound;
        if (!sound.isEmpty()) {
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)sound)), (float)1.0f));
        }
    }

    private void requestBlock(BlockPos pos) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestBlockKubedexPayload(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void requestEntity(Entity entity) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestEntityKubedexPayload(entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void requestInventory(Set<Slot> slots) {
        ArrayList<Integer> slotIds = new ArrayList<Integer>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Slot slot : slots) {
            if (slot.container instanceof Inventory) {
                slotIds.add(slot.getSlotIndex());
                continue;
            }
            stacks.add(slot.getItem());
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestInventoryKubedexPayload(slotIds, stacks), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void keyToggled(Minecraft mc, Mode newMode, boolean success) {
        if (newMode == Mode.NONE) {
            if (this.mode == Mode.SCREEN) {
                if (success && !this.hoveredSlots.isEmpty()) {
                    this.playSound(mc);
                    this.requestInventory(this.hoveredSlots);
                }
                this.hoveredSlots.clear();
            } else if (success) {
                EntityHitResult hit;
                HitResult hitResult = mc.hitResult;
                if (hitResult instanceof EntityHitResult && (hit = (EntityHitResult)hitResult).getType() == HitResult.Type.ENTITY) {
                    this.playSound(mc);
                    this.requestEntity(hit.getEntity());
                } else {
                    BlockHitResult hit2;
                    hitResult = mc.hitResult;
                    if (hitResult instanceof BlockHitResult && (hit2 = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK) {
                        this.playSound(mc);
                        this.requestBlock(hit2.getBlockPos());
                    }
                }
            }
        }
        this.mode = newMode;
    }

    public void clearBuffers(Minecraft mc) {
        if (this.renderInput != null) {
            this.renderInput.clear(Minecraft.ON_OSX);
            mc.getMainRenderTarget().bindWrite(false);
        }
        this.renderAnything = false;
    }

    public void renderAfterEntities(Minecraft mc, RenderLevelStageEvent event) {
        BlockHitResult hit;
        if (this.mode != Mode.WORLD || mc.hitResult == null || mc.hitResult.getType() == HitResult.Type.MISS || this.renderInput == null || this.highlightShader == null || mc.screen != null) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        Vec3 cam = event.getCamera().getPosition();
        float delta = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        ms.pushPose();
        ms.translate(-cam.x, -cam.y, -cam.z);
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult && (hit = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK) {
            mc.renderBuffers().bufferSource().endBatch();
            this.renderInput.bindWrite(false);
            this.renderAnything = true;
            double x = hit.getBlockPos().getX();
            double y = hit.getBlockPos().getY();
            double z = hit.getBlockPos().getZ();
            ms.translate(x, y, z);
            BlockState state = mc.level.getBlockState(hit.getBlockPos());
            BakedModel model = mc.getBlockRenderer().getBlockModel(state);
            long seed = state.getSeed(hit.getBlockPos());
            WrappedMultiBufferSource bufferSource = new WrappedMultiBufferSource((MultiBufferSource)mc.renderBuffers().bufferSource(), this.color);
            for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)seed), ModelData.EMPTY)) {
                mc.getBlockRenderer().getModelRenderer().tesselateBlock((BlockAndTintGetter)mc.level, model, state, hit.getBlockPos(), ms, bufferSource.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType)), false, RandomSource.create(), seed, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
            }
            BlockEntity entity = mc.level.getBlockEntity(hit.getBlockPos());
            if (entity != null) {
                mc.getBlockEntityRenderDispatcher().render(entity, delta, ms, (MultiBufferSource)bufferSource);
            } else if (state.getRenderShape() == RenderShape.INVISIBLE) {
                VertexConsumer buf = bufferSource.getBuffer(RenderType.debugQuads());
                Matrix4f m = ms.last().pose();
                this.box(buf, m, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
            mc.renderBuffers().bufferSource().endBatch();
            mc.getMainRenderTarget().bindWrite(false);
        } else {
            EntityHitResult hit2;
            HitResult x = mc.hitResult;
            if (x instanceof EntityHitResult && (hit2 = (EntityHitResult)x).getType() == HitResult.Type.ENTITY) {
                Entity entity = hit2.getEntity();
                mc.renderBuffers().bufferSource().endBatch();
                this.renderInput.bindWrite(false);
                this.renderAnything = true;
                Vec3 p = entity.getPosition(delta);
                float yaw = Mth.lerp((float)delta, (float)hit2.getEntity().yRotO, (float)entity.getYRot());
                EntityRenderer renderer = mc.getEntityRenderDispatcher().getRenderer(entity);
                WrappedMultiBufferSource bufferSource = new WrappedMultiBufferSource((MultiBufferSource)mc.renderBuffers().bufferSource(), this.color);
                if (renderer != null) {
                    Vec3 off = renderer.getRenderOffset(entity, delta);
                    double x1 = p.x + off.x();
                    double y1 = p.y + off.y();
                    double z1 = p.z + off.z();
                    ms.pushPose();
                    ms.translate(x1, y1, z1);
                    renderer.render(entity, yaw, delta, ms, (MultiBufferSource)bufferSource, 0xF000F0);
                    ms.popPose();
                } else {
                    VertexConsumer buf = bufferSource.getBuffer(RenderType.debugQuads());
                    ms.translate(p.x, p.y, p.z);
                    Matrix4f m = ms.last().pose();
                    float w = entity.getBbWidth() / 2.0f;
                    this.box(buf, m, -w, 0.0f, -w, w, entity.getBbHeight(), w);
                }
                mc.renderBuffers().bufferSource().endBatch();
                mc.getMainRenderTarget().bindWrite(false);
            }
        }
        ms.popPose();
    }

    private void box(VertexConsumer buf, Matrix4f m, float x0, float y0, float z0, float x1, float y1, float z1) {
        buf.addVertex(m, x0, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z1).setColor(255, 255, 255, 255);
    }

    public void screen(Minecraft mc, GuiGraphics graphics, AbstractContainerScreen<?> screen, int mx, int my, float delta) {
        if (this.renderInput == null || this.highlightShader == null) {
            return;
        }
        while (this.actualKey && this.mode != Mode.NONE && mc.options.keyInventory.consumeClick()) {
            this.keyToggled(mc, Mode.NONE, false);
        }
        if (this.mode != Mode.SCREEN) {
            return;
        }
        AbstractContainerMenu menu = screen.getMenu();
        for (Slot slot : menu.slots) {
            int sx = slot.x + screen.getGuiLeft();
            int sy = slot.y + screen.getGuiTop();
            if (mx < sx || mx >= sx + 16 || my < sy || my >= sy + 16 || !slot.hasItem()) continue;
            this.hoveredSlots.add(slot);
        }
        if (this.hoveredSlots.isEmpty()) {
            return;
        }
        this.renderAnything = true;
        graphics.flush();
        this.renderInput.bindWrite(false);
        WrappedMultiBufferSource bufferSource = new WrappedMultiBufferSource((MultiBufferSource)mc.renderBuffers().bufferSource(), this.color);
        for (Slot slot : this.hoveredSlots) {
            int x = slot.x + screen.getGuiLeft();
            int y = slot.y + screen.getGuiTop();
            ItemStack stack = slot.getItem();
            BakedModel model = mc.getItemRenderer().getModel(stack, (Level)mc.level, (LivingEntity)mc.player, 0);
            graphics.pose().pushPose();
            graphics.pose().translate((float)x + 8.0f, (float)y + 8.0f, 0.0f);
            graphics.pose().scale(16.0f, -16.0f, 16.0f);
            try {
                ItemStack renderStack = stack.copy();
                renderStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)false);
                renderStack.setDamageValue(0);
                renderStack.setCount(1);
                mc.getItemRenderer().render(renderStack, ItemDisplayContext.GUI, false, graphics.pose(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
                crashreportcategory.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                throw new ReportedException(crashreport);
            }
            graphics.pose().popPose();
        }
        graphics.flush();
        mc.getMainRenderTarget().bindWrite(false);
    }

    public void afterEverything(Minecraft mc, GuiGraphics graphics, float delta) {
        if (this.renderOutput == null || this.postChain == null || !this.renderAnything) {
            return;
        }
        graphics.flush();
        this.postChain.setUniform("OutlineSize", (float)mc.getWindow().getGuiScale());
        this.postChain.process(delta);
        mc.getMainRenderTarget().bindWrite(false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        this.renderOutput.blitToScreen(mc.getWindow().getWidth(), mc.getWindow().getHeight(), false);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        mc.getMainRenderTarget().bindWrite(false);
    }

    public void resizePostChains(int width, int height) {
        if (this.postChain != null) {
            this.postChain.resize(width, height);
        }
    }

    public static enum Mode {
        NONE(false),
        SCREEN(false),
        WORLD(true);

        public final boolean cancelHighlight;

        private Mode(boolean cancelHighlight) {
            this.cancelHighlight = cancelHighlight;
        }
    }

    private record WrappedMultiBufferSource(MultiBufferSource delegate, int red, int green, int blue) implements MultiBufferSource
    {
        private WrappedMultiBufferSource(MultiBufferSource parent, int color) {
            this(parent, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
        }

        public VertexConsumer getBuffer(RenderType renderType) {
            return new WrappedVertexConsumer(this.delegate.getBuffer((RenderType)new WrappedRenderType(renderType)), this.red, this.green, this.blue);
        }
    }

    private record WrappedVertexConsumer(VertexConsumer delegate, int red, int green, int blue) implements VertexConsumer
    {
        public VertexConsumer addVertex(float f, float g, float h) {
            this.delegate.addVertex(f, g, h);
            return this;
        }

        public VertexConsumer setColor(int i, int j, int k, int l) {
            this.delegate.setColor(this.red, this.green, this.blue, 255);
            return this;
        }

        public VertexConsumer setUv(float f, float g) {
            this.delegate.setUv(f, g);
            return this;
        }

        public VertexConsumer setUv1(int i, int j) {
            this.delegate.setUv1(i, j);
            return this;
        }

        public VertexConsumer setUv2(int i, int j) {
            this.delegate.setUv2(i, j);
            return this;
        }

        public VertexConsumer setNormal(float f, float g, float h) {
            this.delegate.setNormal(f, g, h);
            return this;
        }
    }

    private static final class WrappedRenderType
    extends RenderType {
        public final RenderType delegate;

        public WrappedRenderType(RenderType delegate) {
            super("kubejs:wrapped", delegate.format(), delegate.mode(), delegate.bufferSize(), delegate.affectsCrumbling(), delegate.sortOnUpload(), () -> {
                delegate.setupRenderState();
                RenderSystem.setShader(() -> KubedexHighlight.INSTANCE.highlightShader);
            }, () -> ((RenderType)delegate).clearRenderState());
            this.delegate = delegate;
        }

        public String toString() {
            return "kubejs:wrapped[" + String.valueOf(this.delegate) + "]";
        }
    }
}

