/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.ErroredKubeRecipe;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.component.ComponentValueMap;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Wrapper;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class RecipeTypeFunction
extends BaseFunction
implements WrappedJS {
    public static final Pattern SKIP_ERROR = Pattern.compile("dev\\.latvian\\.mods\\.kubejs\\.recipe\\.RecipeTypeFunction\\.call");
    public final RecipesKubeEvent event;
    public final ResourceLocation id;
    public final String idString;
    public final RecipeSchemaType schemaType;

    public RecipeTypeFunction(RecipesKubeEvent event, RecipeSchemaType schemaType) {
        this.event = event;
        this.id = schemaType.id;
        this.idString = this.id.toString();
        this.schemaType = schemaType;
    }

    public KubeRecipe call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args0) {
        try {
            return this.createRecipe(cx, args0);
        }
        catch (KubeRuntimeException rex) {
            ErroredKubeRecipe recipe = new ErroredKubeRecipe(this.event, "Failed to create recipe for type '%s'".formatted(this.idString), rex, SKIP_ERROR);
            recipe.sourceLine = rex.sourceLine;
            return recipe;
        }
    }

    public KubeRecipe createRecipe(Context cx, Object[] args) {
        SourceLine sourceLine = SourceLine.of(cx);
        try {
            for (int i = 0; i < args.length; ++i) {
                args[i] = Wrapper.unwrapped((Object)args[i]);
            }
            this.schemaType.getSerializer();
            RecipeConstructor constructor = (RecipeConstructor)this.schemaType.schema.constructors().get(args.length);
            if (constructor == null) {
                if (args.length == 1 && (args[0] instanceof Map || args[0] instanceof JsonObject)) {
                    KubeRecipe recipe = this.schemaType.schema.deserialize(sourceLine, this, null, MapJS.json(cx, args[0]));
                    recipe.afterLoaded();
                    return this.event.addRecipe(recipe, true);
                }
                throw new KubeRuntimeException("Constructor for " + String.valueOf(this.id) + " with " + args.length + " arguments not found!").source(sourceLine);
            }
            ComponentValueMap argMap = new ComponentValueMap(args.length);
            int index = 0;
            for (RecipeKey<?> key : constructor.keys) {
                argMap.put(key, Wrapper.unwrapped((Object)args[index++]));
            }
            KubeRecipe recipe = constructor.create(cx, sourceLine, this, this.schemaType, argMap);
            recipe.afterLoaded();
            return this.event.addRecipe(recipe, false);
        }
        catch (KubeRuntimeException rex) {
            throw rex.source(sourceLine);
        }
        catch (Throwable ex) {
            throw new KubeRuntimeException("Failed to create recipe for type '" + String.valueOf(this.id) + "' with args " + Arrays.stream(args).map(o -> o == null ? "null" : String.valueOf(o) + ": " + o.getClass().getSimpleName()).collect(Collectors.joining(", ", "[", "]")), ex).source(sourceLine);
        }
    }

    public String toString() {
        return this.idString;
    }

    public int hashCode() {
        return this.idString.hashCode();
    }

    public boolean equals(Object obj) {
        return this.idString.equals(obj.toString());
    }
}

