/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.core.RecipeManagerKJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.error.UnknownRecipeTypeException;
import dev.latvian.mods.kubejs.event.EventExceptionHandler;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.recipe.ErroredKubeRecipe;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.NamespaceFunction;
import dev.latvian.mods.kubejs.recipe.RecipeHelper;
import dev.latvian.mods.kubejs.recipe.RecipeTypeFunction;
import dev.latvian.mods.kubejs.recipe.filter.ConstantFilter;
import dev.latvian.mods.kubejs.recipe.filter.IDFilter;
import dev.latvian.mods.kubejs.recipe.filter.OrFilter;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.UnknownRecipeSchema;
import dev.latvian.mods.kubejs.recipe.special.SpecialRecipeSerializerManager;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.server.ChangesForChat;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.TimeJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class RecipesKubeEvent
implements KubeEvent {
    public static final Pattern POST_SKIP_ERROR = Pattern.compile("dev\\.latvian\\.mods\\.kubejs\\.recipe\\.RecipesKubeEvent\\.post");
    public static final Pattern CREATE_RECIPE_SKIP_ERROR = Pattern.compile("dev\\.latvian\\.mods\\.kubejs\\.recipe\\.RecipesKubeEvent\\.createRecipe");
    private static final Predicate<KubeRecipe> RECIPE_NOT_REMOVED = r -> r != null && !r.removed;
    private static final EventExceptionHandler RECIPE_EXCEPTION_HANDLER = (event, handler, ex) -> {
        if (ex instanceof KubeRuntimeException || ex instanceof JsonParseException) {
            ConsoleJS.SERVER.error("Error while processing recipe event handler: " + String.valueOf(handler), ex);
            return null;
        }
        return ex;
    };
    private static final Function<RecipeHolder<?>, ResourceLocation> RECIPE_ID = RecipeHolder::id;
    private static final Predicate<RecipeHolder<?>> RECIPE_NON_NULL = Objects::nonNull;
    private static final Function<RecipeHolder<?>, RecipeHolder<?>> RECIPE_IDENTITY = Function.identity();
    public final RecipeSchemaStorage recipeSchemaStorage;
    public final RegistryAccessContainer registries;
    public final RegistryOps<JsonElement> jsonOps;
    public final Map<ResourceLocation, KubeRecipe> originalRecipes;
    public final Collection<KubeRecipe> addedRecipes;
    private final BinaryOperator<RecipeHolder<?>> mergeOriginal;
    private final BinaryOperator<RecipeHolder<?>> mergeAdded;
    public final AtomicInteger failedCount;
    public final Map<ResourceLocation, KubeRecipe> takenIds;
    private final Map<String, Object> recipeFunctions;
    public final transient RecipeTypeFunction vanillaShaped;
    public final transient RecipeTypeFunction vanillaShapeless;
    public final RecipeTypeFunction shaped;
    public final RecipeTypeFunction shapeless;
    public final RecipeTypeFunction smelting;
    public final RecipeTypeFunction blasting;
    public final RecipeTypeFunction smoking;
    public final RecipeTypeFunction campfireCooking;
    public final RecipeTypeFunction stonecutting;
    public final RecipeTypeFunction smithing;
    public final RecipeTypeFunction smithingTrim;
    final RecipeSerializer<?> stageSerializer;

    private String recipeToString(Recipe<?> recipe) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)recipe.getSerializer()));
        try {
            ArrayList in = new ArrayList();
            for (Ingredient ingredient : recipe.getIngredients()) {
                ArrayList<String> list = new ArrayList<String>();
                for (ItemStack item : ingredient.getItems()) {
                    list.add(item.kjs$toItemString0(this.registries.nbt()));
                }
                in.add(list);
            }
            map.put("in", in);
        }
        catch (Exception ex) {
            map.put("in_error", ex.toString());
        }
        try {
            ItemStack result = recipe.getResultItem((HolderLookup.Provider)this.registries.access());
            map.put("out", (result == null ? ItemStack.EMPTY : result).kjs$toItemString0(this.registries.nbt()));
        }
        catch (Exception ex) {
            map.put("out_error", ex.toString());
        }
        return map.toString();
    }

    public RecipesKubeEvent(ServerScriptManager manager) {
        ConsoleJS.SERVER.info("Initializing recipe event...");
        this.recipeSchemaStorage = manager.recipeSchemaStorage;
        this.registries = manager.getRegistries();
        this.jsonOps = new ConditionalOps(this.registries.json(), (ICondition.IContext)this.registries);
        this.originalRecipes = new HashMap<ResourceLocation, KubeRecipe>();
        this.addedRecipes = new ConcurrentLinkedQueue<KubeRecipe>();
        this.recipeFunctions = new HashMap<String, Object>();
        this.takenIds = new ConcurrentHashMap<ResourceLocation, KubeRecipe>();
        this.mergeOriginal = (a, b) -> {
            ConsoleJS.SERVER.warn("Duplicate original recipe for id " + String.valueOf(a.id()) + "!\nRecipe A: " + this.recipeToString(a.value()) + "\nRecipe B: " + this.recipeToString(b.value()) + "\nUsing last one encountered.");
            return b;
        };
        this.mergeAdded = (a, b) -> {
            ConsoleJS.SERVER.error("Duplicate added recipe for id " + String.valueOf(a.id()) + "!\nRecipe A: " + this.recipeToString(a.value()) + "\nRecipe B: " + this.recipeToString(b.value()) + "\nUsing last one encountered.");
            return b;
        };
        this.failedCount = new AtomicInteger(0);
        for (RecipeNamespace recipeNamespace : this.recipeSchemaStorage.namespaces.values()) {
            HashMap<String, RecipeTypeFunction> nsMap = new HashMap<String, RecipeTypeFunction>();
            this.recipeFunctions.put(recipeNamespace.name, new NamespaceFunction(recipeNamespace, nsMap));
            for (Map.Entry entry : recipeNamespace.entrySet()) {
                RecipeTypeFunction func = new RecipeTypeFunction(this, (RecipeSchemaType)entry.getValue());
                nsMap.put(((RecipeSchemaType)entry.getValue()).id.getPath(), func);
                this.recipeFunctions.put(((RecipeSchemaType)entry.getValue()).id.toString(), func);
            }
        }
        this.vanillaShaped = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:crafting_shaped");
        this.vanillaShapeless = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:crafting_shapeless");
        this.shaped = CommonProperties.get().serverOnly ? this.vanillaShaped : (RecipeTypeFunction)this.recipeFunctions.get("kubejs:shaped");
        this.shapeless = CommonProperties.get().serverOnly ? this.vanillaShapeless : (RecipeTypeFunction)this.recipeFunctions.get("kubejs:shapeless");
        this.smelting = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:smelting");
        this.blasting = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:blasting");
        this.smoking = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:smoking");
        this.campfireCooking = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:campfire_cooking");
        this.stonecutting = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:stonecutting");
        this.smithing = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:smithing_transform");
        this.smithingTrim = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:smithing_trim");
        for (Map.Entry entry : new ArrayList<Map.Entry<String, Object>>(this.recipeFunctions.entrySet())) {
            String s;
            if (!(entry.getValue() instanceof RecipeTypeFunction) || ((String)entry.getKey()).indexOf(58) == -1 || (s = UtilsJS.snakeCaseToCamelCase((String)entry.getKey())).equals(entry.getKey())) continue;
            this.recipeFunctions.put(s, entry.getValue());
        }
        for (Map.Entry entry : this.recipeSchemaStorage.mappings.entrySet()) {
            Object type = this.recipeFunctions.get(((ResourceLocation)entry.getValue()).toString());
            if (!(type instanceof RecipeTypeFunction)) continue;
            this.recipeFunctions.put((String)entry.getKey(), type);
        }
        this.recipeFunctions.put("shaped", this.shaped);
        this.recipeFunctions.put("shapeless", this.shapeless);
        this.recipeFunctions.put("smelting", this.smelting);
        this.recipeFunctions.put("blasting", this.blasting);
        this.recipeFunctions.put("smoking", this.smoking);
        this.recipeFunctions.put("campfireCooking", this.campfireCooking);
        this.recipeFunctions.put("stonecutting", this.stonecutting);
        this.recipeFunctions.put("smithing", this.smithing);
        this.recipeFunctions.put("smithingTrim", this.smithingTrim);
        this.stageSerializer = (RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.get(ResourceLocation.parse((String)"recipestages:stage"));
    }

    @HideFromJS
    public void post(RecipeManagerKJS recipeManager, Map<ResourceLocation, JsonElement> datapackRecipeMap) {
        ConsoleJS.SERVER.info("Processing recipes...");
        Stopwatch timer = Stopwatch.createStarted();
        KubeJSPlugins.forEachPlugin(p -> p.beforeRecipeLoading(this, recipeManager, datapackRecipeMap));
        for (Map.Entry<ResourceLocation, JsonElement> entry : datapackRecipeMap.entrySet()) {
            ResourceLocation recipeId = entry.getKey();
            if (recipeId == null || recipeId.getPath().startsWith("_")) continue;
            DataResult<JsonObject> jsonResult = RecipeHelper.validate(this.jsonOps, entry.getValue());
            if (jsonResult.error().isPresent()) {
                DataResult.Error error = (DataResult.Error)jsonResult.error().get();
                if (!DevProperties.get().logSkippedRecipes) continue;
                ConsoleJS.SERVER.info("Skipping recipe %s, %s".formatted(recipeId, error.message()));
                continue;
            }
            JsonObject json = (JsonObject)jsonResult.getOrThrow(JsonParseException::new);
            String typeStr = GsonHelper.getAsString((JsonObject)json, (String)"type");
            String recipeIdAndType = String.valueOf(recipeId) + "[" + typeStr + "]";
            RecipeTypeFunction type = this.getRecipeFunction(typeStr);
            if (type == null) {
                if (!DevProperties.get().logSkippedRecipes) continue;
                ConsoleJS.SERVER.info("Skipping recipe " + String.valueOf(recipeId) + ", unknown type: " + typeStr);
                continue;
            }
            try {
                KubeRecipe recipe = type.schemaType.schema.deserialize(SourceLine.UNKNOWN, type, recipeId, json);
                recipe.afterLoaded();
                this.originalRecipes.put(recipeId, recipe);
                if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                Recipe<?> original = recipe.getOriginalRecipe();
                if (original == null || SpecialRecipeSerializerManager.INSTANCE.isSpecial(original)) {
                    ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": <dynamic>");
                    continue;
                }
                ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": " + recipe.getFromToString());
            }
            catch (Throwable ex) {
                if (DevProperties.get().logErroringRecipes) {
                    ConsoleJS.SERVER.warn("Failed to parse recipe '" + recipeIdAndType + "'! Falling back to vanilla", ex, POST_SKIP_ERROR);
                }
                try {
                    this.originalRecipes.put(recipeId, UnknownRecipeSchema.SCHEMA.deserialize(SourceLine.UNKNOWN, type, recipeId, json));
                }
                catch (JsonParseException | IllegalArgumentException | NullPointerException ex2) {
                    if (!DevProperties.get().logErroringRecipes) continue;
                    ConsoleJS.SERVER.warn("Failed to parse recipe " + recipeIdAndType, ex2, POST_SKIP_ERROR);
                }
                catch (Exception ex3) {
                    ConsoleJS.SERVER.warn("Failed to parse recipe " + recipeIdAndType, ex3, POST_SKIP_ERROR);
                }
            }
        }
        this.takenIds.putAll(this.originalRecipes);
        ConsoleJS.SERVER.info("Found " + this.originalRecipes.size() + " recipes in " + String.valueOf(timer.stop()));
        timer.reset().start();
        ServerEvents.RECIPES.post(ScriptType.SERVER, this);
        int modifiedCount = 0;
        ConcurrentLinkedQueue<KubeRecipe> removedRecipes = new ConcurrentLinkedQueue<KubeRecipe>();
        for (KubeRecipe r : this.originalRecipes.values()) {
            if (r.removed) {
                removedRecipes.add(r);
                continue;
            }
            if (!r.hasChanged()) continue;
            ++modifiedCount;
        }
        ConsoleJS.SERVER.info("Posted recipe events in " + TimeJS.msToString(timer.stop().elapsed(TimeUnit.MILLISECONDS)));
        timer.reset().start();
        this.addedRecipes.removeIf(RecipesKubeEvent::addedRecipeRemoveCheck);
        HashMap recipesByName = new HashMap(this.originalRecipes.size() + this.addedRecipes.size());
        try {
            recipesByName.putAll((Map)this.originalRecipes.values().parallelStream().filter(RECIPE_NOT_REMOVED).map(this::createRecipe).filter(RECIPE_NON_NULL).collect(Collectors.toConcurrentMap(RECIPE_ID, RECIPE_IDENTITY, this.mergeOriginal)));
        }
        catch (Throwable ex) {
            ConsoleJS.SERVER.error("Error creating datapack recipes", ex, POST_SKIP_ERROR);
        }
        try {
            recipesByName.putAll((Map)this.addedRecipes.parallelStream().map(this::createRecipe).filter(RECIPE_NON_NULL).collect(Collectors.toConcurrentMap(RECIPE_ID, RECIPE_IDENTITY, this.mergeAdded)));
        }
        catch (Throwable ex) {
            ConsoleJS.SERVER.error("Error creating script recipes", ex, POST_SKIP_ERROR);
        }
        KubeJSPlugins.forEachPlugin(p -> p.injectRuntimeRecipes(this, recipeManager, recipesByName));
        recipeManager.kjs$replaceRecipes(recipesByName);
        ChangesForChat.recipesAdded = this.addedRecipes.size();
        ChangesForChat.recipesModified = modifiedCount;
        ChangesForChat.recipesRemoved = removedRecipes.size();
        ChangesForChat.recipesMs = timer.stop().elapsed(TimeUnit.MILLISECONDS);
        ConsoleJS.SERVER.info("Added " + this.addedRecipes.size() + " recipes, removed " + removedRecipes.size() + " recipes, modified " + modifiedCount + " recipes, with " + this.failedCount.get() + " failed recipes in " + TimeJS.msToString(ChangesForChat.recipesMs));
        if (DataExport.export != null) {
            for (KubeRecipe r : removedRecipes) {
                DataExport.export.addJson("removed_recipes/" + r.getId() + ".json", (JsonElement)r.json);
            }
        }
        if (DevProperties.get().logRecipeDebug) {
            ConsoleJS.SERVER.info("======== Debug output of all added recipes ========");
            for (KubeRecipe r : this.addedRecipes) {
                ConsoleJS.SERVER.info(String.valueOf(r.getOrCreateId()) + ": " + String.valueOf(r.json));
            }
            ConsoleJS.SERVER.info("======== Debug output of all modified recipes ========");
            for (KubeRecipe r : this.originalRecipes.values()) {
                if (r.removed || !r.hasChanged()) continue;
                ConsoleJS.SERVER.info(String.valueOf(r.getOrCreateId()) + ": " + String.valueOf(r.json) + " FROM " + String.valueOf(r.originalJson));
            }
            ConsoleJS.SERVER.info("======== Debug output of all removed recipes ========");
            for (KubeRecipe r : removedRecipes) {
                ConsoleJS.SERVER.info(String.valueOf(r.getOrCreateId()) + ": " + String.valueOf(r.json));
            }
        }
    }

    @Nullable
    private RecipeHolder<?> createRecipe(KubeRecipe r) {
        try {
            RecipeHolder<?> rec = r.createRecipe();
            String path = r.kjs$getMod() + "/" + r.getPath();
            if (!r.removed && DataExport.export != null) {
                DataExport.export.addJson("recipes/%s.json".formatted(path), (JsonElement)r.json);
                if (r.newRecipe) {
                    DataExport.export.addJson("added_recipes/%s.json".formatted(path), (JsonElement)r.json);
                }
            }
            if (rec == null || rec.value() == null) {
                return null;
            }
            return rec;
        }
        catch (Throwable ex) {
            ConsoleJS.SERVER.warn("Error parsing recipe " + String.valueOf(r) + ": " + String.valueOf(r.json), ex, POST_SKIP_ERROR);
            this.failedCount.incrementAndGet();
            return null;
        }
    }

    private static boolean addedRecipeRemoveCheck(KubeRecipe r) {
        return !r.newRecipe;
    }

    public Map<String, Object> getRecipes() {
        return this.recipeFunctions;
    }

    public KubeRecipe addRecipe(KubeRecipe r, boolean json) {
        if (r instanceof ErroredKubeRecipe) {
            ConsoleJS.SERVER.warn("Tried to add errored recipe %s!".formatted(r));
            return r;
        }
        this.addedRecipes.add(r);
        if (DevProperties.get().logAddedRecipes) {
            ConsoleJS.SERVER.info("+ " + String.valueOf(r.getType()) + ": " + r.getFromToString() + (json ? " [json]" : ""));
        } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
            ConsoleJS.SERVER.debug("+ " + String.valueOf(r.getType()) + ": " + r.getFromToString() + (json ? " [json]" : ""));
        }
        return r;
    }

    public Stream<KubeRecipe> recipeStream(Context cx, RecipeFilter filter) {
        block5: {
            if (filter == ConstantFilter.FALSE) {
                return Stream.empty();
            }
            if (filter instanceof IDFilter) {
                IDFilter id = (IDFilter)filter;
                KubeRecipe r = this.originalRecipes.get(id.id);
                return r == null || r.removed ? Stream.empty() : Stream.of(r);
            }
            if (filter instanceof OrFilter) {
                OrFilter or = (OrFilter)filter;
                if (or.list.isEmpty()) {
                    return Stream.empty();
                }
                for (RecipeFilter recipeFilter : or.list) {
                    if (recipeFilter instanceof IDFilter) continue;
                    break block5;
                }
                return or.list.stream().map(idf -> this.originalRecipes.get(((IDFilter)idf).id)).filter(RECIPE_NOT_REMOVED);
            }
        }
        return this.originalRecipes.values().stream().filter(new RecipeStreamFilter(cx, filter));
    }

    private <T> T reduceRecipesAsync(Context cx, RecipeFilter filter, Function<Stream<KubeRecipe>, T> function) {
        return function.apply(this.recipeStream(cx, filter));
    }

    public void forEachRecipe(Context cx, RecipeFilter filter, Consumer<KubeRecipe> consumer) {
        this.recipeStream(cx, filter).forEach(consumer);
    }

    public int countRecipes(Context cx, RecipeFilter filter) {
        return this.reduceRecipesAsync(cx, filter, s -> (int)s.count());
    }

    public boolean containsRecipe(Context cx, RecipeFilter filter) {
        return this.reduceRecipesAsync(cx, filter, s -> s.findAny().isPresent());
    }

    public Collection<KubeRecipe> findRecipes(Context cx, RecipeFilter filter) {
        return this.reduceRecipesAsync(cx, filter, Stream::toList);
    }

    public Collection<ResourceLocation> findRecipeIds(Context cx, RecipeFilter filter) {
        return this.reduceRecipesAsync(cx, filter, s -> s.map(KubeRecipe::getOrCreateId).toList());
    }

    public void remove(Context cx, RecipeFilter filter) {
        if (filter instanceof IDFilter) {
            IDFilter id = (IDFilter)filter;
            KubeRecipe r = this.originalRecipes.get(id.id);
            if (r != null) {
                r.remove();
            }
        } else {
            this.forEachRecipe(cx, filter, KubeRecipe::remove);
        }
    }

    public void replaceInput(Context cx, RecipeFilter filter, ReplacementMatchInfo match, Object with) {
        String dstring = DevProperties.get().logModifiedRecipes || ConsoleJS.SERVER.shouldPrintDebug() ? ": IN " + String.valueOf(match) + " -> " + String.valueOf(with) : "";
        this.forEachRecipe(cx, filter, r -> {
            if (r.replaceInput(cx, match, with)) {
                if (DevProperties.get().logModifiedRecipes) {
                    ConsoleJS.SERVER.info("~ " + String.valueOf(r) + dstring);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + String.valueOf(r) + dstring);
                }
            }
        });
    }

    public void replaceOutput(Context cx, RecipeFilter filter, ReplacementMatchInfo match, Object with) {
        String dstring = DevProperties.get().logModifiedRecipes || ConsoleJS.SERVER.shouldPrintDebug() ? ": OUT " + String.valueOf(match) + " -> " + String.valueOf(with) : "";
        this.forEachRecipe(cx, filter, r -> {
            if (r.replaceOutput(cx, match, with)) {
                if (DevProperties.get().logModifiedRecipes) {
                    ConsoleJS.SERVER.info("~ " + String.valueOf(r) + dstring);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + String.valueOf(r) + dstring);
                }
            }
        });
    }

    public RecipeTypeFunction getRecipeFunction(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        Object object = this.recipeFunctions.get(ID.string(id));
        if (object instanceof RecipeTypeFunction) {
            RecipeTypeFunction fn = (RecipeTypeFunction)object;
            return fn;
        }
        return null;
    }

    public KubeRecipe custom(Context cx, JsonObject json) {
        try {
            if (json == null || !json.has("type")) {
                throw new KubeRuntimeException("JSON must contain 'type'!");
            }
            RecipeTypeFunction type = this.getRecipeFunction(json.get("type").getAsString());
            if (type == null) {
                throw new UnknownRecipeTypeException(json.get("type").getAsString());
            }
            KubeRecipe recipe = type.schemaType.schema.deserialize(SourceLine.of(cx), type, null, json);
            recipe.afterLoaded();
            return this.addRecipe(recipe, true);
        }
        catch (KubeRuntimeException rex) {
            ErroredKubeRecipe recipe = new ErroredKubeRecipe(this, "Failed to create custom JSON recipe from '%s'".formatted(json), rex, POST_SKIP_ERROR);
            recipe.sourceLine = rex.sourceLine;
            return recipe;
        }
    }

    private void printTypes(Predicate<RecipeSchemaType> predicate) {
        int t = 0;
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        for (RecipeNamespace ns : this.recipeSchemaStorage.namespaces.values()) {
            for (RecipeSchemaType type : ns.values()) {
                if (!predicate.test(type)) continue;
                ++t;
                ((Set)map.computeIfAbsent((Object)type.schema, s -> new HashSet())).add(type.id);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            ConsoleJS.SERVER.info("- " + ((Set)entry.getValue()).stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
            for (RecipeConstructor c : ((RecipeSchema)entry.getKey()).constructors().values()) {
                ConsoleJS.SERVER.info("  - " + String.valueOf(c));
            }
        }
        ConsoleJS.SERVER.info(t + " types");
    }

    public void printTypes(Context cx) {
        ConsoleJS.SERVER.info("== All recipe types [used] ==");
        Set set = this.reduceRecipesAsync(cx, ConstantFilter.TRUE, s -> s.map(r -> r.type.id).collect(Collectors.toSet()));
        this.printTypes((RecipeSchemaType t) -> set.contains(t.id));
    }

    public void printAllTypes() {
        ConsoleJS.SERVER.info("== All recipe types [available] ==");
        this.printTypes((RecipeSchemaType t) -> BuiltInRegistries.RECIPE_SERIALIZER.get(t.id) != null);
    }

    public void printExamples(String type) {
        List list = this.originalRecipes.values().stream().filter(recipeJS -> recipeJS.type.toString().equals(type)).collect(Collectors.toList());
        Collections.shuffle(list);
        ConsoleJS.SERVER.info("== Random examples of '" + type + "' ==");
        for (int i = 0; i < Math.min(list.size(), 5); ++i) {
            KubeRecipe r = (KubeRecipe)list.get(i);
            ConsoleJS.SERVER.info("- " + String.valueOf(r.getOrCreateId()) + ":\n" + JsonIO.toPrettyString((JsonElement)r.json));
        }
    }

    public synchronized ResourceLocation takeId(KubeRecipe recipe, String prefix, String ids) {
        int i = 2;
        ResourceLocation id = ResourceLocation.parse((String)(prefix + ids));
        while (this.takenIds.containsKey(id)) {
            id = ResourceLocation.parse((String)(prefix + ids + "_" + i));
            ++i;
        }
        this.takenIds.put(id, recipe);
        return id;
    }

    public void stage(Context cx, RecipeFilter filter, String stage) {
        this.forEachRecipe(cx, filter, r -> r.stage(stage));
    }

    private record RecipeStreamFilter(Context cx, RecipeFilter filter) implements Predicate<KubeRecipe>
    {
        @Override
        public boolean test(KubeRecipe r) {
            return r != null && !r.removed && this.filter.test(this.cx, r);
        }
    }
}

