/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonArray;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.KubeJSCodecs;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public record ListRecipeComponent<T>(RecipeComponent<T> component, boolean canWriteSelf, TypeInfo listTypeInfo, Codec<List<T>> listCodec, boolean conditional) implements RecipeComponent<List<T>>
{
    static <L> ListRecipeComponent<L> create(RecipeComponent<L> component, boolean canWriteSelf, boolean conditional) {
        Codec listCodec;
        TypeInfo typeInfo = component.typeInfo();
        Codec<L> codec = component.codec();
        Codec codec2 = listCodec = conditional ? NeoForgeExtraCodecs.listWithOptionalElements((Codec)ConditionalOps.createConditionalCodec(codec)) : codec.listOf();
        if (canWriteSelf) {
            return new ListRecipeComponent<L>(component, true, TypeInfo.RAW_LIST.withParams(new TypeInfo[]{typeInfo}).or(typeInfo), KubeJSCodecs.listOfOrSelf(listCodec, codec), conditional);
        }
        return new ListRecipeComponent<L>(component, false, TypeInfo.RAW_LIST.withParams(new TypeInfo[]{typeInfo}), listCodec, conditional);
    }

    @Override
    public Codec<List<T>> codec() {
        return this.listCodec;
    }

    @Override
    public TypeInfo typeInfo() {
        return this.listTypeInfo;
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        return from instanceof Iterable || from != null && from.getClass().isArray();
    }

    @Override
    public List<T> wrap(Context cx, KubeRecipe recipe, Object from) {
        if (from instanceof Iterable) {
            int size;
            Iterable iterable = (Iterable)from;
            if (iterable instanceof Collection) {
                Collection c = (Collection)iterable;
                size = c.size();
            } else if (iterable instanceof JsonArray) {
                JsonArray a = (JsonArray)iterable;
                size = a.size();
            } else {
                size = -1;
            }
            if (size == 0) {
                return List.of();
            }
            if (size == 1) {
                return List.of(this.component.wrap(cx, recipe, iterable.iterator().next()));
            }
            if (size == 2) {
                Iterator itr = iterable.iterator();
                return List.of(this.component.wrap(cx, recipe, itr.next()), this.component.wrap(cx, recipe, itr.next()));
            }
            if (size > 0) {
                ArrayList<T> arr = new ArrayList<T>(size);
                for (Object e : iterable) {
                    arr.add(this.component.wrap(cx, recipe, e));
                }
                return arr;
            }
            ArrayList<T> list = new ArrayList<T>();
            for (Object e : iterable) {
                list.add(this.component.wrap(cx, recipe, e));
            }
            return list;
        }
        if (from.getClass().isArray()) {
            int length = Array.getLength(from);
            if (length == 0) {
                return List.of();
            }
            ArrayList<T> arr = new ArrayList<T>(length);
            for (int i = 0; i < length; ++i) {
                arr.add(this.component.wrap(cx, recipe, Array.get(from, i)));
            }
            return arr;
        }
        return List.of(this.component.wrap(cx, recipe, from));
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, List<T> value, ReplacementMatchInfo match) {
        for (T v : value) {
            if (!this.component.matches(cx, recipe, v, match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> replace(Context cx, KubeRecipe recipe, List<T> original, ReplacementMatchInfo match, Object with) {
        List<T> arr = original;
        for (int i = 0; i < original.size(); ++i) {
            T r = this.component.replace(cx, recipe, original.get(i), match, with);
            if (arr.get(i) == r) continue;
            if (arr == original) {
                arr = new ArrayList<T>(original);
            }
            if (arr == original) continue;
            arr.set(i, r);
        }
        return arr;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, List<T> value) {
        for (int i = 0; i < value.size(); ++i) {
            if (i > 0) {
                builder.appendSeparator();
            }
            this.component.buildUniqueId(builder, value.get(i));
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.component) + (this.canWriteSelf ? "[?]" : "[]") + (this.conditional ? "?" : "");
    }

    @Override
    public boolean isEmpty(List<T> value) {
        return value.isEmpty();
    }
}

