/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.kubejs.util.StringReaderFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.util.Mth;

public interface NumberComponent<S, T extends Number>
extends RecipeComponent<T> {
    public static final IntRange INT = new IntRange(Integer.MIN_VALUE, Integer.MAX_VALUE, (Codec<Integer>)Codec.INT);
    public static final LongRange LONG = new LongRange(Long.MIN_VALUE, Long.MAX_VALUE, (Codec<Long>)Codec.LONG);
    public static final FloatRange FLOAT = new FloatRange(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), (Codec<Float>)Codec.FLOAT);
    public static final DoubleRange DOUBLE = new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, (Codec<Double>)Codec.DOUBLE);
    public static final RecipeComponentFactory INT_FACTORY = NumberComponent.createFactory(0, INT, StringReader::readInt);
    public static final RecipeComponentFactory LONG_FACTORY = NumberComponent.createFactory(0L, LONG, StringReader::readLong);
    public static final RecipeComponentFactory FLOAT_FACTORY = NumberComponent.createFactory(Float.valueOf(0.0f), FLOAT, StringReader::readFloat);
    public static final RecipeComponentFactory DOUBLE_FACTORY = NumberComponent.createFactory(0.0, DOUBLE, StringReader::readDouble);

    public static IntRange intRange(int min, int max) {
        return INT.range(min, max);
    }

    public static LongRange longRange(long min, long max) {
        return LONG.range(min, max);
    }

    public static FloatRange floatRange(float min, float max) {
        return FLOAT.range(Float.valueOf(min), Float.valueOf(max));
    }

    public static DoubleRange doubleRange(double min, double max) {
        return DOUBLE.range(min, max);
    }

    public static <T extends Number> RecipeComponentFactory createFactory(T zero, NumberComponent<?, T> range, StringReaderFunction<T> numFunc) {
        return (registries, storage, reader) -> {
            Number num1;
            reader.skipWhitespace();
            if (!reader.canRead() || reader.peek() != '<') {
                return range;
            }
            reader.skip();
            reader.skipWhitespace();
            if (reader.peek() == 'm') {
                if (!reader.readUnquotedString().equals("min")) {
                    throw new IllegalStateException("Expected 'min'!");
                }
                num1 = range.min();
            } else {
                num1 = (Number)numFunc.read(reader);
            }
            reader.skipWhitespace();
            Number num2 = null;
            if (reader.peek() == ',') {
                reader.skip();
                reader.skipWhitespace();
                if (reader.peek() == 'm') {
                    if (!reader.readUnquotedString().equals("max")) {
                        throw new IllegalStateException("Expected 'max'!");
                    }
                    num2 = range.max();
                } else {
                    num2 = (Number)numFunc.read(reader);
                }
                reader.skipWhitespace();
            }
            reader.expect('>');
            if (num2 == null) {
                return range.range(zero, num1);
            }
            if (num1.equals(range.min()) && num2.equals(range.max())) {
                return range;
            }
            return range.range(num1, num2);
        };
    }

    private static Number numberOf(Object from) {
        if (from instanceof Number) {
            Number n = (Number)from;
            return n;
        }
        if (from instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)from;
            return json.getAsNumber();
        }
        if (from instanceof CharSequence) {
            return Double.parseDouble(from.toString());
        }
        throw new IllegalStateException("Expected a number!");
    }

    @Override
    default public TypeInfo typeInfo() {
        return TypeInfo.NUMBER;
    }

    @Override
    default public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        JsonPrimitive json;
        return from instanceof Number || from instanceof JsonPrimitive && (json = (JsonPrimitive)from).isNumber();
    }

    public T min();

    public T max();

    public NumberComponent<S, T> range(T var1, T var2);

    default public NumberComponent<S, T> min(T min) {
        return this.range(min, this.max());
    }

    default public NumberComponent<S, T> max(T max) {
        return this.range(this.min(), max);
    }

    public static final class IntRange
    extends Record
    implements NumberComponent<IntRange, Integer> {
        private final Integer min;
        private final Integer max;
        private final Codec<Integer> codec;

        public IntRange(Integer min, Integer max, Codec<Integer> codec) {
            this.min = min;
            this.max = max;
            this.codec = codec;
        }

        @Override
        public Codec<Integer> codec() {
            return this.codec;
        }

        @Override
        public TypeInfo typeInfo() {
            return TypeInfo.INT;
        }

        @Override
        public Integer wrap(Context cx, KubeRecipe recipe, Object from) {
            return Mth.clamp((int)NumberComponent.numberOf(from).intValue(), (int)this.min, (int)this.max);
        }

        public IntRange range(Integer min, Integer max) {
            return new IntRange(min, max, (Codec<Integer>)Codec.intRange((int)min, (int)max));
        }

        @Override
        public String toString() {
            return "int";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntRange.class, "min;max;codec", "min", "max", "codec"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntRange.class, "min;max;codec", "min", "max", "codec"}, this, o);
        }

        @Override
        public Integer min() {
            return this.min;
        }

        @Override
        public Integer max() {
            return this.max;
        }
    }

    public static final class LongRange
    extends Record
    implements NumberComponent<LongRange, Long> {
        private final Long min;
        private final Long max;
        private final Codec<Long> codec;

        public LongRange(Long min, Long max, Codec<Long> codec) {
            this.min = min;
            this.max = max;
            this.codec = codec;
        }

        @Override
        public Codec<Long> codec() {
            return this.codec;
        }

        @Override
        public TypeInfo typeInfo() {
            return TypeInfo.LONG;
        }

        @Override
        public Long wrap(Context cx, KubeRecipe recipe, Object from) {
            long val = NumberComponent.numberOf(from).longValue();
            return val < this.min ? this.min : Math.min(val, this.max);
        }

        public LongRange range(Long min, Long max) {
            Function checker = Codec.checkRange((Number)min, (Number)max);
            return new LongRange(min, max, (Codec<Long>)Codec.LONG.flatXmap(checker, checker));
        }

        @Override
        public String toString() {
            return "long";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LongRange.class, "min;max;codec", "min", "max", "codec"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LongRange.class, "min;max;codec", "min", "max", "codec"}, this, o);
        }

        @Override
        public Long min() {
            return this.min;
        }

        @Override
        public Long max() {
            return this.max;
        }
    }

    public static final class FloatRange
    extends Record
    implements NumberComponent<FloatRange, Float> {
        private final Float min;
        private final Float max;
        private final Codec<Float> codec;

        public FloatRange(Float min, Float max, Codec<Float> codec) {
            this.min = min;
            this.max = max;
            this.codec = codec;
        }

        @Override
        public Codec<Float> codec() {
            return this.codec;
        }

        @Override
        public TypeInfo typeInfo() {
            return TypeInfo.FLOAT;
        }

        @Override
        public Float wrap(Context cx, KubeRecipe recipe, Object from) {
            return Float.valueOf(Mth.clamp((float)NumberComponent.numberOf(from).floatValue(), (float)this.min.floatValue(), (float)this.max.floatValue()));
        }

        public FloatRange range(Float min, Float max) {
            return new FloatRange(min, max, (Codec<Float>)Codec.floatRange((float)min.floatValue(), (float)max.floatValue()));
        }

        @Override
        public String toString() {
            return "float";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatRange.class, "min;max;codec", "min", "max", "codec"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatRange.class, "min;max;codec", "min", "max", "codec"}, this, o);
        }

        @Override
        public Float min() {
            return this.min;
        }

        @Override
        public Float max() {
            return this.max;
        }
    }

    public static final class DoubleRange
    extends Record
    implements NumberComponent<DoubleRange, Double> {
        private final Double min;
        private final Double max;
        private final Codec<Double> codec;

        public DoubleRange(Double min, Double max, Codec<Double> codec) {
            this.min = min;
            this.max = max;
            this.codec = codec;
        }

        @Override
        public Codec<Double> codec() {
            return this.codec;
        }

        @Override
        public TypeInfo typeInfo() {
            return TypeInfo.DOUBLE;
        }

        @Override
        public Double wrap(Context cx, KubeRecipe recipe, Object from) {
            return Mth.clamp((double)NumberComponent.numberOf(from).doubleValue(), (double)this.min, (double)this.max);
        }

        public DoubleRange range(Double min, Double max) {
            return new DoubleRange(min, max, (Codec<Double>)Codec.doubleRange((double)min, (double)max));
        }

        @Override
        public String toString() {
            return "double";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleRange.class, "min;max;codec", "min", "max", "codec"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleRange.class, "min;max;codec", "min", "max", "codec"}, this, o);
        }

        @Override
        public Double min() {
            return this.min;
        }

        @Override
        public Double max() {
            return this.max;
        }
    }
}

