/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeTypeFunction;
import dev.latvian.mods.kubejs.recipe.component.ComponentValueMap;
import dev.latvian.mods.kubejs.recipe.schema.RecipeOptional;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.Context;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RecipeConstructor {
    public final List<RecipeKey<?>> keys;
    public Map<RecipeKey<?>, RecipeOptional<?>> overrides;

    public RecipeConstructor(List<RecipeKey<?>> keys) {
        this.keys = keys;
        this.overrides = Map.of();
    }

    public RecipeConstructor(RecipeKey<?> ... keys) {
        this(List.of(keys));
    }

    public <T> RecipeConstructor override(RecipeKey<T> key, RecipeOptional<T> value) {
        if (this.overrides.isEmpty()) {
            this.overrides = new Reference2ObjectOpenHashMap(1);
        }
        this.overrides.put(key, value);
        return this;
    }

    public <T> RecipeConstructor overrideValue(RecipeKey<T> key, T value) {
        return this.override(key, new RecipeOptional.Constant<T>(value));
    }

    public RecipeConstructor overrides(Map<RecipeKey<?>, RecipeOptional<?>> map) {
        this.overrides = map;
        return this;
    }

    public String toString() {
        return this.keys.stream().map(RecipeKey::toString).collect(Collectors.joining(", ", "(", ")"));
    }

    public KubeRecipe create(Context cx, SourceLine sourceLine, RecipeTypeFunction type, RecipeSchemaType schemaType, ComponentValueMap from) {
        KubeRecipe r = schemaType.schema.recipeFactory.create();
        r.sourceLine = sourceLine;
        r.type = type;
        r.json = new JsonObject();
        r.json.addProperty("type", "unknown");
        r.newRecipe = true;
        r.initValues(true);
        this.setValues(cx, r, schemaType, from);
        return r;
    }

    public void setValues(Context cx, KubeRecipe recipe, RecipeSchemaType schemaType, ComponentValueMap from) {
        for (RecipeKey<?> recipeKey : this.keys) {
            recipe.setValue(recipeKey, Cast.to(from.getValue(cx, recipe, recipeKey)));
        }
        for (Map.Entry entry : this.overrides.entrySet()) {
            recipe.setValue((RecipeKey)entry.getKey(), Cast.to(((RecipeOptional)entry.getValue()).getDefaultValue(schemaType)));
        }
        for (Map.Entry entry : schemaType.schema.keyOverrides.entrySet()) {
            recipe.setValue((RecipeKey)entry.getKey(), Cast.to(((RecipeOptional)entry.getValue()).getDefaultValue(schemaType)));
        }
    }
}

