/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class RecipeSchemaType {
    public final RecipeNamespace namespace;
    public final ResourceLocation id;
    public final RecipeSchema schema;
    public RecipeSchemaType parent;
    protected Optional<RecipeSerializer<?>> serializer;

    public RecipeSchemaType(RecipeNamespace namespace, ResourceLocation id, RecipeSchema schema) {
        this.namespace = namespace;
        this.id = id;
        this.schema = schema;
    }

    public RecipeSerializer<?> getSerializer() {
        RecipeSerializer s;
        ResourceLocation serializerId;
        ResourceLocation resourceLocation = serializerId = this.schema.typeOverride == null ? this.id : this.schema.typeOverride;
        if (this.serializer == null) {
            this.serializer = Optional.ofNullable((RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.get(serializerId));
        }
        if ((s = (RecipeSerializer)this.serializer.orElse(null)) == null) {
            throw new KubeRuntimeException("Serializer for type " + String.valueOf(serializerId) + " is not found!");
        }
        return s;
    }

    public String toString() {
        return this.id.toString();
    }
}

