/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.util.Cast;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class RegistryObjectStorage<T>
implements Iterable<BuilderBase<? extends T>> {
    private static final Object LOCK = new Object();
    private static final Map<ResourceKey<? extends Registry<?>>, RegistryObjectStorage<?>> MAP = new Reference2ObjectOpenHashMap();
    public static final List<BuilderBase<?>> ALL_BUILDERS = new LinkedList();
    public static final Codec<RegistryObjectStorage<?>> CODEC = ResourceLocation.CODEC.xmap(rl -> RegistryObjectStorage.of(ResourceKey.createRegistryKey((ResourceLocation)rl)), ri -> ri.key.location());
    public static final RegistryObjectStorage<Fluid> FLUID = RegistryObjectStorage.of(Registries.FLUID);
    public static final RegistryObjectStorage<Block> BLOCK = RegistryObjectStorage.of(Registries.BLOCK);
    public static final RegistryObjectStorage<Item> ITEM = RegistryObjectStorage.of(Registries.ITEM);
    public static final RegistryObjectStorage<FluidType> FLUID_TYPE = RegistryObjectStorage.of(NeoForgeRegistries.Keys.FLUID_TYPES);
    public final ResourceKey<Registry<T>> key;
    public final Map<ResourceLocation, BuilderBase<? extends T>> objects;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> RegistryObjectStorage<T> of(ResourceKey<Registry<T>> key) {
        Object object = LOCK;
        synchronized (object) {
            return (RegistryObjectStorage)Cast.to(MAP.computeIfAbsent(key, RegistryObjectStorage::new));
        }
    }

    private RegistryObjectStorage(ResourceKey key) {
        this.key = key;
        this.objects = new LinkedHashMap<ResourceLocation, BuilderBase<? extends T>>();
    }

    @Override
    @NotNull
    public Iterator<BuilderBase<? extends T>> iterator() {
        return this.objects.values().iterator();
    }

    public String toString() {
        return this.key.location().toString();
    }
}

