/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.rhino.type.TypeInfo;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.Nullable;

public record RegistryType<T>(ResourceKey<Registry<T>> key, Class<?> baseClass, TypeInfo type) {
    private static final Map<ResourceKey<?>, RegistryType<?>> KEY_MAP = new Reference2ObjectOpenHashMap();
    private static final Map<TypeInfo, RegistryType<?>> TYPE_MAP = new HashMap();
    private static final Map<Class<?>, List<RegistryType<?>>> CLASS_MAP = new Reference2ObjectOpenHashMap();

    public static synchronized void init() {
        try {
            for (Field field : Registries.class.getDeclaredFields()) {
                ParameterizedType t1;
                Type type;
                if (field.getType() != ResourceKey.class || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !((type = field.getGenericType()) instanceof ParameterizedType) || !((type = (t1 = (ParameterizedType)type).getActualTypeArguments()[0]) instanceof ParameterizedType)) continue;
                ParameterizedType t2 = (ParameterizedType)type;
                ResourceKey key = (ResourceKey)field.get(null);
                Type type2 = t2.getActualTypeArguments()[0];
                TypeInfo typeInfo = TypeInfo.of((Type)type2);
                RegistryType.register(key, typeInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized <T> void register(ResourceKey<Registry<T>> key, TypeInfo type) {
        RegistryType<T> t = new RegistryType<T>(key, type.asClass(), type);
        KEY_MAP.put(key, t);
        TYPE_MAP.put(type, t);
        CLASS_MAP.computeIfAbsent(t.baseClass, c -> new ArrayList(1)).add(t);
        if (DevProperties.get().logRegistryTypes) {
            KubeJS.LOGGER.info("Registered RegistryType '" + String.valueOf(key.location()) + "': " + String.valueOf(type));
        }
    }

    @Nullable
    public static synchronized RegistryType<?> ofKey(ResourceKey<?> key) {
        return KEY_MAP.get(key);
    }

    @Nullable
    public static synchronized RegistryType<?> ofType(TypeInfo typeInfo) {
        return TYPE_MAP.get(typeInfo);
    }

    @Nullable
    public static synchronized RegistryType<?> ofClass(Class<?> type) {
        List<RegistryType<?>> list = CLASS_MAP.get(type);
        return list != null && list.size() == 1 ? list.getFirst() : null;
    }

    public static synchronized List<RegistryType<?>> allOfClass(Class<?> type) {
        return CLASS_MAP.getOrDefault(type, List.of());
    }

    @Nullable
    public static synchronized RegistryType<?> lookup(TypeInfo target) {
        List<RegistryType<?>> reg = RegistryType.allOfClass(target.asClass());
        if (reg.size() == 1) {
            return reg.getFirst();
        }
        if (!reg.isEmpty()) {
            for (RegistryType<?> regType : reg) {
                if (!regType.type().equals((Object)target)) continue;
                return regType;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.key.location()) + "=" + String.valueOf(this.type);
    }
}

