/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.plugin.ClassFilter;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.KubeJSContextFactory;
import dev.latvian.mods.kubejs.script.KubeJSFileWatcherThread;
import dev.latvian.mods.kubejs.script.PlatformWrapper;
import dev.latvian.mods.kubejs.script.ScriptFile;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.TypeWrapperRegistry;
import dev.latvian.mods.kubejs.util.LogType;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ScriptManager {
    public final ScriptType scriptType;
    public final Map<String, ScriptPack> packs;
    private final ClassFilter classFilter;
    public KubeJSContextFactory contextFactory;
    public boolean canListenEvents;

    public ScriptManager(ScriptType t) {
        this.scriptType = t;
        this.packs = new LinkedHashMap<String, ScriptPack>();
        this.classFilter = KubeJSPlugins.createClassFilter(this.scriptType);
    }

    public RegistryAccessContainer getRegistries() {
        return RegistryAccessContainer.current;
    }

    public void unload() {
        this.packs.clear();
        this.scriptType.unload();
    }

    public void reload() {
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::clearCaches);
        this.unload();
        this.scriptType.console.writeToFile(LogType.INIT, "KubeJS " + KubeJS.VERSION + "; MC 2006 NeoForge");
        this.scriptType.console.writeToFile(LogType.INIT, "Loaded plugins:");
        for (KubeJSPlugin plugin : KubeJSPlugins.getAll()) {
            this.scriptType.console.writeToFile(LogType.INIT, "- " + plugin.getClass().getName());
        }
        KubeJSPlugins.forEachPlugin(this, KubeJSPlugin::beforeScriptsLoaded);
        this.loadFromDirectory();
        this.load();
        KubeJSPlugins.forEachPlugin(this, KubeJSPlugin::afterScriptsLoaded);
    }

    public void collectScripts(ScriptPack pack, Path dir, String path) {
        if (!((String)path).isEmpty() && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        String pathPrefix = path;
        try {
            for (Path file : Files.walk(dir, 10, FileVisitOption.FOLLOW_LINKS).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList()) {
                String fileName = dir.relativize(file).toString().replace(File.separatorChar, '/');
                if (!fileName.endsWith(".js") && (!fileName.endsWith(".ts") || fileName.endsWith(".d.ts"))) continue;
                pack.info.scripts.add(new ScriptFileInfo(pack.info, file, pathPrefix + fileName));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void loadPackFromDirectory(Path path, String name, boolean exampleFile) {
        if (Files.notExists(path, new LinkOption[0])) {
            if (!exampleFile) {
                return;
            }
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                this.scriptType.console.error("Failed to create script directory", ex);
            }
            try (OutputStream out = Files.newOutputStream(path.resolve("main.js"), new OpenOption[0]);){
                out.write(("// Visit the wiki for more info - https://kubejs.com/\nconsole.info('Hello, World! (Loaded " + name + " example script)')\n\n").getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception ex) {
                this.scriptType.console.error("Failed to write main.js", ex);
            }
        }
        ScriptPack pack = new ScriptPack(this, new ScriptPackInfo(path.getFileName().toString(), ""));
        if (Files.exists(path, new LinkOption[0])) {
            this.collectScripts(pack, path, "");
            for (ScriptFileInfo fileInfo : pack.info.scripts) {
                this.loadFile(pack, fileInfo);
            }
            pack.scripts.sort(null);
        }
        this.packs.put(pack.info.namespace, pack);
    }

    private void loadFile(ScriptPack pack, ScriptFileInfo fileInfo) {
        try {
            ScriptFile file = new ScriptFile(pack, fileInfo);
            String skip = file.skipLoading();
            if (skip.isEmpty()) {
                pack.scripts.add(file);
            } else {
                this.scriptType.console.info("Skipped " + fileInfo.location + ": " + skip);
            }
        }
        catch (Throwable error) {
            this.scriptType.console.error("Failed to pre-load script file '" + fileInfo.location + "'", error);
        }
    }

    public void loadFromDirectory() {
        this.loadPackFromDirectory(this.scriptType.path, this.scriptType.name, true);
    }

    public boolean isClassAllowed(String name) {
        return this.classFilter.isAllowed(name);
    }

    private void load() {
        long startAll = System.currentTimeMillis();
        this.contextFactory = new KubeJSContextFactory(this);
        this.scriptType.console.contextFactory = new WeakReference<KubeJSContextFactory>(this.contextFactory);
        if (PlatformWrapper.isGeneratingData()) {
            this.scriptType.console.info("Skipping KubeJS script loading (DataGen)");
            return;
        }
        this.canListenEvents = true;
        TypeWrapperRegistry typeWrappers = new TypeWrapperRegistry(this.scriptType, this.contextFactory.getTypeWrappers());
        for (KubeJSPlugin plugin : KubeJSPlugins.getAll()) {
            plugin.registerTypeWrappers(typeWrappers);
        }
        int i = 0;
        int t = 0;
        KubeJSContext cx = (KubeJSContext)this.contextFactory.enter();
        ArrayList<ScriptFile> watchingFiles = new ArrayList<ScriptFile>();
        for (ScriptPack pack : this.packs.values()) {
            try {
                for (ScriptFile file : pack.scripts) {
                    ++t;
                    long start = System.currentTimeMillis();
                    try {
                        file.load(cx);
                        ++i;
                        this.scriptType.console.info("Loaded script " + file.info.location + " in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " s");
                        watchingFiles.add(file);
                    }
                    catch (Throwable ex) {
                        this.scriptType.console.error("", ex);
                    }
                }
            }
            catch (Throwable ex) {
                this.scriptType.console.error("Failed to read script pack " + pack.info.namespace, ex);
            }
        }
        this.loadAdditional();
        this.scriptType.console.info("Loaded " + i + "/" + t + " KubeJS " + this.scriptType.name + " scripts in " + (double)(System.currentTimeMillis() - startAll) / 1000.0 + " s with " + this.scriptType.console.errors.size() + " errors and " + this.scriptType.console.warnings.size() + " warnings");
        this.canListenEvents = false;
        if (!watchingFiles.isEmpty() && DevProperties.get().reloadOnFileSave) {
            this.scriptType.fileWatcherThread = new KubeJSFileWatcherThread(this.scriptType, watchingFiles.toArray(new ScriptFile[0]), this::fullReload);
            this.scriptType.fileWatcherThread.start();
        }
    }

    public void loadAdditional() {
    }

    protected void fullReload() {
        KubeJS.PROXY.runInMainThread(this::reload);
    }
}

