/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.core.RecipeManagerKJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.net.KubeServerData;
import dev.latvian.mods.kubejs.net.SyncServerDataPayload;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.recipe.CachedTagLookup;
import dev.latvian.mods.kubejs.recipe.CompostableRecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.recipe.special.SpecialRecipeSerializerManager;
import dev.latvian.mods.kubejs.registry.AdditionalObjectRegistry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryObjectStorage;
import dev.latvian.mods.kubejs.registry.ServerRegistryKubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.script.data.GeneratedDataStage;
import dev.latvian.mods.kubejs.script.data.KubeFileResourcePack;
import dev.latvian.mods.kubejs.script.data.VirtualDataPack;
import dev.latvian.mods.kubejs.server.tag.PreTagKubeEvent;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ServerScriptManager
extends ScriptManager {
    private static ServerScriptManager staticInstance;
    public final Map<ResourceKey<?>, PreTagKubeEvent> preTagEvents = new ConcurrentHashMap();
    public final RecipeSchemaStorage recipeSchemaStorage = new RecipeSchemaStorage();
    public SyncServerDataPayload serverData = null;
    public final VirtualDataPack internalDataPack = new VirtualDataPack(GeneratedDataStage.INTERNAL);
    public final VirtualDataPack registriesDataPack = new VirtualDataPack(GeneratedDataStage.REGISTRIES);
    public final Map<GeneratedDataStage, VirtualDataPack> virtualPacks = GeneratedDataStage.forScripts(VirtualDataPack::new);
    public boolean firstLoad = true;

    public static List<PackResources> createPackResources(List<PackResources> original) {
        ArrayList<PackResources> packs = new ArrayList<PackResources>(original);
        ArrayList<PackResources> filePacks = new ArrayList<PackResources>();
        KubeFileResourcePack.scanAndLoad(KubeJSPaths.DATA, filePacks);
        filePacks.sort((p1, p2) -> p1.packId().compareToIgnoreCase(p2.packId()));
        filePacks.add(new KubeFileResourcePack(PackType.SERVER_DATA));
        int beforeModsIndex = KubeFileResourcePack.findBeforeModsIndex(packs);
        int afterModsIndex = KubeFileResourcePack.findAfterModsIndex(packs);
        ServerScriptManager manager = new ServerScriptManager();
        packs.add(beforeModsIndex, manager.virtualPacks.get((Object)GeneratedDataStage.BEFORE_MODS));
        packs.add(afterModsIndex, manager.internalDataPack);
        packs.add(afterModsIndex + 1, manager.registriesDataPack);
        packs.add(afterModsIndex + 2, manager.virtualPacks.get((Object)GeneratedDataStage.AFTER_MODS));
        packs.addAll(afterModsIndex + 3, filePacks);
        packs.add(manager.virtualPacks.get((Object)GeneratedDataStage.LAST));
        manager.reload();
        staticInstance = manager;
        if (!FMLLoader.isProduction()) {
            KubeJS.LOGGER.info("Loaded " + packs.size() + " data packs: " + packs.stream().map(PackResources::packId).collect(Collectors.joining(", ")));
        }
        return packs;
    }

    public static ServerScriptManager release() {
        ServerScriptManager instance = Objects.requireNonNull(staticInstance);
        staticInstance = null;
        return instance;
    }

    private ServerScriptManager() {
        super(ScriptType.SERVER);
        try {
            if (Files.notExists(KubeJSPaths.DATA, new LinkOption[0])) {
                Files.createDirectories(KubeJSPaths.DATA, new FileAttribute[0]);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("KubeJS failed to register it's script loader!", ex);
        }
    }

    @Override
    public void loadFromDirectory() {
        ConsoleJS.SERVER.startCapturingErrors();
        super.loadFromDirectory();
        if (FMLLoader.getDist().isDedicatedServer()) {
            this.loadPackFromDirectory(KubeJSPaths.LOCAL_SERVER_SCRIPTS, "local server", true);
        }
    }

    @Override
    public void loadAdditional() {
        for (BuilderBase<?> builder : RegistryObjectStorage.ALL_BUILDERS) {
            builder.generateData(this.internalDataPack);
        }
        KubeJSPlugins.forEachPlugin(this.internalDataPack, KubeJSPlugin::generateData);
        if (this.firstLoad) {
            this.firstLoad = false;
            if (ServerEvents.REGISTRY.hasListeners()) {
                ArrayList builders = new ArrayList();
                RegistryOps<JsonElement> ops = RegistryAccessContainer.current.json();
                Reference2ObjectOpenHashMap codecs = new Reference2ObjectOpenHashMap();
                for (RegistryDataLoader.RegistryData registryData : DataPackRegistriesHooks.getDataPackRegistries()) {
                    ResourceKey key = registryData.key();
                    codecs.put((Object)key, (Object)registryData.elementCodec());
                    if (!ServerEvents.REGISTRY.hasListeners(key)) continue;
                    ServerEvents.REGISTRY.post(ScriptType.SERVER, key, new ServerRegistryKubeEvent(key, (DynamicOps<JsonElement>)ops, registryData.elementCodec(), builders));
                }
                for (BuilderBase builderBase : List.copyOf(builders)) {
                    builderBase.createAdditionalObjects(new AdditionalServerRegistryHandler(builderBase.sourceLine, builders));
                }
                for (BuilderBase builderBase : builders) {
                    builderBase.generateData(this.registriesDataPack);
                }
                for (BuilderBase builderBase : builders) {
                    if (builderBase.registryKey == null) {
                        ConsoleJS.SERVER.error("", new KubeRuntimeException("Failed to register object '" + String.valueOf(builderBase.id) + "' - unknown registry").source(builderBase.sourceLine));
                        continue;
                    }
                    try {
                        Codec codec = (Codec)codecs.get(builderBase.registryKey);
                        if (codec == null) {
                            throw new KubeRuntimeException("Don't know how to encode '" + String.valueOf(builderBase.id) + "' of '" + String.valueOf(builderBase.registryKey.location()) + "'!").source(builderBase.sourceLine);
                        }
                        Object obj = builderBase.createTransformedObject();
                        JsonElement json = (JsonElement)codec.encodeStart(ops, Cast.to(obj)).getOrThrow();
                        ResourceLocation k = builderBase.registryKey.location();
                        if (k.getNamespace().equals("minecraft")) {
                            this.registriesDataPack.json(ResourceLocation.fromNamespaceAndPath((String)builderBase.id.getNamespace(), (String)(k.getPath() + "/" + builderBase.id.getPath())), json);
                            continue;
                        }
                        this.registriesDataPack.json(ResourceLocation.fromNamespaceAndPath((String)builderBase.id.getNamespace(), (String)(k.getNamespace() + "/" + k.getPath() + "/" + builderBase.id.getPath())), json);
                    }
                    catch (Exception ex) {
                        ConsoleJS.SERVER.error("", new KubeRuntimeException("Failed to register object '" + String.valueOf(builderBase.id) + "' of registry '" + String.valueOf(builderBase.registryKey.location()) + "'!", ex).source(builderBase.sourceLine));
                    }
                }
            }
        }
    }

    @Override
    public void reload() {
        this.internalDataPack.reset();
        for (VirtualDataPack pack : this.virtualPacks.values()) {
            pack.reset();
        }
        this.serverData = null;
        super.reload();
        PreTagKubeEvent.handle(this.preTagEvents);
        for (VirtualDataPack pack : this.virtualPacks.values()) {
            if (!ServerEvents.GENERATE_DATA.hasListeners(pack.stage)) continue;
            ServerEvents.GENERATE_DATA.post(ScriptType.SERVER, pack.stage, pack);
        }
    }

    public boolean recipes(RecipeManagerKJS recipeManager, ResourceManager resourceManager, Map<ResourceLocation, JsonElement> map) {
        if (ServerEvents.COMPOSTABLE_RECIPES.hasListeners()) {
            ServerEvents.COMPOSTABLE_RECIPES.post(ScriptType.SERVER, new CompostableRecipesKubeEvent());
        }
        boolean result = false;
        for (CachedTagLookup.Entry<?> entry : this.getRegistries().cachedRegistryTags.values()) {
            if (entry.registry() == null || entry.lookup() == null) continue;
            entry.registry().bindTags(entry.lookup().bindingMap());
        }
        this.recipeSchemaStorage.fireEvents(this.getRegistries(), resourceManager);
        SpecialRecipeSerializerManager.INSTANCE.reset();
        ServerEvents.SPECIAL_RECIPES.post(ScriptType.SERVER, SpecialRecipeSerializerManager.INSTANCE);
        if (ServerEvents.RECIPES.hasListeners()) {
            new RecipesKubeEvent(this).post(recipeManager, new HashMap<ResourceLocation, JsonElement>(map));
            result = true;
        }
        this.serverData = new SyncServerDataPayload(KubeServerData.collect());
        return result;
    }

    @Override
    protected void fullReload() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.execute(() -> server.kjs$runCommand("reload"));
        }
    }

    public void reloadAndCapture() {
        this.reload();
        staticInstance = this;
    }

    private record AdditionalServerRegistryHandler(SourceLine sourceLine, List<BuilderBase<?>> builders) implements AdditionalObjectRegistry
    {
        @Override
        public <T> void add(ResourceKey<Registry<T>> registry, BuilderBase<? extends T> builder) {
            builder.sourceLine = this.sourceLine;
            builder.registryKey = registry;
            this.builders.add(builder);
        }
    }
}

