/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import dev.latvian.mods.kubejs.util.JsonSerializable;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public interface JsonUtils {
    @HideFromJS
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();

    public static JsonElement copy(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return JsonNull.INSTANCE;
        }
        if (element instanceof JsonArray) {
            JsonArray a = new JsonArray();
            for (JsonElement e : (JsonArray)element) {
                a.add(JsonUtils.copy(e));
            }
            return a;
        }
        if (element instanceof JsonObject) {
            JsonObject o = new JsonObject();
            for (Map.Entry entry : ((JsonObject)element).entrySet()) {
                o.add((String)entry.getKey(), JsonUtils.copy((JsonElement)entry.getValue()));
            }
            return o;
        }
        return element;
    }

    public static JsonElement of(Context cx, @Nullable Object o) {
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonElement.class, JsonSerializable.class, CharSequence.class, Boolean.class, Number.class, Character.class, Map.class, CompoundTag.class, Collection.class}, (Object)object, n)) {
            case 0 -> {
                JsonElement e = (JsonElement)object;
                yield e;
            }
            case 1 -> {
                JsonSerializable s = (JsonSerializable)object;
                yield s.toJson(cx);
            }
            case 2 -> {
                CharSequence ignore = (CharSequence)object;
                yield new JsonPrimitive(o.toString());
            }
            case 3 -> {
                Boolean b = (Boolean)object;
                yield new JsonPrimitive(b);
            }
            case 4 -> {
                Number n = (Number)object;
                yield new JsonPrimitive(n);
            }
            case 5 -> {
                Character c = (Character)object;
                yield new JsonPrimitive(c);
            }
            case 6 -> {
                Map map = (Map)object;
                yield MapJS.json(cx, map);
            }
            case 7 -> {
                CompoundTag tag = (CompoundTag)object;
                yield MapJS.json(cx, tag);
            }
            case 8 -> {
                Collection c = (Collection)object;
                yield ListJS.json(cx, c);
            }
            default -> JsonNull.INSTANCE;
        };
    }

    public static JsonPrimitive primitiveOf(Context cx, @Nullable Object o) {
        JsonPrimitive p;
        JsonElement jsonElement = JsonUtils.of(cx, o);
        return jsonElement instanceof JsonPrimitive ? (p = (JsonPrimitive)jsonElement) : null;
    }

    @Nullable
    public static Object toObject(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return null;
        }
        if (json.isJsonObject()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            JsonObject o = json.getAsJsonObject();
            for (Map.Entry entry : o.entrySet()) {
                map.put((String)entry.getKey(), JsonUtils.toObject((JsonElement)entry.getValue()));
            }
            return map;
        }
        if (json.isJsonArray()) {
            JsonArray a = json.getAsJsonArray();
            ArrayList<Object> objects = new ArrayList<Object>(a.size());
            for (JsonElement e : a) {
                objects.add(JsonUtils.toObject(e));
            }
            return objects;
        }
        return JsonUtils.toPrimitive(json);
    }

    public static String toString(JsonElement json) {
        StringWriter writer = new StringWriter();
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setSerializeNulls(true);
            jsonWriter.setLenient(true);
            jsonWriter.setHtmlSafe(false);
            Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return writer.toString();
    }

    public static String toPrettyString(JsonElement json) {
        StringWriter writer = new StringWriter();
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setIndent("\t");
            jsonWriter.setSerializeNulls(true);
            jsonWriter.setLenient(true);
            jsonWriter.setHtmlSafe(false);
            Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return writer.toString();
    }

    public static JsonElement fromString(@Nullable String string) {
        if (string == null || string.isEmpty() || string.equals("null")) {
            return JsonNull.INSTANCE;
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(string));
            boolean lenient = jsonReader.isLenient();
            jsonReader.setLenient(true);
            JsonElement element = Streams.parse((JsonReader)jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JsonNull.INSTANCE;
        }
    }

    @Nullable
    public static Object toPrimitive(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive p = element.getAsJsonPrimitive();
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isNumber()) {
                return p.getAsNumber();
            }
            try {
                Double.parseDouble(p.getAsString());
                return p.getAsNumber();
            }
            catch (Exception ex) {
                return p.getAsString();
            }
        }
        return null;
    }
}

