/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.util.TickTemporalUnit;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;

public record TickDuration(long ticks) implements TemporalAmount
{
    public static final TickDuration ZERO = new TickDuration(0L);
    private static final List<TemporalUnit> UNITS = List.of(TickTemporalUnit.INSTANCE);
    public static final Codec<TickDuration> CODEC = Codec.LONG.xmap(TickDuration::new, TickDuration::ticks);
    public static final Codec<TickDuration> SECONDS_CODEC = Codec.DOUBLE.xmap(l -> new TickDuration((long)(l * 20.0)), t -> (double)t.ticks() / 20.0);
    public static final Codec<TickDuration> MINUTES_CODEC = Codec.DOUBLE.xmap(l -> new TickDuration((long)(l * 1200.0)), t -> (double)t.ticks() / 1200.0);
    public static final Codec<TickDuration> HOURS_CODEC = Codec.DOUBLE.xmap(l -> new TickDuration((long)(l * 72000.0)), t -> (double)t.ticks() / 72000.0);
    public static final TypeInfo TYPE_INFO = TypeInfo.of(TickDuration.class);

    @Override
    public long get(TemporalUnit unit) {
        if (unit == TickTemporalUnit.INSTANCE) {
            return this.ticks;
        }
        return 0L;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return UNITS;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.ticks != 0L) {
            return temporal.plus(this.ticks, TickTemporalUnit.INSTANCE);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.ticks != 0L) {
            return temporal.minus(this.ticks, TickTemporalUnit.INSTANCE);
        }
        return temporal;
    }
}

